<?php
/**
* @version	$Id: reviews_tag_processor.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ReviewsTagProcessor extends kDBTagProcessor
{
	/**
	 * Returns a link for editing product
	 *
	 * @param Array $params
	 * @return string
	 */
	function ItemEditLink($params)
	{
		/** @var kDBList $object */
		$object = $this->getObject($params);

		$item_prefix = $this->Application->findModule('Name', $object->GetDBField('Module'), 'Var');
		$edit_template = $this->Application->getUnitOption($item_prefix, 'AdminTemplatePath') . '/' . $this->Application->getUnitOption($item_prefix, 'AdminTemplatePrefix') . 'edit';

		$url_params = Array (
			'm_opener'				=>	'd',
			$item_prefix.'_mode'	=>	't',
			$item_prefix.'_event'	=>	'OnEdit',
			$item_prefix.'_id'		=>	$object->GetDBField('CatalogItemId'),
			'm_cat_id'				=>	$object->GetDBField('CatalogItemCategory'),
			'pass'					=>	'all,'.$item_prefix,
			'no_pass_through'		=>	1,
		);

		return $this->Application->HREF($edit_template,'', $url_params);
	}

	function HelpfulLink($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		$parent_prefix = $this->Application->getUnitOption($this->Prefix, 'ParentPrefix');
		$params['events[' . $parent_prefix . ']'] = 'OnReviewHelpful';
		$params['review_id'] = $object->GetID();

		return $this->Application->ProcessParsedTag($parent_prefix, 'ItemLink', $params);
	}

	/**
	 * Prints overall rating statistics
	 *
	 * @param Array $params
	 * @return string
	 */
	protected function PrintRatingPercents($params)
	{
		static $cache = null;

		/** @var kDBItem $object */
		$object = $this->getObject($params);

		$parent_prefix = $this->Application->getUnitOption($this->Prefix, 'ParentPrefix');

		/** @var kCatDBItem $main_object */
		$main_object = $this->Application->recallObject($parent_prefix);

		if ( !isset($cache) ) {
			$sql = 'SELECT COUNT(*), Rating
					FROM ' . $object->TableName . '
					WHERE ItemId = ' . $main_object->GetDBField('ResourceId') . '
					GROUP BY Rating';
			$cache = $this->Conn->GetCol($sql, 'Rating');
		}

		$ratings = array_reverse( array_keys( $object->GetFieldOption('Rating', 'options') ) );

		if ( !isset($params['show_none']) || !$params['show_none'] ) {
			$none_index = array_search(0, $ratings);

			if ( $none_index !== false ) {
				unset($ratings[$none_index]);
			}
		}

		$ret = '';
		$total = array_sum($cache);
		$block_params = $this->prepareTagParams($params);
		$block_params['name'] = $params['render_as'];
		$block_params['strip_nl'] = 2;

		foreach ($ratings as $rating) {
			$block_params['rating'] = $rating;
			$block_params['count'] = isset($cache[$rating]) ? $cache[$rating] : 0;
			$block_params['percent'] = $total ? round(($block_params['count'] / $total) * 100) : 0;

			$ret .= $this->Application->ParseBlock($block_params);
		}

		return $ret;
	}

	/**
	 * Returns requested field value
	 *
	 * @param Array $params
	 * @return string
	 * @access public
	 */
	function Field($params)
	{
		$field = $this->SelectParam($params, 'name,field');

		/** @var kDBItem $object */
		$object = $this->getObject($params);

		if ($field == 'ReviewText') {
			if ($object->GetDBField('TextFormat') == 1) {
				$params['no_special'] = 'no_special';
			}
			else {
				unset($params['no_special']);
			}
		}

		return parent::Field($params);
	}

	function AlreadyReviewed($params)
	{
		$parent_prefix = $this->Application->getUnitOption($this->Prefix, 'ParentPrefix');

		/** @var kCatDBItem $main_object */
		$main_object = $this->Application->recallObject($parent_prefix);

		/** @var SpamHelper $spam_helper */
		$spam_helper = $this->Application->recallObject('SpamHelper');

		$spam_helper->InitHelper($main_object->GetDBField('ResourceId'), 'Review', 0, $main_object->GetCol('ResourceId'));

		return $spam_helper->InSpamControl();
	}

	function HasError($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		return method_exists($object, 'GetErrorMsg') ? parent::HasError($params) : 0;
	}

	/**
	 * Preserve main item id in subitem pagination url
	 *
	 * @param Array $params
	 * @return string
	 */
	function PageLink($params)
	{
		/** @var kDBList $object */
		$object = $this->getObject($params);

		$parent_info = $object->getLinkedInfo();

		if ($parent_info['ParentId'] > 0) {
			$params['pass'] = 'm,'.$this->getPrefixSpecial().','.$parent_info['ParentPrefix'];
		}

		return parent::PageLink($params);
	}

	function InitCatalogTab($params)
	{
		$tab_params['mode'] = $this->Application->GetVar('tm'); // single/multi selection possible
		$tab_params['special'] = $this->Application->GetVar('ts'); // use special for this tab
		$tab_params['dependant'] = $this->Application->GetVar('td'); // is grid dependant on categories grid

		// set default params (same as in catalog)
		if ($tab_params['mode'] === false) $tab_params['mode'] = 'multi';
		if ($tab_params['special'] === false) $tab_params['special'] = '';
		if ($tab_params['dependant'] === false) $tab_params['dependant'] = 'yes';

		// pass params to block with tab content
		$params['name'] = $params['render_as'];
		$params['prefix'] = trim($this->Prefix.'.'.($tab_params['special'] ? $tab_params['special'] : $this->Special), '.');

		$params['cat_prefix'] = trim('c.'.($tab_params['special'] ? $tab_params['special'] : $this->Special), '.');
		$params['tab_mode'] = $tab_params['mode'];
		$params['grid_name'] = ($tab_params['mode'] == 'multi') ? $params['default_grid'] : $params['radio_grid'];
		$params['tab_dependant'] = $tab_params['dependant'];
		$params['show_category'] = $tab_params['special'] == 'showall' ? 1 : 0; // this is advanced view -> show category name
		$params['tab_name'] = $this->Application->GetVar('tab_name');

		return $this->Application->ParseBlock($params, 1);
	}

	/**
	 * Returns reviews count for each item type (in "Reviews" section)
	 *
	 * @param Array $params
	 * @return string
	 */
	function CatalogItemCount($params)
	{
		$params['skip_quering'] = true;
		$object =& $this->GetList($params);

		return $object->GetRecordsCount(false) != $object->GetRecordsCount() ? $object->GetRecordsCount().' / '.$object->GetRecordsCount(false) : $object->GetRecordsCount();
	}

	/**
	 * Dynamic votes indicator
	 *
	 * @param Array $params
	 *
	 * @return string
	 */
	function VotesIndicator($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		/** @var RatingHelper $rating_helper */
		$rating_helper = $this->Application->recallObject('RatingHelper');

		$rating = isset($params['rating']) ? $params['rating'] : $object->GetDBField('Rating');
		$small_style = array_key_exists('small_style', $params) ? $params['small_style'] : false;

		return $rating_helper->ratingBarSimple($rating, '', null, $small_style);
	}
}
