<?php
	$heading_tpl = '
		<tr class="subsectiontitle">
			<td class="text" colspan="2" style="border-top: 1px solid #000000; border-bottom: 1px solid #000000;">%s</td>
		</tr>';

	$error_tpl = '
		<tr class="table-color2">
			<td class="text">%s</td>
		  	<td align="center" width="30">%s</td>
		</tr>';

	$check_titles = Array (
		'php_version' => 'PHP version 5.3.2 or above<span class="error">*</span>',
		'url_rewriting' => 'URL rewriting support',
		'java' => 'Java template compression',
		'composer' => 'Dependencies via Composer<span class="error">*</span>',
		'sep1' => '<strong>PHP extensions:</strong>',
		'memcache' => '- Memory caching support',
		'curl' => '- Accessing remote resources (via cURL)<span class="error">*</span>',
		'simplexml' => '- XML document processing (via SimpleXML)<span class="error">*</span>',
		'spl' => '- Standard PHP Library (SPL)<span class="error">*</span>',
		'freetype' => '- TrueType font support (via Freetype)<span class="error">*</span>',
		'gd_version' => '- GD Graphics Library 1.8 or above<span class="error">*</span>',
		'jpeg' => '- JPEG images support<span class="error">*</span>',
		'mysql' => '- Database connectivity (via MySQL)<span class="error">*</span>',
		'json' => '- JSON processing support<span class="error">*</span>',
		'sep2' => '<strong>PHP settings:</strong>',
		'memory_limit' => "- Memory requirements changing on the fly",
		'display_errors' => "- Prevent script errors in production environment",
		'error_reporting' => "- Change error detalization level",
		'date.timezone' => "- Web server timezone is explicitly set<span class=\"error\">*</span>",
		'variables_order' => '- Needed super-global arrays registered',
		'output_buffering' => "- Script output buffering enabled<span class=\"error\">*</span>",
	);

	$output = sprintf($heading_tpl, '<strong>Server-side requirements</strong>');
	$check_results = $this->toolkit->CallPrerequisitesMethod('core/', 'CheckSystemRequirements');

	foreach ($check_titles AS $key => $title) {
		if ( substr($key, 0, 3) == 'sep' ) {
			$check_result = '';
		}
		else {
			$check_result = $check_results[$key] ? '[<span style="color:green;">PASSED</span>]' : '[<span class="error">FAILED</span>]';
		}

		$output .= sprintf($error_tpl, $title, $check_result);
	}

	$output .= sprintf($heading_tpl, '<strong>Client-side requirements</strong>', 'text');
	$output .= sprintf($error_tpl, 'Cookies enabled', '[<span class="error" id="cookies_enabled_mark">FAILED</span>]');
	$output .= sprintf($error_tpl, 'JavaScript enabled', '[<span class="error" id="js_enabled_mark">FAILED</span>]');

	$output .= '<input type="hidden" name="js_enabled" id="js_enabled" value="0"/>';
	$output .= '<input type="hidden" name="cookies_enabled" id="cookies_enabled" value="0"/>';

	$output .= "<script type='text/javascript'>
					\$('#js_enabled').val(1);
					\$('#js_enabled_mark').removeClass('error').css('color', 'green').html('PASSED');

					document.cookie = 'install_cookie_test=1';
					var \$cookies_enabled = document.cookie.indexOf('install_cookie_test') != -1;

					if ( \$cookies_enabled ) {
						\$('#cookies_enabled').val(1);
						\$('#cookies_enabled_mark').removeClass('error').css('color', 'green').html('PASSED');
					}
				</script>";

	echo $output;
?>
