CKEDITOR.dialog.add(
	'my_document',
	function( editor ) {
		var pluginName = 'my_document';
		var plugin = CKEDITOR.plugins.my_document;

		var targetChanged = function() {
			var dialog = this.getDialog();
			var $element = dialog.getContentElement( 'page1', 'popupOptions' );

			$element = $element.getElement().getParent().getParent();

			if ( dialog.getContentElement( 'page1', 'cmbTarget' ).getValue() == 'popup' ) {
				$element.show();
			}
			else {
				$element.hide();
			}
		};

		var makeRelativeUrl = function ($url) {
			if ( $url.indexOf(':/') == -1 && path.slice(0, 2) != '//' ) {
				return $url;
			}

			var $link = document.createElement('a');

			$link.href = $url;

			return $link.pathname;
		};

		var parseLink = function( editor ) {
			var retval = {
					documentUrl: '',
					documentTitle: '',
					target: '',
					iconType: 'none',
					iconUrl: ''
				},
				targetRegExp = /^_(blank|self)$/i,
				popupRegExp = /^\s*on[cC]lick="\s*FCKOpenPopUp\(\s*this\s*,\s*event\s*,\s*[0-9]+\s*,\s*[0-9]+\s*\);"$/;

			if ( this.linkElement ) {
				retval.documentUrl = this.linkElement.getAttribute('href');
				retval.documentTitle = this.linkElement.getText().trim();

				var $id = this.linkElement.getAttribute('id');

				if ( $id && $id.match(/^Doc_|_+/) ) {
					var $document_properties = $id.split('_|_'); // "Doc_", Filename, IconType
					var $icon_types = ['doc', 'pdf', 'image', 'excel', 'ppt', 'audio', 'video', 'none'];

					retval.iconType = $document_properties[2];

					if ( !in_array(retval.iconType, $icon_types) ) {
						retval.iconUrl = retval.iconType;
						retval.iconType = 'other';
					}
				}

				var $target = this.linkElement.getAttribute('target');

				if ( $target && $target.match(targetRegExp) ) {
					retval.target = $target.toLowerCase();
				}
			}

			return retval;
		};


		return {
			title : 'Document Properties',
			minWidth : 450,
			minHeight : 250,
			contents : [{
				id: 'page1',
				label: 'Page1',
				accessKey: 'P',
				elements: [
					// begin of page1 elements

					{
                        type: 'vbox',
                        width: '400px',
                        children: [
                        	// begin of 1st vbox

							{
								type : 'vbox',
								padding : 0,
								children :
								[
									{
										type : 'hbox',
										widths : [ '280px', '110px' ],
										align : 'right',
										children :
										[
											{
												id : 'docUrl',
												type : 'text',
												label : 'Document (address or file path)',
												required: true,
												validate : CKEDITOR.dialog.validate.notEmpty( 'Document is missing' ),
												setup: function ( data ) {
													this.allowOnChange = false;
													this.setValue( data.documentUrl );
													this.allowOnChange = true;
												},
												commit: function ( data ) {
													data.documentUrl = this.getValue();
												}
											},
											{
												type : 'button',
												id : 'browse',
												style : 'display:inline-block;margin-top:10px;',
												align : 'center',
												label : editor.lang.common.browseServer,
												hidden : true,
												filebrowser : {
													action : 'Browse',
													target: 'page1:docUrl',
													url: editor.config.filebrowserDocumentBrowseUrl
												},
											}
										]
									}
								]
							},

							{
								id : 'txtTitle',
								type : 'text',
								label : 'Document title',
								labelLayout: 'horizontal',
								required: true,
								validate : CKEDITOR.dialog.validate.notEmpty( 'Document title is missing' ),
								widths: ['90px', 'auto'],
								setup: function ( data ) {
									this.allowOnChange = false;
									this.setValue( data.documentTitle );
									this.allowOnChange = true;
								},
								commit: function ( data ) {
									data.documentTitle = this.getValue();
								}
							},

							{
								id : 'cmbTarget',
								type : 'select',
								label : editor.lang.common.target,
								labelLayout: 'horizontal',
								widths: ['90px', 'auto'],
								'default' : '',
								items :
								[
									[ editor.lang.common.targetSelf , ''],
									[ editor.lang.common.targetNew , '_blank'],
									[ editor.lang.link.targetPopup , 'popup']
								],
								onChange: targetChanged,
								setup: function ( data ) {
									this.allowOnChange = false;
									this.setValue( data.target );
									this.allowOnChange = true;
								},
								commit: function ( data ) {
									data.target = this.getValue();
								}
							},

							{
								type : 'hbox',
								id : 'popupOptions',
								widths : [ '70px', '70px' ],
								align : 'left',
								children :
								[
									{
										id : 'txtPopupWidth',
										type : 'text',
										label : 'PopUp Width',
										labelLayout: 'horizontal',
										widths: ['90px', 'auto']
									},
									{
										id : 'txtPopupHeight',
										type : 'text',
										label : 'PopUp Height',
										labelLayout: 'horizontal',
										widths: ['90px', 'auto']
									}
								]
							},

							{
								type : 'radio',
								id : 'image_type',
								label : 'ICON',
								items : [
									[ '<img src="' + CKEDITOR.plugins.getPath(pluginName)  + 'images/doc.gif"/><br/>Word', 'doc' ],
									[ '<img src="' + CKEDITOR.plugins.getPath(pluginName)  + 'images/pdf.gif"/><br/>PDF', 'pdf' ],
									[ '<img src="' + CKEDITOR.plugins.getPath(pluginName)  + 'images/image.gif"/><br/>Image', 'image' ],
									[ '<img src="' + CKEDITOR.plugins.getPath(pluginName)  + 'images/excel.gif"/><br/>Excel', 'excel' ],
									[ '<img src="' + CKEDITOR.plugins.getPath(pluginName)  + 'images/ppt.gif"/><br/>PowerPoint', 'ppt' ],
									[ '<img src="' + CKEDITOR.plugins.getPath(pluginName)  + 'images/audio.gif"/><br/>Audio', 'audio' ],
									[ '<img src="' + CKEDITOR.plugins.getPath(pluginName)  + 'images/video.gif"/><br/>Video', 'video' ],
									[ '<br/>None', 'none' ]
								] ,
								'default' : 'none',
								onClick : function() {
									var $other_element = this.getDialog().getContentElement('page1', 'image_type2');

									$other_element.allowOnChange = false;
									$other_element.setValue('');
									$other_element.allowOnChange = true;
								},
								setup: function ( data ) {
									this.allowOnChange = false;
									this.setValue( data.iconType );
									this.allowOnChange = true;
								},
								commit: function ( data ) {
									var $icon_type = this.getValue();

									if ( $icon_type ) {
										data.iconType = $icon_type;
									}
								}
							},

							{
								type : 'vbox',
								padding : 0,
								children :
								[
									{
										type : 'hbox',
										widths : [ '50px', 'auto', 'auto' ],
										align : 'right',
										children :
										[
											{
												type : 'radio',
												id : 'image_type2',
												label : '',
												labelLayout: 'horizontal',
												widths : [ '0px', 'auto' ],
												items : [
													[ 'Other', 'other' ]
												] ,
												onClick : function() {
													var $other_element = this.getDialog().getContentElement('page1', 'image_type');

													this.allowOnChange = false;
													$other_element.setValue('');
													this.allowOnChange = true;
												},
												setup: function ( data ) {
													this.allowOnChange = false;
													this.setValue( data.iconType );
													this.allowOnChange = true;
												},
												commit: function ( data ) {
													var $icon_type = this.getValue();

													if ( $icon_type ) {
														data.iconType = $icon_type;
													}
												}
											},
											{
												id : 'otherUrl',
												type : 'text',
												label : '',
												setup: function ( data ) {
													this.allowOnChange = false;
													this.setValue( data.iconUrl );
													this.allowOnChange = true;
												},
												commit: function ( data ) {
													data.iconUrl = this.getValue();
												}
											},
											{
												type : 'button',
												id : 'browse_icon',
												style : 'display:inline-block;margin-top:-6px;',
												align : 'center',
												label : editor.lang.common.browseServer,
												hidden : true,
												filebrowser : {
													action : 'Browse',
													target: 'page1:otherUrl',
													url: editor.config.filebrowserImageBrowseUrl
												},
											}
										]
									}
								]
							},

							// end of 1st vbox
                        ]
                    }

					// end of page1 elements
				]
			}],

			onShow: function() {
				this.linkElement = false;
				this.iconElement = false;

				var editor = this.getParentEditor(),
					selection = editor.getSelection();

				// Fill in all the relevant fields if there's already one link selected.

				var element = CKEDITOR.plugins.link.getSelectedLink(editor);

				if ( element && element.hasAttribute('href') ) {
					this.linkElement = element;
					this.iconElement = element.getChild(0);

					selection.selectElement( element );
				}
				else {
					element = selection.getSelectedElement();

					if ( element && element.is('img') ) {
						this.iconElement = element;
						this.linkElement = element.getParent();

						element = this.linkElement;
						selection.selectElement(element);
					}
					else {
						element = null;
					}
				}

				this.setupContent( parseLink.apply( this, [ editor ] ) );
			},

			onOk : function() {
				var data = {},
					editor = this.getParentEditor();

				this.commitContent( data );

				var $filename = data.documentUrl.slice(data.documentUrl.lastIndexOf('\/') + 1);
				var $icon_url = makeRelativeUrl(CKEDITOR.basePath).split('/');

				$icon_url.splice($icon_url.length - 3); // remove "/core/ckeditor/"
				$icon_url = $icon_url.join('/') + editor.config.documentIconsUrl;

				var $icon_image = '';
				var $image_tag = data.iconType;

				if (data.iconType == 'other') {
					$image_tag = data.iconUrl;
					$icon_image = '<img src="' + data.iconUrl + '" border="0" alt="' + data.documentTitle + '">';
				}
				else if (data.iconType != 'none') {
					$icon_image = '<img src="' + $icon_url + '/' + data.iconType + '.gif" border="0" alt="' + data.documentTitle + '"> ';
				}

				if ( data.target != '' ) {
					var $new_html = '<a href="' + data.documentUrl + '" id="Doc_|_' + $filename + '_|_' + $image_tag + '" alt="' + data.documentTitle + '" target="' + data.target + '">' + $icon_image + data.documentTitle + '</a> ';
				}
				else {
					var $new_html = '<a href="' + data.documentUrl + '" id="Doc_|_' + $filename + '_|_' + $image_tag + '" alt="' + data.documentTitle + '">' + $icon_image + data.documentTitle + '</a> ';
				}

				editor.insertHtml($new_html);
			}

		};
	}
);
