<?php
/**
* @version	$Id: class_locator.php 16376 2016-07-25 08:41:31Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2016 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

$start = microtime(true);

define('DBG_ZEND_PRESENT', 1);
define('INDEX_FILE', 'index.php');
define('FULL_PATH', realpath(dirname(__FILE__) . '/..'));

include_once(FULL_PATH . '/core/kernel/startup.php');

$application = kApplication::Instance();
$application->Init();

/** @var \Composer\Autoload\ClassLoader $composer_class_loader */
$composer_class_loader = require FULL_PATH . '/vendor/autoload.php';

return function ($class) use ($application, $composer_class_loader) {
	$file = $application->findClassFile($class);

	if ( $file !== false ) {
		return $file;
	}

	return $composer_class_loader->findFile($class);
};
