<?php
/**
* @version	$Id: phrases_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'phrases',

	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'PhrasesEventHandler', 'file' => 'phrases_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'PhraseTagProcessor', 'file' => 'phrase_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'label', // labels can be edited directly
		6 => 'mode',
	),

	'IDField' => 'PhraseId',
	'TitleField' => 'Phrase',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('phrases' => '!la_title_Adding_Phrase!'),
			'edit_status_labels' => Array ('phrases' => '!la_title_Editing_Phrase!'),
		),

		'phrase_edit' => Array (
			'prefixes' => Array ('phrases'), 'format' => '#phrases_status# #phrases_titlefield#',
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),

		// for separate phrases list
		'phrases_list_st' => Array (
			'prefixes' => Array ('phrases_List'), 'format' => "!la_title_Phrases!",
			'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'export', 'view', 'dbl-click'),
		),

		'phrase_edit_single' => Array (
			'prefixes' => Array ('phrases'), 'format' => '#phrases_status# #phrases_titlefield#',
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:phrases'),

	'Sections' => Array (
		// "Phrases"
		'in-portal:phrases' => Array (
			'parent' => 'in-portal:site',
			'icon' => 'phrases_labels',
			'label' => 'la_title_Phrases',
			'url' => Array ('t' => 'languages/phrase_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
//			'perm_prefix' => 'lang',
			'priority' => 4,
//			'show_mode' => smSUPER_ADMIN,
			'type' => stTREE,
		),
	),

	'FilterMenu' => Array (
		'Groups' => Array (
			Array ('mode' => 'AND', 'filters' => Array ('translated', 'not_translated'), 'type' => kDBList::HAVING_FILTER),
		),
		'Filters' => Array (
			'translated' => Array ('label' => 'la_PhraseTranslated', 'on_sql' => '', 'off_sql' => 'CurrentTranslation IS NULL'),
			'not_translated' => Array ('label' => 'la_PhraseNotTranslated', 'on_sql' => '', 'off_sql' => 'CurrentTranslation IS NOT NULL'),
		)
	),

	'TableName' => TABLE_PREFIX . 'LanguageLabels',

	'CalculatedFields' => Array (
		'' => Array (
			'PrimaryTranslation' => 'l%4$s_Translation',
			'CurrentTranslation' => 'l%5$s_Translation',
			'CurrentHintTranslation' => 'l%5$s_HintTranslation',
			'CurrentColumnTranslation' => 'l%5$s_ColumnTranslation',
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Phrase' => 'asc'),
		)
	),

	'Fields' => Array (
		'PhraseId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'Phrase' => Array (
			'type' => 'string',
			'formatter' => 'kFormatter', 'regexp' => '/^(la|lu|lc)_[A-Z\d:_\-\.]+$/i', 'unique' => Array (),
			'not_null' => 1, 'required' => 1, 'default' => '',
		),
		'PhraseKey' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'Translation' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'required' => 1, 'using_fck' => 1, 'default' => NULL, 'db_type' => 'text'),
		'HintTranslation' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'using_fck' => 1, 'default' => NULL, 'db_type' => 'text'),
		'ColumnTranslation' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'using_fck' => 1, 'default' => NULL, 'db_type' => 'text'),
		'PhraseType' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_PhraseType_Front', 1 => 'la_PhraseType_Admin', 2 => 'la_PhraseType_Both'), 'use_phrases' => 1,
			'not_null' => 1, 'required' => 1, 'default' => Language::PHRASE_TYPE_COMMON,
		),
		'LastChanged' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		'LastChangeIP' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'Module' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Modules WHERE (Loaded = 1) AND (Name <> "In-Portal") ORDER BY LoadOrder', 'option_key_field' => 'Name', 'option_title_field' => 'Name',
			'not_null' => 1, 'required' => 1, 'default' => 'Core'
		),
	),

	'VirtualFields' => Array (
		'PrimaryTranslation' => Array ('type' => 'string', 'default' => ''),
		'CurrentTranslation' => Array ('type' => 'string', 'default' => ''),
		'CurrentHintTranslation' => Array ('type' => 'string', 'default' => ''),
		'CurrentColumnTranslation' => Array ('type' => 'string', 'default' => ''),

		// for language pack import/export
		'LangFile' => Array (
			'type' => 'string',
			'formatter' => 'kUploadFormatter',
			'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => WRITEBALE_BASE . '/',
			'max_len' => 255, 'default' => ''
		),
		'ImportOverwrite' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array(
				0 => 'la_No',
				1 => 'la_Yes',
			),
			'use_phrases' => 1, 'default' => 0,
		),
		'DoNotEncode' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (
				0 => 'la_No',
				1 => 'la_Yes',
			),
			'use_phrases' => 1, 'default' => 0,
		),
		'ExportPhrases' => Array ('type' => 'string', 'default' => ''),
		'ExportEmailTemplates' => Array ('type' => 'string', 'default' => ''),
		'ExportCountries' => Array ('type' => 'string', 'default' => ''),
		'ExportDataTypes' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter', 'options' => Array ('phrases' => 'la_opt_Phrases', 'email-template' => 'la_opt_EmailTemplates', 'country-state' => 'la_opt_Countries'), 'use_phrases' => 1, 'multiple' => 1,
			'default' => '|phrases|email-template|country-state|'
		),
	),

	'Grids' => Array (
		// used on "Phrases" tab in language editing in "Regional" section
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				0 => 'icon16_disabled.png',
				1 => 'icon16_item.png',
			),
			'Fields' => Array (
				'PhraseId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50),
				'Phrase' => Array ('title' => 'la_col_Label', 'data_block' => 'grid_checkbox_td', 'width' => 200),
				'CurrentTranslation' => Array ('title' => 'column:la_fld_Phrase', 'width' => 200),
				'PrimaryTranslation' => Array ('title' => 'la_col_PrimaryValue', 'width' => 200),
				'PhraseType' => Array ('filter_block' => 'grid_options_filter', 'width' => 60),
				'LastChanged' => Array ('title' => 'column:la_fld_Modified', 'filter_block' => 'grid_date_range_filter', 'width' => 150),
				'Module' => Array ('filter_block' => 'grid_multioptions_filter', 'width' => 100),
				'CurrentHintTranslation' => Array ('title' => 'la_col_HintPhrase', 'width' => 200, 'hidden' => 1),
				'CurrentColumnTranslation' => Array ('title' => 'la_col_ColumnPhrase', 'width' => 200, 'hidden' => 1),
			),
		),

		// used on "Labels & Phrases" section
		'Phrases' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				0 => 'icon16_disabled.png',
				1 => 'icon16_item.png',
			),
			'Fields' => Array (
				'PhraseId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50),
				'Phrase' => Array ('title' => 'la_col_Label', 'filter_block' => 'grid_like_filter', 'width' => 170),
				'CurrentTranslation' => Array ('title' => 'column:la_fld_Phrase', 'filter_block' => 'grid_like_filter', 'width' => 180),
				'PhraseType' => Array ('title' => 'column:la_fld_Location', 'filter_block' => 'grid_multioptions_filter', 'width' => 80),
				'LastChanged' => Array ('title' => 'column:la_fld_Modified', 'filter_block' => 'grid_date_range_filter', 'width' => 145),
				'Module' => Array ('filter_block' => 'grid_multioptions_filter', 'width' => 100),
				'CurrentHintTranslation' => Array ('title' => 'la_col_HintPhrase', 'width' => 200, 'hidden' => 1),
				'CurrentColumnTranslation' => Array ('title' => 'la_col_ColumnPhrase', 'width' => 200, 'hidden' => 1),
			),
		),
	),
);
