<?php
/**
* @version	$Id: configuration_tag_processor.php 15471 2012-07-23 17:10:50Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ConfigurationTagProcessor extends kDBTagProcessor {

	public function __construct()
	{
		parent::__construct();

		$this->Application->LinkVar('module_key');
	}

	/**
	 * Prints list content using block specified
	 *
	 * @param Array $params
	 * @return string
	 * @access public
	 */
	function PrintList($params)
	{
		$list =& $this->GetList($params);
		$id_field = $this->Application->getUnitOption($this->Prefix, 'IDField');

		$list->Query();
		$o = '';
		$list->GoFirst();

		$block_params = $this->prepareTagParams($params);
		$block_params['pass_params'] = 'true';
		$block_params['IdField'] = $list->IDField;

		$prev_heading = '';
		$next_block = $params['full_block'];
		$list->groupRecords('Heading');
		$field_values = $this->Application->GetVar($this->getPrefixSpecial(true));

		while (!$list->EOL()) {
			$this->Application->SetVar($this->getPrefixSpecial() . '_id', $list->GetDBField($id_field)); // for edit/delete links using GET

			// using 2 blocks for drawing o row in case if current & next record titles match
			$next_record =& $list->getCurrentRecord(1);
			$this_key = $list->GetDBField('Prompt') . ':' . $list->GetDBField('DisplayOrder');
			$next_key = $next_record !== false ? $next_record['Prompt'] . ':' . $next_record['DisplayOrder'] : '';

			if ( $next_key == $this_key ) {
				$curr_block = $params['half_block1'];
				$next_block = $params['half_block2'];
			}
			else {
				$curr_block = $next_block;
				$next_block = $params['full_block'];
			}

			$variable_name = $list->GetDBField('VariableName');

			// allows to override value part of block
			if ( $this->Application->ParserBlockFound('cf_' . $variable_name . '_value') ) {
				$block_params['value_render_as'] = 'cf_' . $variable_name . '_value';
			}
			else {
				$block_params['value_render_as'] = $params['value_render_as'];
			}

			// allow to completely override whole block
			if ( $this->Application->ParserBlockFound('cf_' . $variable_name . '_element') ) {
				$block_params['name'] = 'cf_' . $variable_name . '_element';
				$block_params['original_render_as'] = $curr_block;
			}
			else {
				$block_params['name'] = $curr_block;
				$block_params['original_render_as'] = $curr_block;
			}

			$block_params['show_heading'] = ($prev_heading != $list->GetDBField('Heading')) ? 1 : 0;

			// set values from submit if any
			if ( $field_values ) {
				$list->SetDBField('VariableValue', $field_values[$list->GetID()]['VariableValue']);
			}
			$list->SetDBField('DirectOptions', '');

			$o .= $this->Application->ParseBlock($block_params);
			$prev_heading = $list->GetDBField('Heading');
			$list->GoNext();
		}

		$this->Application->RemoveVar('ModuleRootCategory');
		$this->Application->SetVar($this->getPrefixSpecial() . '_id', '');

		return $o;
	}

	function getModuleItemName()
	{
		$module = $this->Application->GetVar('module');
		$table = $this->Application->getUnitOption('confs', 'TableName');

		$sql = 'SELECT ConfigHeader
				FROM '.$table.'
				WHERE ModuleName = '.$this->Conn->qstr($module);
		return $this->Conn->GetOne($sql);
	}

	function PrintConfList($params)
	{
		$list =& $this->GetList($params);
		$id_field = $this->Application->getUnitOption($this->Prefix, 'IDField');

		$list->Query();
		$o = '';
		$list->GoFirst();

		$tmp_row = Array();

		while (!$list->EOL()) {
			$rec = $list->getCurrentRecord();
			$tmp_row[0][$rec['VariableName']] = $rec['VariableValue'];
			$tmp_row[0][$rec['VariableName'].'_prompt'] = $rec['Prompt'];
			$list->GoNext();
		}

		$list->Records = $tmp_row;

		$block_params = $this->prepareTagParams($params);
		$block_params['name'] = $this->SelectParam($params, 'render_as,block');
		$block_params['module_key'] = $this->Application->GetVar('module_key');
		$block_params['module_item'] = $this->getModuleItemName();
		$list->GoFirst();

		return $this->Application->ParseBlock($block_params);

	}

	function ShowRelevance($params)
	{
		return $this->Application->GetVar('module_key') != '_';
	}

	function ConfigValue($params)
	{
		return $this->Application->ConfigValue($params['name']);
	}

	function IsRequired($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$field = $params['field'];
		$field_options = $object->GetFieldOptions($field);

		if ( $field == 'VariableValue' ) {
			$custom_options = $object->GetDBField('Validation');

			if ( $custom_options ) {
				$field_options = array_merge($field_options, unserialize($custom_options));
			}
		}

		return isset($field_options['required']) && $field_options['required'];
	}

	function Error($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBList */

		if ( !($object instanceof kDBList) ) {
			return parent::Error($params);
		}

		$field = $object->GetDBField($params['id_field']);
		$errors = $this->Application->GetVar('errors_' . $this->getPrefixSpecial(), Array ());

		return array_key_exists($field, $errors) ? $errors[$field] : '';
	}

	/**
	 * Allows to show category path of selected module
	 *
	 * @param Array $params
	 * @return string
	 */
	function CategoryPath($params)
	{
		if (!isset($params['cat_id'])) {
			$params['cat_id'] = $this->ModuleRootCategory( Array() );
		}

		$navigation_bar = $this->Application->recallObject('kNavigationBar');
		/* @var $navigation_bar kNavigationBar */

		return $navigation_bar->build($params);
	}

	/**
	 * Shows edit warning in case if module root category changed but not saved
	 *
	 * @param Array $params
	 * @return string
	 */
	function SaveWarning($params)
	{
		$temp_category_id = $this->Application->RecallVar('ModuleRootCategory');
		if ($temp_category_id !== false) {
			return $this->Application->ParseBlock($params);
		}
		return '';
	}

	function ModuleRootCategory($params)
	{
		$category_id = $this->Application->RecallVar('ModuleRootCategory');
		if ($category_id === false) {
			$category_id = $this->Application->findModule('Name', $this->Application->GetVar('module'), 'RootCat');
		}
		return $category_id;
	}

	/**
	 * Returns variable ID by it's name (used on search relevance configuration screen)
	 *
	 * @param Array $params
	 * @return int
	 */
	function GetVariableID($params)
	{
		static $cached_ids = Array ();

		$var_name = $params['name'];
		if (!isset($cached_ids[$var_name])) {
			$id_field = $this->Application->getUnitOption($this->Prefix, 'IDField');
			$table_name = $this->Application->getUnitOption($this->Prefix, 'TableName');

			$sql = 'SELECT '.$id_field.'
					FROM '.$table_name.'
					WHERE VariableName = '.$this->Conn->qstr($params['name']);
			$cached_ids[$var_name] = $this->Conn->GetOne($sql);
		}

		return $cached_ids[$var_name];
	}

	function GetVariableSection($params)
	{
		static $cached_sections = Array ();

		$var_name = $params['name'];
		if (!isset($cached_sections[$var_name])) {
			$id_field = $this->Application->getUnitOption($this->Prefix, 'IDField');
			$table_name = $this->Application->getUnitOption($this->Prefix, 'TableName');

			$sql = 'SELECT Section
					FROM '.$table_name.'
					WHERE VariableName = '.$this->Conn->qstr($params['name']);
			$cached_sections[$var_name] = $this->Conn->GetOne($sql);
		}

		return $cached_sections[$var_name];
	}

	/**
	 * Returns system setting editing link
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function ItemEditLink($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$params['m_opener'] = 'd';
		$params[$object->Prefix . '_mode'] = 't';
		$params[$object->Prefix . '_event'] = 'OnEdit';
		$params[$object->Prefix . '_id'] = $object->GetID();
		$params['pass'] = 'all,' . $object->Prefix;

		return $this->Application->ProcessParsedTag('m', 'Link', $params);

	}
}