<?php
/**
* @version	$Id: event_handler.php 16411 2016-11-13 20:00:18Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Note:
	 *   1. When addressing variables from submit containing
	 *	 	Prefix_Special as part of their name use
	 *	 	$event->getPrefixSpecial(true) instead of
	 *	 	$event->getPrefixSpecial() as usual. This is due PHP
	 *	 	is converting "." symbols in variable names during
	 *	 	submit info "_". $event->getPrefixSpecial optional
	 *	 	1st parameter returns correct current Prefix_Special
	 *	 	for variables being submitted such way (e.g. variable
	 *	 	name that will be converted by PHP: "users.read_only_id"
	 *	 	will be submitted as "users_read_only_id".
	 *
	 *	 2.	When using $this->Application->LinkVar on variables submitted
	 *		from the form which contains $Prefix_Special then note 1st item.
	 * 		Example: LinkVar($event->getPrefixSpecial(true).'_varname', $event->getPrefixSpecial().'_varname')
	 *
	 */

	/**
	 * Default event handler. Mostly abstract class
	 *
	 */
	class kEventHandler extends kBase {

		/**
		 * In case if event should be handled with method, which name differs from
		 * event name, then it should be specified here.
		 * key - event name, value - event method
		 *
		 * @var Array
		 * @access protected
		 */
		protected $eventMethods = Array ();

		/**
		 * Defines mapping vs event names and permission names
		 *
		 * @var Array
		 * @access protected
		 */
		protected $permMapping = Array ();

		public function __construct()
		{
			parent::__construct();

			$this->mapEvents();
			$this->mapPermissions();
		}

		/**
		 * Define alternative event processing method names
		 *
		 * @return void
		 * @see kEventHandler::$eventMethods
		 * @access protected
		 */
		protected function mapEvents()
		{

		}

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{

		}

		/**
		 * Returns prefix and special (when present) joined by a "."
		 *
		 * @return string
		 * @access private
		 */
		public function getPrefixSpecial()
		{
			throw new Exception('Usage of getPrefixSpecial() method is forbidden in kEventHandler class children. Use $event->getPrefixSpecial(true); instead');
		}

		/**
		 * Executes event, specified in $event variable
		 *
		 * @param kEvent $event
		 * @return void
		 * @access public
		 */
		public function processEvent(kEvent $event)
		{
			$event_name = $this->getEventMethod($event);

			$this->$event_name($event);
		}

		/**
		 * Returns method name, that should called to process given event.
		 * When no such method exists and exception is thrown.
		 *
		 * @param kEvent $event
		 * @return string
		 * @throws Exception
		 */
		public function getEventMethod(kEvent $event)
		{
			$event_name = $event->Name;

			if ( array_key_exists($event_name, $this->eventMethods) ) {
				$event_name = $this->eventMethods[$event_name];
			}

			if ( method_exists($this, $event_name) ) {
				return $event_name;
			}
			elseif ( $this->getAjaxSubEventName($event) != '' ) {
				return 'wrapForAjax';
			}

			throw new Exception('Event "<strong>' . $event->Name . '</strong>" not implemented in class "<strong>' . get_class($this) . '</strong>"');
		}

		/**
		 * Automatically wraps events in Ajax calls
		 *
		 * @param kEvent $event
		 *
		 * @return void
		 */
		protected function wrapForAjax(kEvent $event)
		{
			$ajax_form_helper = $this->Application->recallObject('AjaxFormHelper');
			/* @var $ajax_form_helper AjaxFormHelper */

			$ajax_form_helper->transitEvent($event, $this->getAjaxSubEventName($event));
		}

		/**
		 * Sample dummy event
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBuild(kEvent $event)
		{

		}

		/**
		 * Returns to previous template in opener stack
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnGoBack(kEvent $event)
		{
			$url = $this->Application->RecallVar('export_finish_url');

			if ( $url ) {
				$this->Application->Redirect('external:' . $url);
			}

			$event->SetRedirectParam('opener', 'u');
		}

		/**
		 * Apply some special processing to object being
		 * recalled before using it in other events that
		 * call prepareObject
		 *
		 * @param kDBItem|kDBList $object
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function prepareObject(&$object, kEvent $event)
		{

		}

		/**
		 * Checks user permission to execute given $event
		 *
		 * @param kEvent $event
		 * @return bool
		 * @access public
		 */
		public function CheckPermission(kEvent $event)
		{
			$perm_helper = $this->Application->recallObject('PermissionsHelper');
			/* @var $perm_helper kPermissionsHelper */

			if ( !isset($this->permMapping[$event->Name]) ) {
				$ajax_event_name = $this->getAjaxSubEventName($event);

				if ( $ajax_event_name != '' && isset($this->permMapping[$ajax_event_name]) ) {
					$this->permMapping[$event->Name] = $this->permMapping[$ajax_event_name];
				}
			}

			return $perm_helper->CheckEventPermission($event, $this->permMapping);
		}

		/**
		 * Returns event name, that can be wrapped in AJAX response.
		 *
		 * @param kEvent $event Event.
		 *
		 * @return string
		 */
		protected function getAjaxSubEventName(kEvent $event)
		{
			if ( method_exists($this, $event->Name) ) {
				return '';
			}

			if ( preg_match('/(.*)Ajax$/', $event->Name, $regs) && method_exists($this, $regs[1]) ) {
				return $regs[1];
			}

			return '';
		}


		/**
		 * Occurs, when config was parsed, allows to change config data dynamically
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterConfigRead(kEvent $event)
		{

		}

		/**
		 * Returns sql query to be used for event subscriber list selection
		 *
		 * @param kEvent $event
		 * @return string
		 * @access protected
		 */
		protected function OnGetEventSubscribersQuery(kEvent $event)
		{
			$sql = 'SELECT SubscriberEmail, UserId
					FROM ' . $this->Application->getUnitOption('system-event-subscription', 'TableName') . '
					WHERE (' . implode(') AND (', $event->getEventParam('where_clause')) . ')';
			$event->setEventParam('sql', $sql);
		}

	}