<?php
	$settings = Array (
		'WebsitePath' => Array ('type' => 'text', 'title' => 'Web Path to Installation', 'section' => 'Misc', 'required' => 1),
		'WriteablePath' => Array ('type' => 'text', 'title' => 'Path to Writable folder', 'section' => 'Misc', 'required' => 1),
		'RestrictedPath' => Array ('type' => 'text', 'title' => 'Path to Restricted folder', 'section' => 'Misc', 'required' => 1),
		'AdminDirectory' => Array ('type' => 'text', 'title' => 'Path to Admin folder', 'section' => 'Misc'),
		'AdminPresetsDirectory' => Array ('type' => 'text', 'title' => 'Path to Admin Interface Presets folder', 'section' => 'Misc'),
		'ApplicationClass' => Array ('type' => 'text', 'title' => 'Name of Base Application Class', 'section' => 'Misc'),
		'ApplicationPath' => Array ('type' => 'text', 'title' => 'Path to Base Application Class file', 'section' => 'Misc'),
		'CacheHandler' => Array ('type' => 'select', 'title' => 'Output Caching Engine', 'section' => 'Misc'),
		'MemcacheServers' => Array ('type' => 'text', 'title' => 'Location of Memcache Servers', 'section' => 'Misc'),
		'CompressionEngine' => Array ('type' => 'select', 'title' => 'CSS/JS Compression Engine', 'section' => 'Misc'),
		'WebsiteCharset' => Array ('type' => 'text', 'title' => 'Website Charset', 'section' => 'Misc', 'required' => 1),
		'EnableSystemLog' => Array ('type' => 'radio', 'title' => 'Enable "System Log"', 'section' => 'Misc', 'required' => 1),
		'SystemLogMaxLevel' => Array ('type' => 'select', 'title' => 'Highest "Log Level", that will be saved in "System Log"', 'section' => 'Misc', 'required' => 1),
		'TrustProxy' => Array ('type' => 'radio', 'title' => 'Trust Proxy', 'section' => 'Misc', 'required' => 1),
	);

	$settings['CacheHandler']['options'] = $this->toolkit->getWorkingCacheHandlers();
	$settings['CompressionEngine']['options'] = $this->toolkit->getWorkingCompressionEngines();
	$settings['EnableSystemLog']['options'] = Array (1 => 'Enabled', 2 => 'User-only', 0 => 'Disabled');
	$settings['SystemLogMaxLevel']['options'] = Array (
		0 => 'emergency', 1 => 'alert', 2 => 'critical', 3 => 'error',
		4 => 'warning', 5 => 'notice', 6 => 'info', 7 => 'debug'
	);
	$settings['TrustProxy']['options'] = Array (1 => 'Yes', 0 => 'No');

	$row_class = 'table-color2';

	foreach ($settings as $config_var => $output_params) {
		$row_class = $row_class == 'table-color1' ? 'table-color2' : 'table-color1';
		?>
		<tr class="<?php echo $row_class; ?>">
			<td class="text">
				<b><?php echo ($output_params['title'] ? $output_params['title'] : $config_var) . (isset($output_params['required']) ? ' <span class="error">*</span>' : ''); ?>:</b>
			</td>
			<td>
				<?php
					$config_value = $this->toolkit->systemConfig->get($config_var, $output_params['section'], '');

					switch ( $output_params['type'] ) {
						case 'text':
							echo '<input type="text" name="system_config[' . $output_params['section'] . '][' . $config_var . ']" value="' . $config_value . '" class="text" style="width: 200px;"/>';
							break;

						case 'select':
							echo '<select name="system_config[' . $output_params['section'] . '][' . $config_var . ']">';

							if ( $output_params['options'][$config_value] == 'None' ) {
								$tmp_values = array_keys($output_params['options']);

								if ( count($tmp_values) > 1 ) {
									$config_value = $tmp_values[1];
								}
							}

							foreach($output_params['options'] as $option_key => $option_value) {
								$selected = $option_key == $config_value ? ' selected' : '';
								echo '<option value="' . $option_key . '"' . $selected . '>' . $option_value . '</option>';
							}

							echo '</select>';
							break;

						case 'radio':
							foreach($output_params['options'] as $option_key => $option_value) {
								$selected = $option_key == $config_value ? ' checked' : '';
								echo '<input type="radio" name="system_config[' . $output_params['section'] . '][' . $config_var . ']" value="' . $option_key . '"' . $selected . '/>' . $option_value;
							}
							break;
					}
				?>
			</td>
		</tr>
		<?php
	}
?>
