<?php
	$heading_tpl = '
		<tr class="subsectiontitle">
			<td class="%2$s" colspan="2" style="border-top: 1px solid #000000; border-bottom: 1px solid #000000;">%1$s</td>
		</tr>';

	$error_tpl = '
		<tr class="table-color2">
			<td class="text">%s</td>
		  	<td align="center" width="30">%s</td>
		</tr>';

	$output = '';
	$write_check = true;
	$check_paths = Array ('/', '/index.php', $this->toolkit->systemConfig->get('WriteablePath', 'Misc') . '/config.php', ADMIN_DIRECTORY . '/index.php');

	foreach ($check_paths as $check_path) {
		$path_secure = true;
		$path_check_status = $this->toolkit->checkWritePermissions(FULL_PATH . $check_path);
		if (is_bool($path_check_status) && $path_check_status) {
			$write_check = $path_secure = false;
		}

		$status_text = $path_secure ? '[<span style="color: green;">Secure</span>]' : '[<span style="color: red;">Vulnerable</span>]';
		$output .= sprintf($error_tpl, $check_path . (!$path_secure? ' (<span style="color: red;">755 required</span>)' : ''), $status_text);
	}

	$skip_check = $write_check ? '<input type="hidden" name="skip_security_check" value="' . (int)$write_check . '"/>' : '';

	$output = sprintf($heading_tpl, '<strong>Write Permissions Check</strong>' . $skip_check, 'text') . $output;

	if (!$write_check) {
		$output .= '	<tr class="table-color2">
							<td class="error" colspan="2">
							For security reasons it\'s REQUIRED to set 755 permissions on the above files to prevent from attacks on your website!<br /><br /></td>
					</tr>';
	}

	// script execute check
	if (file_exists(WRITEABLE . '/install_check.php')) {
		unlink(WRITEABLE . '/install_check.php');
	}

	$fp = fopen(WRITEABLE . '/install_check.php', 'w');
	fwrite($fp, "<?php\n\techo 'OK';\n");
	fclose($fp);

	$curl_helper = $this->Application->recallObject('CurlHelper');
	/* @var $curl_helper kCurlHelper */

	$result = $curl_helper->Send($this->Application->BaseURL(WRITEBALE_BASE) . 'install_check.php');
	unlink(WRITEABLE . '/install_check.php');
	$execute_check = ($result !== 'OK');

	$output .= sprintf($heading_tpl, '<strong>Ability to Execute PHP in Writable Folders</strong>', 'text');

	$status_text = $execute_check ? '[<span style="color: green;">Secure</span>]' : '[<span style="color: red;">Vulnerable</span>]';
	$output .= sprintf($error_tpl, 'Result of creating and executing PHP file(s) in "/system" (or "/system/images") folder', $status_text);

	if (!$execute_check) {
		$output .= '<tr class="table-color2">
						<td colspan="2">
							For security reasons it\'s highly recommended disable the access (execution) to PHP files within "/system" folder and it\'s subfolders.
						</td>
					</tr>
					<tr class="table-color2">
						<td class="text" colspan="2">
							You can do this by:<br/><br/>
							<ul style="margin: 0px; padding-left: 15px;">
								<li>changing your "httpd.conf" file to deny requests for all "*.php" files</li>
								<li>renaming ".htaccess-sample" (located in "/system") to ".htaccess" so it overrides default Apache settings</li>
							</ul>
							<br/>Note that "AllowOverride LIMIT" option should be enabled by your hosting provider.
						</td>
					</tr>';
	}

	$output .= sprintf($heading_tpl, '<strong>Webserver PHP Configuration</strong>', 'text');

	$directive_check = true;
	$ini_vars = Array ('register_globals' => false, 'open_basedir' => true, 'allow_url_fopen' => false);
	foreach ($ini_vars as $var_name => $var_value) {
		$current_value = ini_get($var_name);
		if (!is_numeric($current_value)) {
			$formatted_value = $current_value ? 'On' : 'Off';
		}
		else {
			$formatted_value = "'" . $current_value . "'";
		}

		if (($var_value && !$current_value) || (!$var_value && $current_value)) {
			$directive_check = false;
			$message_text = 'set to <span style="color: red;"><strong>' . $formatted_value . '</strong></span>';
			$status_text = '[<span style="color: red;">Vulnerable</span>]';
		}
		else {
			$message_text = 'set to <strong>' . $formatted_value . '</strong>';
			$status_text = '[<span style="color: green;">Secure</span>]';
		}

		$output .= sprintf($error_tpl, 'Directive: <strong>' . $var_name . '</strong> ' . $message_text, $status_text);
	}

	/*if (!$directive_check) {
		// show additional warning about directives
	}*/

	echo $output;
?>