CREATE TABLE CategoryPermissionsConfig (
  PermissionConfigId int(11) NOT NULL auto_increment,
  PermissionName varchar(255) NOT NULL default '',
  Description varchar(255) NOT NULL default '',
  ModuleId varchar(20) NOT NULL default '0',
  IsSystem tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY  (PermissionConfigId),
  KEY PermissionName (PermissionName)
);

CREATE TABLE Permissions (
  PermissionId int(11) NOT NULL auto_increment,
  Permission varchar(255) NOT NULL default '',
  GroupId int(11) default '0',
  PermissionValue int(11) NOT NULL default '0',
  `Type` tinyint(4) NOT NULL default '0',
  CatId int(11) NOT NULL default '0',
  PRIMARY KEY  (PermissionId),
  UNIQUE KEY PermIndex (Permission,GroupId,CatId,`Type`)
);

CREATE TABLE CustomFields (
  CustomFieldId int(11) NOT NULL auto_increment,
  `Type` int(11) NOT NULL default '0',
  FieldName varchar(255) NOT NULL default '',
  FieldLabel varchar(40) default NULL,
  MultiLingual tinyint(3) unsigned NOT NULL default '1',
  Heading varchar(60) default NULL,
  Prompt varchar(60) default NULL,
  ElementType varchar(50) NOT NULL default '',
  ValueList text,
  DefaultValue varchar(255) NOT NULL default '',
  DisplayOrder int(11) NOT NULL default '0',
  OnGeneralTab tinyint(4) NOT NULL default '0',
  IsSystem tinyint(3) unsigned NOT NULL default '0',
  IsRequired tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (CustomFieldId),
  KEY `Type` (`Type`),
  KEY MultiLingual (MultiLingual),
  KEY DisplayOrder (DisplayOrder),
  KEY OnGeneralTab (OnGeneralTab),
  KEY IsSystem (IsSystem),
  KEY DefaultValue (DefaultValue)
);

CREATE TABLE SystemSettings (
  VariableId int(11) NOT NULL AUTO_INCREMENT,
  VariableName varchar(255) NOT NULL DEFAULT '',
  VariableValue text,
  ModuleOwner varchar(20) DEFAULT 'In-Portal',
  Section varchar(255) NOT NULL DEFAULT '',
  Heading varchar(255) NOT NULL DEFAULT '',
  Prompt varchar(255) NOT NULL DEFAULT '',
  ElementType varchar(255) NOT NULL DEFAULT '',
  Validation text,
  ValueList text,
  DisplayOrder double NOT NULL DEFAULT '0',
  GroupDisplayOrder double NOT NULL DEFAULT '0',
  `Install` int(11) NOT NULL DEFAULT '1',
  HintLabel varchar(255) DEFAULT NULL,
  PRIMARY KEY (VariableId),
  UNIQUE KEY VariableName (VariableName),
  KEY DisplayOrder (DisplayOrder),
  KEY GroupDisplayOrder (GroupDisplayOrder),
  KEY `Install` (`Install`),
  KEY HintLabel (HintLabel)
);

CREATE TABLE EmailQueue (
  EmailQueueId int(10) unsigned NOT NULL AUTO_INCREMENT,
  ToEmail varchar(255) NOT NULL DEFAULT '',
  `Subject` varchar(255) NOT NULL DEFAULT '',
  MessageHeaders text,
  MessageBody longtext,
  Queued int(10) unsigned DEFAULT NULL,
  SendRetries int(10) unsigned NOT NULL DEFAULT '0',
  LastSendRetry int(10) unsigned DEFAULT NULL,
  MailingId int(10) unsigned NOT NULL DEFAULT '0',
  LogData longtext,
  PRIMARY KEY (EmailQueueId),
  KEY LastSendRetry (LastSendRetry),
  KEY SendRetries (SendRetries),
  KEY MailingId (MailingId)
);

CREATE TABLE EmailTemplates (
  TemplateId int(11) NOT NULL AUTO_INCREMENT,
  TemplateName varchar(40) NOT NULL DEFAULT '',
  ReplacementTags text,
  AllowChangingSender tinyint(4) NOT NULL DEFAULT '0',
  CustomSender tinyint(4) NOT NULL DEFAULT '0',
  SenderName varchar(255) NOT NULL DEFAULT '',
  SenderAddressType tinyint(4) NOT NULL DEFAULT '0',
  SenderAddress varchar(255) NOT NULL DEFAULT '',
  AllowChangingRecipient tinyint(4) NOT NULL DEFAULT '0',
  CustomRecipient tinyint(4) NOT NULL DEFAULT '0',
  Recipients text,
  l1_Subject text,
  l2_Subject text,
  l3_Subject text,
  l4_Subject text,
  l5_Subject text,
  l1_HtmlBody longtext,
  l2_HtmlBody longtext,
  l3_HtmlBody longtext,
  l4_HtmlBody longtext,
  l5_HtmlBody longtext,
  l1_PlainTextBody longtext,
  l2_PlainTextBody longtext,
  l3_PlainTextBody longtext,
  l4_PlainTextBody longtext,
  l5_PlainTextBody longtext,
  Headers text,
  Enabled int(11) NOT NULL DEFAULT '1',
  FrontEndOnly tinyint(3) unsigned NOT NULL DEFAULT '0',
  Module varchar(40) NOT NULL DEFAULT 'Core',
  Description text,
  `Type` int(11) NOT NULL DEFAULT '0',
  LastChanged int(10) unsigned DEFAULT NULL,
  BindToSystemEvent varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (TemplateId),
  KEY `Type` (`Type`),
  KEY Enabled (Enabled),
  KEY `Event` (TemplateName),
  KEY FrontEndOnly (FrontEndOnly),
  KEY AllowChangingSender (AllowChangingSender),
  KEY CustomSender (CustomSender),
  KEY SenderAddressType (SenderAddressType),
  KEY AllowChangingRecipient (AllowChangingRecipient),
  KEY CustomRecipient (CustomRecipient),
  KEY l1_HtmlBody (l1_HtmlBody(5)),
  KEY l2_HtmlBody (l2_HtmlBody(5)),
  KEY l3_HtmlBody (l3_HtmlBody(5)),
  KEY l4_HtmlBody (l4_HtmlBody(5)),
  KEY l5_HtmlBody (l5_HtmlBody(5)),
  KEY l1_PlainTextBody (l1_PlainTextBody(5)),
  KEY l2_PlainTextBody (l2_PlainTextBody(5)),
  KEY l3_PlainTextBody (l3_PlainTextBody(5)),
  KEY l4_PlainTextBody (l4_PlainTextBody(5)),
  KEY l5_PlainTextBody (l5_PlainTextBody(5))
);

CREATE TABLE SystemEventSubscriptions (
  SubscriptionId int(11) NOT NULL AUTO_INCREMENT,
  EmailTemplateId int(11) DEFAULT NULL,
  SubscriberEmail varchar(255) NOT NULL DEFAULT '',
  UserId int(11) DEFAULT NULL,
  CategoryId int(11) DEFAULT NULL,
  IncludeSublevels tinyint(4) NOT NULL DEFAULT '1',
  ItemId int(11) DEFAULT NULL,
  ParentItemId int(11) DEFAULT NULL,
  SubscribedOn int(11) DEFAULT NULL,
  PRIMARY KEY (SubscriptionId),
  KEY EmailEventId (EmailTemplateId)
);

CREATE TABLE IdGenerator (
  lastid int(11) default NULL
);

CREATE TABLE Languages (
  LanguageId int(11) NOT NULL AUTO_INCREMENT,
  PackName varchar(40) NOT NULL DEFAULT '',
  LocalName varchar(40) NOT NULL DEFAULT '',
  Enabled int(11) NOT NULL DEFAULT '1',
  PrimaryLang int(11) NOT NULL DEFAULT '0',
  AdminInterfaceLang tinyint(3) unsigned NOT NULL DEFAULT '0',
  Priority int(11) NOT NULL DEFAULT '0',
  IconURL varchar(255) DEFAULT NULL,
  IconDisabledURL varchar(255) DEFAULT NULL,
  DateFormat varchar(50) NOT NULL DEFAULT 'm/d/Y',
  ShortDateFormat varchar(255) NOT NULL DEFAULT 'm/d',
  TimeFormat varchar(50) NOT NULL DEFAULT 'g:i:s A',
  ShortTimeFormat varchar(255) NOT NULL DEFAULT 'g:i A',
  InputDateFormat varchar(50) NOT NULL DEFAULT 'm/d/Y',
  InputTimeFormat varchar(50) NOT NULL DEFAULT 'g:i:s A',
  DecimalPoint varchar(10) NOT NULL DEFAULT '.',
  ThousandSep varchar(10) NOT NULL DEFAULT '',
  `Charset` varchar(20) NOT NULL DEFAULT 'utf-8',
  UnitSystem tinyint(4) NOT NULL DEFAULT '1',
  FilenameReplacements text,
  Locale varchar(10) NOT NULL DEFAULT 'en-US',
  UserDocsUrl varchar(255) NOT NULL DEFAULT '',
  SynchronizationModes varchar(255) NOT NULL DEFAULT '',
  HtmlEmailTemplate text,
  TextEmailTemplate text,
  PRIMARY KEY (LanguageId),
  KEY Enabled (Enabled),
  KEY PrimaryLang (PrimaryLang),
  KEY AdminInterfaceLang (AdminInterfaceLang),
  KEY Priority (Priority)
);

CREATE TABLE Modules (
  `Name` varchar(255) NOT NULL DEFAULT '',
  Path varchar(255) NOT NULL DEFAULT '',
  ClassNamespace varchar(255) NOT NULL DEFAULT '',
  Var varchar(100) NOT NULL DEFAULT '',
  Version varchar(10) NOT NULL DEFAULT '0.0.0',
  Loaded tinyint(4) NOT NULL DEFAULT '1',
  LoadOrder tinyint(4) NOT NULL DEFAULT '0',
  TemplatePath varchar(255) NOT NULL DEFAULT '',
  RootCat int(11) NOT NULL DEFAULT '0',
  BuildDate int(10) unsigned DEFAULT NULL,
  AppliedDBRevisions text,
  PRIMARY KEY (`Name`),
  KEY Loaded (Loaded),
  KEY LoadOrder (LoadOrder)
);

CREATE TABLE UserPersistentSessionData (
  VariableId bigint(20) NOT NULL AUTO_INCREMENT,
  PortalUserId int(11) NOT NULL DEFAULT '0',
  VariableName varchar(255) NOT NULL DEFAULT '',
  VariableValue text,
  PRIMARY KEY (VariableId),
  KEY UserId (PortalUserId),
  KEY VariableName (VariableName)
);

CREATE TABLE LanguageLabels (
  PhraseId int(11) NOT NULL AUTO_INCREMENT,
  Phrase varchar(255) NOT NULL DEFAULT '',
  PhraseKey varchar(255) NOT NULL DEFAULT '',
  l1_Translation text,
  l2_Translation text,
  l3_Translation text,
  l4_Translation text,
  l5_Translation text,
  l1_HintTranslation text,
  l2_HintTranslation text,
  l3_HintTranslation text,
  l4_HintTranslation text,
  l5_HintTranslation text,
  l1_ColumnTranslation text,
  l2_ColumnTranslation text,
  l3_ColumnTranslation text,
  l4_ColumnTranslation text,
  l5_ColumnTranslation text,
  PhraseType int(11) NOT NULL DEFAULT '0',
  LastChanged int(10) unsigned DEFAULT NULL,
  LastChangeIP varchar(15) NOT NULL DEFAULT '',
  Module varchar(30) NOT NULL DEFAULT 'In-Portal',
  PRIMARY KEY (PhraseId),
  KEY Phrase_Index (Phrase),
  KEY PhraseKey (PhraseKey),
  KEY l1_Translation (l1_Translation(5)),
  KEY l1_HintTranslation (l1_HintTranslation(5)),
  KEY l1_ColumnTranslation (l1_ColumnTranslation(5))
);

CREATE TABLE PhraseCache (
  Template varchar(40) NOT NULL DEFAULT '',
  PhraseList text,
  CacheDate int(11) NOT NULL DEFAULT '0',
  ThemeId int(11) NOT NULL DEFAULT '0',
  StylesheetId int(10) unsigned NOT NULL DEFAULT '0',
  ConfigVariables text,
  PRIMARY KEY (Template),
  KEY CacheDate (CacheDate),
  KEY ThemeId (ThemeId),
  KEY StylesheetId (StylesheetId)
);

CREATE TABLE UserGroups (
  GroupId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  Description varchar(255) DEFAULT NULL,
  CreatedOn int(10) unsigned DEFAULT NULL,
  System tinyint(4) NOT NULL DEFAULT '0',
  Personal tinyint(4) NOT NULL DEFAULT '0',
  Enabled tinyint(4) NOT NULL DEFAULT '1',
  FrontRegistration tinyint(3) unsigned NOT NULL DEFAULT '0',
  IPRestrictions text,
  PRIMARY KEY (GroupId),
  UNIQUE KEY `Name` (`Name`),
  KEY Personal (Personal),
  KEY Enabled (Enabled),
  KEY CreatedOn (CreatedOn)
);

CREATE TABLE Users (
  PortalUserId int(11) NOT NULL AUTO_INCREMENT,
  Username varchar(255) NOT NULL DEFAULT '',
  `Password` varchar(255) DEFAULT 'd41d8cd98f00b204e9800998ecf8427e',
  PasswordHashingMethod tinyint(4) NOT NULL DEFAULT '3',
  FirstName varchar(255) NOT NULL DEFAULT '',
  LastName varchar(255) NOT NULL DEFAULT '',
  Company varchar(255) NOT NULL DEFAULT '',
  Email varchar(255) NOT NULL DEFAULT '',
  PrevEmails text,
  CreatedOn int(11) DEFAULT NULL,
  Phone varchar(255) NOT NULL DEFAULT '',
  Fax varchar(255) NOT NULL DEFAULT '',
  Street varchar(255) NOT NULL DEFAULT '',
  Street2 varchar(255) NOT NULL DEFAULT '',
  City varchar(255) NOT NULL DEFAULT '',
  State varchar(20) NOT NULL DEFAULT '',
  Zip varchar(20) NOT NULL DEFAULT '',
  Country varchar(20) NOT NULL DEFAULT '',
  ResourceId int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  EmailVerified tinyint(4) NOT NULL,
  Modified int(11) DEFAULT NULL,
  dob int(11) DEFAULT NULL,
  TimeZone varchar(255) NOT NULL DEFAULT '',
  IPAddress varchar(15) NOT NULL DEFAULT '',
  IsBanned tinyint(1) NOT NULL DEFAULT '0',
  PwResetConfirm varchar(255) NOT NULL DEFAULT '',
  PwRequestTime int(11) unsigned DEFAULT NULL,
  FrontLanguage int(11) DEFAULT NULL,
  AdminLanguage int(11) DEFAULT NULL,
  DisplayToPublic text,
  UserType tinyint(4) NOT NULL,
  PrimaryGroupId int(11) DEFAULT NULL,
  OldStyleLogin tinyint(4) NOT NULL,
  IPRestrictions text,
  PRIMARY KEY (PortalUserId),
  UNIQUE KEY ResourceId (ResourceId),
  KEY CreatedOn (CreatedOn),
  KEY `Status` (`Status`),
  KEY Modified (Modified),
  KEY dob (dob),
  KEY IsBanned (IsBanned),
  KEY UserType (UserType),
  KEY Username (Username)
);

CREATE TABLE UserCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

CREATE TABLE UserSessionData (
  SessionKey varchar(50) NOT NULL DEFAULT '',
  VariableName varchar(255) NOT NULL DEFAULT '',
  VariableValue longtext,
  PRIMARY KEY (SessionKey,VariableName),
  KEY SessionKey (SessionKey),
  KEY VariableName (VariableName)
);

CREATE TABLE Themes (
  ThemeId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(40) NOT NULL DEFAULT '',
  Enabled int(11) NOT NULL DEFAULT '1',
  Description varchar(255) DEFAULT NULL,
  PrimaryTheme int(11) NOT NULL DEFAULT '0',
  CacheTimeout int(11) NOT NULL DEFAULT '0',
  StylesheetId int(10) unsigned NOT NULL DEFAULT '0',
  LanguagePackInstalled tinyint(3) unsigned NOT NULL DEFAULT '0',
  TemplateAliases text,
  PRIMARY KEY (ThemeId),
  KEY Enabled (Enabled),
  KEY StylesheetId (StylesheetId),
  KEY PrimaryTheme (PrimaryTheme),
  KEY LanguagePackInstalled (LanguagePackInstalled)
);

CREATE TABLE ThemeFiles (
  FileId int(11) NOT NULL AUTO_INCREMENT,
  ThemeId int(11) NOT NULL DEFAULT '0',
  FileName varchar(255) NOT NULL DEFAULT '',
  FilePath varchar(255) NOT NULL DEFAULT '',
  TemplateAlias varchar(255) NOT NULL DEFAULT '',
  Description varchar(255) DEFAULT NULL,
  FileType int(11) NOT NULL DEFAULT '0',
  FileFound tinyint(3) unsigned NOT NULL DEFAULT '0',
  FileMetaInfo text,
  PRIMARY KEY (FileId),
  KEY theme (ThemeId),
  KEY FileName (FileName),
  KEY FilePath (FilePath),
  KEY FileFound (FileFound),
  KEY TemplateAlias (TemplateAlias)
);

CREATE TABLE UserGroupRelations (
  PortalUserId int(11) NOT NULL DEFAULT '0',
  GroupId int(11) NOT NULL DEFAULT '0',
  MembershipExpires int(10) unsigned DEFAULT NULL,
  ExpirationReminderSent tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (PortalUserId,GroupId),
  KEY GroupId (GroupId),
  KEY MembershipExpires (MembershipExpires),
  KEY ExpirationReminderSent (ExpirationReminderSent)
);

CREATE TABLE UserSessions (
  SessionKey int(10) unsigned NOT NULL DEFAULT '0',
  LastAccessed int(10) unsigned NOT NULL DEFAULT '0',
  PortalUserId int(11) NOT NULL DEFAULT '-2',
  `Language` int(11) NOT NULL DEFAULT '1',
  Theme int(11) NOT NULL DEFAULT '1',
  GroupId int(11) NOT NULL DEFAULT '0',
  IpAddress varchar(20) NOT NULL DEFAULT '0.0.0.0',
  `Status` int(11) NOT NULL DEFAULT '1',
  GroupList varchar(255) DEFAULT NULL,
  TimeZone varchar(255) NOT NULL DEFAULT '',
  BrowserSignature varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (SessionKey),
  KEY UserId (PortalUserId),
  KEY LastAccessed (LastAccessed),
  KEY BrowserSignature (BrowserSignature)
);

CREATE TABLE EmailLog (
  EmailLogId int(11) NOT NULL AUTO_INCREMENT,
  `From` varchar(255) NOT NULL DEFAULT '',
  `To` varchar(255) NOT NULL DEFAULT '',
  OtherRecipients text,
  `Subject` varchar(255) NOT NULL DEFAULT '',
  HtmlBody longtext,
  TextBody longtext,
  SentOn int(11) DEFAULT NULL,
  TemplateName varchar(255) NOT NULL DEFAULT '',
  EventType tinyint(4) DEFAULT NULL,
  EventParams text,
  AccessKey varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (EmailLogId),
  KEY `timestamp` (SentOn)
);

CREATE TABLE SystemLog (
  LogId int(11) NOT NULL AUTO_INCREMENT,
  LogUniqueId int(11) DEFAULT NULL,
  LogLevel tinyint(4) NOT NULL DEFAULT '7',
  LogType tinyint(4) NOT NULL DEFAULT '3',
  LogCode int(11) DEFAULT NULL,
  LogMessage longtext,
  LogTimestamp int(11) DEFAULT NULL,
  LogDate datetime DEFAULT NULL,
  LogEventName varchar(100) NOT NULL DEFAULT '',
  LogHostname varchar(255) NOT NULL DEFAULT '',
  LogRequestSource tinyint(4) DEFAULT NULL,
  LogRequestURI varchar(255) NOT NULL DEFAULT '',
  LogRequestData longtext,
  LogUserId int(11) DEFAULT NULL,
  LogInterface tinyint(4) DEFAULT NULL,
  IpAddress varchar(15) NOT NULL DEFAULT '',
  LogSessionKey int(11) DEFAULT NULL,
  LogSessionData longtext,
  LogBacktrace longtext,
  LogSourceFilename varchar(255) NOT NULL DEFAULT '',
  LogSourceFileLine int(11) DEFAULT NULL,
  LogProcessId bigint(20) unsigned DEFAULT NULL,
  LogMemoryUsed bigint(20) unsigned NOT NULL,
  LogUserData longtext NOT NULL,
  LogNotificationStatus tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (LogId),
  KEY LogLevel (LogLevel),
  KEY LogType (LogType),
  KEY LogNotificationStatus (LogNotificationStatus)
);

CREATE TABLE SystemCache (
  VarName varchar(255) NOT NULL default '',
  Data longtext,
  Cached int(11) default NULL,
  LifeTime int(11) NOT NULL default '-1',
  PRIMARY KEY  (VarName),
  KEY Cached (Cached)
);

CREATE TABLE CountryStates (
  CountryStateId int(11) NOT NULL AUTO_INCREMENT,
  `Type` int(11) NOT NULL DEFAULT '1',
  StateCountryId int(11) DEFAULT NULL,
  l1_Name varchar(255) NOT NULL DEFAULT '',
  l2_Name varchar(255) NOT NULL DEFAULT '',
  l3_Name varchar(255) NOT NULL DEFAULT '',
  l4_Name varchar(255) NOT NULL DEFAULT '',
  l5_Name varchar(255) NOT NULL DEFAULT '',
  IsoCode char(3) NOT NULL DEFAULT '',
  ShortIsoCode char(2) DEFAULT NULL,
  PRIMARY KEY (CountryStateId),
  KEY `Type` (`Type`),
  KEY StateCountryId (StateCountryId),
  KEY l1_Name (l1_Name(5))
);

CREATE TABLE Categories (
  CategoryId int(11) NOT NULL AUTO_INCREMENT,
  `Type` int(11) NOT NULL DEFAULT '1',
  SymLinkCategoryId int(10) unsigned DEFAULT NULL,
  ParentId int(11) NOT NULL DEFAULT '0',
  `Name` varchar(255) NOT NULL DEFAULT '',
  l1_Name varchar(255) NOT NULL DEFAULT '',
  l2_Name varchar(255) NOT NULL DEFAULT '',
  l3_Name varchar(255) NOT NULL DEFAULT '',
  l4_Name varchar(255) NOT NULL DEFAULT '',
  l5_Name varchar(255) NOT NULL DEFAULT '',
  Filename varchar(255) NOT NULL DEFAULT '',
  AutomaticFilename tinyint(3) unsigned NOT NULL DEFAULT '1',
  Description text,
  l1_Description text,
  l2_Description text,
  l3_Description text,
  l4_Description text,
  l5_Description text,
  CreatedOn int(11) DEFAULT NULL,
  EditorsPick tinyint(4) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  Priority int(11) NOT NULL DEFAULT '0',
  MetaKeywords text,
  CachedDescendantCatsQty int(11) NOT NULL DEFAULT '0',
  CachedNavbar text,
  l1_CachedNavbar text,
  l2_CachedNavbar text,
  l3_CachedNavbar text,
  l4_CachedNavbar text,
  l5_CachedNavbar text,
  CreatedById int(11) DEFAULT NULL,
  ResourceId int(11) DEFAULT NULL,
  ParentPath text,
  TreeLeft bigint(20) NOT NULL DEFAULT '0',
  TreeRight bigint(20) NOT NULL DEFAULT '0',
  NamedParentPath text,
  NamedParentPathHash int(10) unsigned NOT NULL DEFAULT '0',
  MetaDescription text,
  HotItem int(11) NOT NULL DEFAULT '2',
  NewItem int(11) NOT NULL DEFAULT '2',
  PopItem int(11) NOT NULL DEFAULT '2',
  Modified int(11) DEFAULT NULL,
  ModifiedById int(11) DEFAULT NULL,
  CachedTemplate varchar(255) NOT NULL DEFAULT '',
  CachedTemplateHash int(10) unsigned NOT NULL DEFAULT '0',
  Template varchar(255) NOT NULL DEFAULT '#inherit#',
  UseExternalUrl tinyint(3) unsigned NOT NULL DEFAULT '0',
  ExternalUrl varchar(255) NOT NULL DEFAULT '',
  UseMenuIconUrl tinyint(3) unsigned NOT NULL DEFAULT '0',
  MenuIconUrl varchar(255) NOT NULL DEFAULT '',
  l1_Title varchar(255) DEFAULT '',
  l2_Title varchar(255) DEFAULT '',
  l3_Title varchar(255) DEFAULT '',
  l4_Title varchar(255) DEFAULT '',
  l5_Title varchar(255) DEFAULT '',
  l1_MenuTitle varchar(255) NOT NULL DEFAULT '',
  l2_MenuTitle varchar(255) NOT NULL DEFAULT '',
  l3_MenuTitle varchar(255) NOT NULL DEFAULT '',
  l4_MenuTitle varchar(255) NOT NULL DEFAULT '',
  l5_MenuTitle varchar(255) NOT NULL DEFAULT '',
  MetaTitle text,
  IndexTools text,
  IsMenu tinyint(4) NOT NULL DEFAULT '1',
  Protected tinyint(4) NOT NULL DEFAULT '0',
  FormId int(11) DEFAULT NULL,
  FormSubmittedTemplate varchar(255) DEFAULT NULL,
  FriendlyURL varchar(255) NOT NULL DEFAULT '',
  ThemeId int(10) unsigned NOT NULL DEFAULT '0',
  EnablePageCache tinyint(4) NOT NULL DEFAULT '0',
  OverridePageCacheKey tinyint(4) NOT NULL DEFAULT '0',
  PageCacheKey varchar(255) NOT NULL DEFAULT '',
  PageExpiration int(11) DEFAULT NULL,
  LiveRevisionNumber int(11) NOT NULL DEFAULT '1',
  DirectLinkEnabled tinyint(4) NOT NULL DEFAULT '1',
  DirectLinkAuthKey varchar(20) NOT NULL DEFAULT '',
  PromoBlockGroupId int(10) unsigned NOT NULL DEFAULT '0',
  RequireSSL tinyint(4) NOT NULL DEFAULT '0',
  RequireLogin tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (CategoryId),
  UNIQUE KEY ResourceId (ResourceId),
  KEY ParentId (ParentId),
  KEY Modified (Modified),
  KEY Priority (Priority),
  KEY sorting (`Name`,Priority),
  KEY Filename (Filename(5)),
  KEY l1_Name (l1_Name(5)),
  KEY l2_Name (l2_Name(5)),
  KEY l3_Name (l3_Name(5)),
  KEY l4_Name (l4_Name(5)),
  KEY l5_Name (l5_Name(5)),
  KEY l1_Description (l1_Description(5)),
  KEY l2_Description (l2_Description(5)),
  KEY l3_Description (l3_Description(5)),
  KEY l4_Description (l4_Description(5)),
  KEY l5_Description (l5_Description(5)),
  KEY TreeLeft (TreeLeft),
  KEY TreeRight (TreeRight),
  KEY SymLinkCategoryId (SymLinkCategoryId),
  KEY `Status` (`Status`),
  KEY CreatedOn (CreatedOn),
  KEY EditorsPick (EditorsPick),
  KEY ThemeId (ThemeId),
  KEY EnablePageCache (EnablePageCache),
  KEY OverridePageCacheKey (OverridePageCacheKey),
  KEY PageExpiration (PageExpiration),
  KEY Protected (Protected),
  KEY LiveRevisionNumber (LiveRevisionNumber),
  KEY PromoBlockGroupId (PromoBlockGroupId),
  KEY NamedParentPathHash (NamedParentPathHash),
  KEY CachedTemplateHash (CachedTemplateHash)
);

CREATE TABLE CategoryCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

CREATE TABLE CategoryItems (
  CategoryId int(11) NOT NULL default '0',
  ItemResourceId int(11) NOT NULL default '0',
  PrimaryCat tinyint(4) NOT NULL default '0',
  ItemPrefix varchar(50) NOT NULL default '',
  Filename varchar(255) NOT NULL default '',
  UNIQUE KEY CategoryId (CategoryId,ItemResourceId),
  KEY PrimaryCat (PrimaryCat),
  KEY ItemPrefix (ItemPrefix),
  KEY ItemResourceId (ItemResourceId),
  KEY Filename (Filename)
);

CREATE TABLE CategoryPermissionsCache (
  PermCacheId int(11) NOT NULL auto_increment,
  CategoryId int(11) NOT NULL default '0',
  PermId int(11) NOT NULL default '0',
  ACL varchar(255) NOT NULL default '',
  PRIMARY KEY  (PermCacheId),
  KEY CategoryId (CategoryId),
  KEY PermId (PermId),
  KEY ACL (ACL)
);

CREATE TABLE PopupSizes (
  PopupId int(10) unsigned NOT NULL auto_increment,
  TemplateName varchar(255) NOT NULL default '',
  PopupWidth int(11) NOT NULL default '0',
  PopupHeight int(11) NOT NULL default '0',
  PRIMARY KEY  (PopupId),
  KEY TemplateName (TemplateName)
);

CREATE TABLE Counters (
  CounterId int(10) unsigned NOT NULL auto_increment,
  Name varchar(100) NOT NULL default '',
  CountQuery text,
  CountValue text,
  LastCounted int(10) unsigned default NULL,
  LifeTime int(10) unsigned NOT NULL default '3600',
  IsClone tinyint(3) unsigned NOT NULL default '0',
  TablesAffected text,
  PRIMARY KEY  (CounterId),
  UNIQUE KEY Name (Name),
  KEY IsClone (IsClone),
  KEY LifeTime (LifeTime),
  KEY LastCounted (LastCounted)
);

CREATE TABLE AdminSkins (
  SkinId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) DEFAULT NULL,
  CSS text,
  Logo varchar(255) DEFAULT NULL,
  LogoBottom varchar(255) NOT NULL DEFAULT '',
  LogoLogin varchar(255) NOT NULL DEFAULT '',
  `Options` text,
  LastCompiled int(11) NOT NULL DEFAULT '0',
  IsPrimary int(1) NOT NULL DEFAULT '0',
  DisplaySiteNameInHeader tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (SkinId),
  KEY IsPrimary (IsPrimary),
  KEY LastCompiled (LastCompiled)
);

CREATE TABLE ChangeLogs (
  ChangeLogId bigint(20) NOT NULL AUTO_INCREMENT,
  PortalUserId int(11) NOT NULL DEFAULT '0',
  SessionLogId int(11) NOT NULL DEFAULT '0',
  `Action` tinyint(4) NOT NULL DEFAULT '0',
  OccuredOn int(11) DEFAULT NULL,
  Prefix varchar(255) NOT NULL DEFAULT '',
  ItemId bigint(20) NOT NULL DEFAULT '0',
  Changes text,
  MasterPrefix varchar(255) NOT NULL DEFAULT '',
  MasterId bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (ChangeLogId),
  KEY PortalUserId (PortalUserId),
  KEY SessionLogId (SessionLogId),
  KEY `Action` (`Action`),
  KEY OccuredOn (OccuredOn),
  KEY Prefix (Prefix),
  KEY MasterPrefix (MasterPrefix)
);

CREATE TABLE UserSessionLogs (
  SessionLogId bigint(20) NOT NULL AUTO_INCREMENT,
  PortalUserId int(11) NOT NULL DEFAULT '0',
  SessionId int(10) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  SessionStart int(11) DEFAULT NULL,
  SessionEnd int(11) DEFAULT NULL,
  IP varchar(15) NOT NULL DEFAULT '',
  AffectedItems int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (SessionLogId),
  KEY SessionId (SessionId),
  KEY `Status` (`Status`),
  KEY PortalUserId (PortalUserId)
);

CREATE TABLE StatisticsCapture (
  StatisticsId int(10) unsigned NOT NULL auto_increment,
  TemplateName varchar(255) NOT NULL default '',
  Hits int(10) unsigned NOT NULL default '0',
  LastHit int(11) NOT NULL default '0',
  ScriptTimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  ScriptTimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  ScriptTimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  PRIMARY KEY  (StatisticsId),
  KEY TemplateName (TemplateName),
  KEY Hits (Hits),
  KEY LastHit (LastHit),
  KEY ScriptTimeMin (ScriptTimeMin),
  KEY ScriptTimeAvg (ScriptTimeAvg),
  KEY ScriptTimeMax (ScriptTimeMax),
  KEY SqlTimeMin (SqlTimeMin),
  KEY SqlTimeAvg (SqlTimeAvg),
  KEY SqlTimeMax (SqlTimeMax),
  KEY SqlCountMin (SqlCountMin),
  KEY SqlCountAvg (SqlCountAvg),
  KEY SqlCountMax (SqlCountMax)
);

CREATE TABLE SlowSqlCapture (
  CaptureId int(10) unsigned NOT NULL AUTO_INCREMENT,
  TemplateNames text,
  Hits int(10) unsigned NOT NULL DEFAULT '0',
  LastHit int(11) NOT NULL DEFAULT '0',
  SqlQuery text,
  TimeMin decimal(40,20) unsigned NOT NULL DEFAULT '0.00000000000000000000',
  TimeAvg decimal(40,20) unsigned NOT NULL DEFAULT '0.00000000000000000000',
  TimeMax decimal(40,20) unsigned NOT NULL DEFAULT '0.00000000000000000000',
  QueryCrc bigint(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (CaptureId),
  KEY Hits (Hits),
  KEY LastHit (LastHit),
  KEY TimeMin (TimeMin),
  KEY TimeAvg (TimeAvg),
  KEY TimeMax (TimeMax),
  KEY QueryCrc (QueryCrc)
);

CREATE TABLE ScheduledTasks (
  ScheduledTaskId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  `Type` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `Status` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `Event` varchar(255) NOT NULL DEFAULT '',
  RunSchedule varchar(255) NOT NULL DEFAULT '* * * * *',
  LastRunOn int(10) unsigned DEFAULT NULL,
  LastRunStatus tinyint(3) unsigned NOT NULL DEFAULT '1',
  NextRunOn int(11) DEFAULT NULL,
  RunTime int(10) unsigned NOT NULL DEFAULT '0',
  Timeout int(10) unsigned DEFAULT NULL,
  LastTimeoutOn int(10) unsigned DEFAULT NULL,
  SiteDomainLimitation varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (ScheduledTaskId),
  KEY `Status` (`Status`),
  KEY LastRunOn (LastRunOn),
  KEY LastRunStatus (LastRunStatus),
  KEY RunTime (RunTime),
  KEY NextRunOn (NextRunOn),
  KEY SiteDomainLimitation (SiteDomainLimitation),
  KEY Timeout (Timeout),
  KEY `Type` (`Type`)
);

CREATE TABLE SpellingDictionary (
  SpellingDictionaryId int(11) NOT NULL auto_increment,
  MisspelledWord varchar(255) NOT NULL default '',
  SuggestedCorrection varchar(255) NOT NULL default '',
  PRIMARY KEY  (SpellingDictionaryId),
  KEY MisspelledWord (MisspelledWord),
  KEY SuggestedCorrection (SuggestedCorrection)
);

CREATE TABLE Thesaurus (
  ThesaurusId int(11) NOT NULL auto_increment,
  SearchTerm varchar(255) NOT NULL default '',
  ThesaurusTerm varchar(255) NOT NULL default '',
  ThesaurusType tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (ThesaurusId),
  KEY ThesaurusType (ThesaurusType),
  KEY SearchTerm (SearchTerm)
);

CREATE TABLE LocalesList (
  LocaleId int(11) NOT NULL auto_increment,
  LocaleIdentifier varchar(6) NOT NULL default '',
  LocaleName varchar(255) NOT NULL default '',
  Locale varchar(20) NOT NULL default '',
  ScriptTag varchar(255) NOT NULL default '',
  ANSICodePage varchar(10) NOT NULL default '',
  PRIMARY KEY (LocaleId)
);

CREATE TABLE UserBanRules (
  RuleId int(11) NOT NULL auto_increment,
  RuleType tinyint(4) NOT NULL default '0',
  ItemField varchar(255) default NULL,
  ItemVerb tinyint(4) NOT NULL default '0',
  ItemValue varchar(255) NOT NULL default '',
  ItemType int(11) NOT NULL default '0',
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '1',
  ErrorTag varchar(255) default NULL,
  PRIMARY KEY  (RuleId),
  KEY Status (Status),
  KEY Priority (Priority),
  KEY ItemType (ItemType)
);

CREATE TABLE CountCache (
  ListType int(11) NOT NULL default '0',
  ItemType int(11) NOT NULL default '-1',
  Value int(11) NOT NULL default '0',
  CountCacheId int(11) NOT NULL auto_increment,
  LastUpdate int(11) NOT NULL default '0',
  ExtraId varchar(50) default NULL,
  TodayOnly tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (CountCacheId)
);

CREATE TABLE UserFavorites (
  FavoriteId int(11) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  ResourceId int(11) NOT NULL default '0',
  ItemTypeId int(11) NOT NULL default '0',
  Modified int(11) NOT NULL default '0',
  PRIMARY KEY  (FavoriteId),
  UNIQUE KEY main (PortalUserId,ResourceId),
  KEY Modified (Modified),
  KEY ItemTypeId (ItemTypeId)
);

CREATE TABLE CatalogImages (
  ImageId int(11) NOT NULL auto_increment,
  ResourceId int(11) NOT NULL default '0',
  Url varchar(255) NOT NULL default '',
  Name varchar(255) NOT NULL default '',
  AltName VARCHAR(255) NOT NULL DEFAULT '',
  ImageIndex int(11) NOT NULL default '0',
  LocalImage tinyint(4) NOT NULL default '1',
  LocalPath varchar(240) NOT NULL default '',
  Enabled int(11) NOT NULL default '1',
  DefaultImg int(11) NOT NULL default '0',
  ThumbUrl varchar(255) default NULL,
  Priority int(11) NOT NULL default '0',
  ThumbPath varchar(255) default NULL,
  LocalThumb tinyint(4) NOT NULL default '1',
  SameImages tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (ImageId),
  KEY ResourceId (ResourceId),
  KEY Enabled (Enabled),
  KEY Priority (Priority)
);

CREATE TABLE CatalogRatings (
  RatingId int(11) NOT NULL auto_increment,
  IPAddress varchar(255) NOT NULL default '',
  CreatedOn INT UNSIGNED NULL DEFAULT NULL,
  RatingValue int(11) NOT NULL default '0',
  ItemId int(11) NOT NULL default '0',
  PRIMARY KEY  (RatingId),
  KEY CreatedOn (CreatedOn),
  KEY ItemId (ItemId),
  KEY RatingValue (RatingValue)
);

CREATE TABLE CatalogReviews (
  ReviewId int(11) NOT NULL AUTO_INCREMENT,
  CreatedOn int(10) unsigned DEFAULT NULL,
  ReviewText longtext,
  Rating tinyint(3) unsigned NOT NULL DEFAULT '0',
  IPAddress varchar(255) NOT NULL DEFAULT '',
  ItemId int(11) NOT NULL DEFAULT '0',
  CreatedById int(11) DEFAULT NULL,
  ItemType tinyint(4) NOT NULL DEFAULT '0',
  Priority int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '2',
  TextFormat int(11) NOT NULL DEFAULT '0',
  Module varchar(255) NOT NULL DEFAULT '',
  HelpfulCount int(11) NOT NULL,
  NotHelpfulCount int(11) NOT NULL,
  PRIMARY KEY (ReviewId),
  KEY CreatedOn (CreatedOn),
  KEY ItemId (ItemId),
  KEY ItemType (ItemType),
  KEY Priority (Priority),
  KEY `Status` (`Status`)
);

CREATE TABLE ItemFilters (
  FilterId int(11) NOT NULL AUTO_INCREMENT,
  ItemPrefix varchar(255) NOT NULL DEFAULT '',
  FilterField varchar(255) NOT NULL DEFAULT '',
  FilterType varchar(100) NOT NULL DEFAULT '',
  Enabled tinyint(4) NOT NULL DEFAULT '1',
  RangeCount int(11) DEFAULT NULL,
  PRIMARY KEY (FilterId),
  KEY ItemPrefix (ItemPrefix),
  KEY Enabled (Enabled)
);

CREATE TABLE SpamReports (
  ReportId int(11) NOT NULL AUTO_INCREMENT,
  ItemPrefix varchar(255) NOT NULL DEFAULT '',
  ItemId int(11) NOT NULL,
  MessageText text,
  ReportedOn int(11) DEFAULT NULL,
  ReportedById int(11) DEFAULT NULL,
  PRIMARY KEY (ReportId),
  KEY ItemPrefix (ItemPrefix),
  KEY ItemId (ItemId),
  KEY ReportedById (ReportedById)
);

CREATE TABLE ItemTypes (
  ItemType int(11) NOT NULL default '0',
  Module varchar(50) NOT NULL default '',
  Prefix varchar(20) NOT NULL default '',
  SourceTable varchar(100) NOT NULL default '',
  TitleField varchar(50) default NULL,
  CreatorField varchar(255) NOT NULL default '',
  PopField varchar(255) default NULL,
  RateField varchar(255) default NULL,
  LangVar varchar(255) NOT NULL default '',
  PrimaryItem int(11) NOT NULL default '0',
  EditUrl varchar(255) NOT NULL default '',
  ClassName varchar(40) NOT NULL default '',
  ItemName varchar(50) NOT NULL default '',
  PRIMARY KEY  (ItemType),
  KEY Module (Module)
);

CREATE TABLE CatalogFiles (
  FileId int(11) NOT NULL AUTO_INCREMENT,
  ResourceId int(11) unsigned NOT NULL DEFAULT '0',
  FileName varchar(255) NOT NULL DEFAULT '',
  FilePath varchar(255) NOT NULL DEFAULT '',
  Size int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  CreatedOn int(11) unsigned DEFAULT NULL,
  CreatedById int(11) DEFAULT NULL,
  MimeType varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (FileId),
  KEY ResourceId (ResourceId),
  KEY CreatedOn (CreatedOn),
  KEY `Status` (`Status`)
);

CREATE TABLE CatalogRelationships (
  RelationshipId int(11) NOT NULL auto_increment,
  SourceId int(11) default NULL,
  TargetId int(11) default NULL,
  SourceType tinyint(4) NOT NULL default '0',
  TargetType tinyint(4) NOT NULL default '0',
  Type int(11) NOT NULL default '0',
  Enabled int(11) NOT NULL default '1',
  Priority int(11) NOT NULL default '0',
  PRIMARY KEY  (RelationshipId),
  KEY RelSource (SourceId),
  KEY RelTarget (TargetId),
  KEY `Type` (`Type`),
  KEY Enabled (Enabled),
  KEY Priority (Priority),
  KEY SourceType (SourceType),
  KEY TargetType (TargetType)
);

CREATE TABLE SearchConfig (
  TableName varchar(40) NOT NULL default '',
  FieldName varchar(40) NOT NULL default '',
  SimpleSearch tinyint(4) NOT NULL default '1',
  AdvancedSearch tinyint(4) NOT NULL default '1',
  Description varchar(255) default NULL,
  DisplayName varchar(80) default NULL,
  ModuleName VARCHAR(20) NOT NULL DEFAULT 'In-Portal',
  ConfigHeader varchar(255) default NULL,
  DisplayOrder int(11) NOT NULL default '0',
  SearchConfigId int(11) NOT NULL auto_increment,
  Priority int(11) NOT NULL default '0',
  FieldType varchar(20) NOT NULL default 'text',
  ForeignField TEXT,
  JoinClause TEXT,
  IsWhere text,
  IsNotWhere text,
  ContainsWhere text,
  NotContainsWhere text,
  CustomFieldId int(11) default NULL,
  PRIMARY KEY  (SearchConfigId),
  KEY SimpleSearch (SimpleSearch),
  KEY AdvancedSearch (AdvancedSearch),
  KEY DisplayOrder (DisplayOrder),
  KEY Priority (Priority),
  KEY CustomFieldId (CustomFieldId)
);

CREATE TABLE SearchLogs (
  SearchLogId int(11) NOT NULL auto_increment,
  Keyword varchar(255) NOT NULL default '',
  Indices bigint(20) NOT NULL default '0',
  SearchType int(11) NOT NULL default '0',
  PRIMARY KEY  (SearchLogId),
  KEY Keyword (Keyword),
  KEY SearchType (SearchType)
);

CREATE TABLE SpamControl (
  ItemResourceId int(11) NOT NULL default '0',
  IPaddress varchar(20) NOT NULL default '',
  Expire INT UNSIGNED NULL DEFAULT NULL,
  PortalUserId int(11) NOT NULL default '0',
  DataType varchar(20) default NULL,
  KEY PortalUserId (PortalUserId),
  KEY Expire (Expire),
  KEY DataType (DataType),
  KEY ItemResourceId (ItemResourceId)
);

CREATE TABLE StatItem (
  StatItemId int(11) NOT NULL auto_increment,
  Module varchar(20) NOT NULL default '',
  ValueSQL varchar(255) default NULL,
  ResetSQL varchar(255) default NULL,
  ListLabel varchar(255) NOT NULL default '',
  Priority int(11) NOT NULL default '0',
  AdminSummary int(11) NOT NULL default '0',
  PRIMARY KEY  (StatItemId),
  KEY AdminSummary (AdminSummary),
  KEY Priority (Priority)
);

CREATE TABLE ImportScripts (
  ImportId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  Description text,
  Prefix varchar(10) NOT NULL DEFAULT '',
  Module varchar(50) NOT NULL DEFAULT '',
  ExtraFields varchar(255) NOT NULL DEFAULT '',
  `Type` varchar(10) NOT NULL DEFAULT '',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (ImportId),
  KEY Module (Module),
  KEY `Status` (`Status`)
);

CREATE TABLE UserVisits (
  VisitId int(11) NOT NULL AUTO_INCREMENT,
  VisitDate int(10) unsigned DEFAULT NULL,
  Referer varchar(255) NOT NULL DEFAULT '',
  IPAddress varchar(15) NOT NULL DEFAULT '',
  AffiliateId int(10) unsigned NOT NULL DEFAULT '0',
  PortalUserId int(11) NOT NULL DEFAULT '-2',
  PRIMARY KEY (VisitId),
  KEY PortalUserId (PortalUserId),
  KEY AffiliateId (AffiliateId),
  KEY VisitDate (VisitDate)
);

CREATE TABLE ImportCache (
  CacheId int(11) NOT NULL AUTO_INCREMENT,
  CacheName varchar(255) NOT NULL DEFAULT '',
  VarName bigint(11) NOT NULL DEFAULT '0',
  VarValue text,
  PRIMARY KEY (CacheId),
  KEY CacheName (CacheName),
  KEY VarName (VarName)
);

CREATE TABLE CategoryRelatedSearches (
  RelatedSearchId int(11) NOT NULL auto_increment,
  ResourceId int(11) NOT NULL default '0',
  Keyword varchar(255) NOT NULL default '',
  ItemType tinyint(4) NOT NULL default '0',
  Enabled tinyint(4) NOT NULL default '1',
  Priority int(11) NOT NULL default '0',
  PRIMARY KEY  (RelatedSearchId),
  KEY Enabled (Enabled),
  KEY ItemType (ItemType),
  KEY ResourceId (ResourceId)
);

CREATE TABLE StopWords (
  StopWordId int(11) NOT NULL auto_increment,
  StopWord varchar(255) NOT NULL default '',
  PRIMARY KEY  (StopWordId),
  KEY StopWord (StopWord)
);

CREATE TABLE MailingLists (
  MailingId int(10) unsigned NOT NULL AUTO_INCREMENT,
  PortalUserId int(11) NOT NULL DEFAULT '-1',
  `To` longtext,
  ToParsed longtext,
  Attachments text,
  `Subject` varchar(255) NOT NULL DEFAULT '',
  MessageText longtext,
  MessageHtml longtext,
  `Status` tinyint(3) unsigned NOT NULL DEFAULT '1',
  EmailsQueuedTotal int(10) unsigned NOT NULL DEFAULT '0',
  EmailsSent int(10) unsigned NOT NULL DEFAULT '0',
  EmailsTotal int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (MailingId),
  KEY EmailsTotal (EmailsTotal),
  KEY EmailsSent (EmailsSent),
  KEY EmailsQueued (EmailsQueuedTotal),
  KEY `Status` (`Status`),
  KEY PortalUserId (PortalUserId)
);

CREATE TABLE PageContent (
  PageContentId int(11) NOT NULL AUTO_INCREMENT,
  ContentNum bigint(11) NOT NULL DEFAULT '0',
  PageId int(11) NOT NULL DEFAULT '0',
  RevisionId int(11) NOT NULL,
  l1_Content text,
  l2_Content text,
  l3_Content text,
  l4_Content text,
  l5_Content text,
  PRIMARY KEY (PageContentId),
  KEY ContentNum (ContentNum,PageId),
  KEY RevisionId (RevisionId)
);

CREATE TABLE PageRevisions (
  RevisionId int(11) NOT NULL AUTO_INCREMENT,
  PageId int(11) NOT NULL,
  RevisionNumber int(11) NOT NULL,
  IsDraft tinyint(4) NOT NULL,
  FromRevisionId int(11) NOT NULL,
  CreatedById int(11) DEFAULT NULL,
  CreatedOn int(11) DEFAULT NULL,
  AutoSavedOn int(11) DEFAULT NULL,
  `Status` tinyint(4) NOT NULL DEFAULT '2',
  PRIMARY KEY (RevisionId),
  KEY PageId (PageId),
  KEY RevisionNumber (RevisionNumber),
  KEY IsDraft (IsDraft),
  KEY `Status` (`Status`)
);

CREATE TABLE FormFields (
  FormFieldId int(11) NOT NULL AUTO_INCREMENT,
  FormId int(11) NOT NULL DEFAULT '0',
  `Type` int(11) NOT NULL DEFAULT '0',
  FieldName varchar(255) NOT NULL DEFAULT '',
  FieldLabel varchar(255) DEFAULT NULL,
  Heading varchar(255) DEFAULT NULL,
  Prompt varchar(255) DEFAULT NULL,
  ElementType varchar(50) NOT NULL DEFAULT '',
  ValueList varchar(255) DEFAULT NULL,
  Priority int(11) NOT NULL DEFAULT '0',
  IsSystem tinyint(3) unsigned NOT NULL DEFAULT '0',
  Required tinyint(1) NOT NULL DEFAULT '0',
  DisplayInGrid tinyint(1) NOT NULL DEFAULT '1',
  DefaultValue text,
  Validation tinyint(4) NOT NULL DEFAULT '0',
  UploadExtensions varchar(255) NOT NULL DEFAULT '',
  UploadMaxSize int(11) DEFAULT NULL,
  Visibility tinyint(4) NOT NULL DEFAULT '1',
  EmailCommunicationRole tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (FormFieldId),
  KEY `Type` (`Type`),
  KEY FormId (FormId),
  KEY Priority (Priority),
  KEY IsSystem (IsSystem),
  KEY DisplayInGrid (DisplayInGrid),
  KEY Visibility (Visibility),
  KEY EmailCommunicationRole (EmailCommunicationRole)
);

CREATE TABLE FormSubmissions (
  FormSubmissionId int(11) NOT NULL AUTO_INCREMENT,
  FormId int(11) NOT NULL DEFAULT '0',
  SubmissionTime int(11) DEFAULT NULL,
  IPAddress varchar(15) NOT NULL DEFAULT '',
  ReferrerURL text NULL,
  LogStatus tinyint(3) unsigned NOT NULL DEFAULT '2',
  LastUpdatedOn int(10) unsigned DEFAULT NULL,
  Notes text,
  MessageId varchar(255) DEFAULT NULL,
  PRIMARY KEY (FormSubmissionId),
  KEY FormId (FormId),
  KEY SubmissionTime (SubmissionTime),
  KEY LogStatus (LogStatus),
  KEY LastUpdatedOn (LastUpdatedOn),
  KEY MessageId (MessageId)
);

CREATE TABLE FormSubmissionReplies (
  SubmissionLogId int(11) NOT NULL AUTO_INCREMENT,
  FormSubmissionId int(10) unsigned NOT NULL,
  FromEmail varchar(255) NOT NULL DEFAULT '',
  ToEmail varchar(255) NOT NULL DEFAULT '',
  Cc text,
  Bcc text,
  `Subject` varchar(255) NOT NULL DEFAULT '',
  Message text,
  Attachment text,
  ReplyStatus tinyint(3) unsigned NOT NULL DEFAULT '0',
  SentStatus tinyint(3) unsigned NOT NULL DEFAULT '0',
  SentOn int(10) unsigned DEFAULT NULL,
  RepliedOn int(10) unsigned DEFAULT NULL,
  VerifyCode varchar(32) NOT NULL DEFAULT '',
  DraftId int(10) unsigned NOT NULL DEFAULT '0',
  MessageId varchar(255) NOT NULL DEFAULT '',
  BounceInfo text,
  BounceDate int(11) DEFAULT NULL,
  PRIMARY KEY (SubmissionLogId),
  KEY FormSubmissionId (FormSubmissionId),
  KEY ReplyStatus (ReplyStatus),
  KEY SentStatus (SentStatus),
  KEY SentOn (SentOn),
  KEY RepliedOn (RepliedOn),
  KEY VerifyCode (VerifyCode),
  KEY DraftId (DraftId),
  KEY BounceDate (BounceDate),
  KEY MessageId (MessageId)
);

CREATE TABLE FormSubmissionReplyDrafts (
  DraftId int(11) NOT NULL AUTO_INCREMENT,
  FormSubmissionId int(10) unsigned NOT NULL DEFAULT '0',
  CreatedOn int(10) unsigned DEFAULT NULL,
  CreatedById int(11) DEFAULT NULL,
  Message text,
  PRIMARY KEY (DraftId),
  KEY FormSubmissionId (FormSubmissionId),
  KEY CreatedOn (CreatedOn),
  KEY CreatedById (CreatedById)
);

CREATE TABLE Forms (
  FormId int(11) NOT NULL AUTO_INCREMENT,
  Title varchar(255) NOT NULL DEFAULT '',
  Description text,
  RequireLogin tinyint(4) NOT NULL DEFAULT '0',
  UseSecurityImage tinyint(4) NOT NULL DEFAULT '0',
  SubmitNotifyEmail varchar(255) NOT NULL DEFAULT '',
  EnableEmailCommunication tinyint(4) NOT NULL DEFAULT '0',
  ProcessUnmatchedEmails tinyint(4) NOT NULL DEFAULT '0',
  ReplyFromName varchar(255) NOT NULL DEFAULT '',
  ReplyFromEmail varchar(255) NOT NULL DEFAULT '',
  ReplyCc varchar(255) NOT NULL DEFAULT '',
  ReplyBcc varchar(255) NOT NULL DEFAULT '',
  ReplyMessageSignature text,
  ReplyServer varchar(255) NOT NULL DEFAULT '',
  ReplyPort int(11) NOT NULL DEFAULT '110',
  ReplyUsername varchar(255) NOT NULL DEFAULT '',
  ReplyPassword varchar(255) NOT NULL DEFAULT '',
  BounceEmail varchar(255) NOT NULL DEFAULT '',
  BounceServer varchar(255) NOT NULL DEFAULT '',
  BouncePort int(11) NOT NULL DEFAULT '110',
  BounceUsername varchar(255) NOT NULL DEFAULT '',
  BouncePassword varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (FormId),
  KEY UseSecurityImage (UseSecurityImage),
  KEY RequireLogin (RequireLogin),
  KEY EnableEmailCommunication (EnableEmailCommunication),
  KEY ProcessUnmatchedEmails (ProcessUnmatchedEmails)
);

CREATE TABLE Semaphores (
  SemaphoreId int(11) NOT NULL AUTO_INCREMENT,
  SessionKey int(10) unsigned NOT NULL DEFAULT '0',
  `Timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  MainPrefix varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (SemaphoreId),
  KEY SessionKey (SessionKey),
  KEY `Timestamp` (`Timestamp`),
  KEY MainPrefix (MainPrefix)
);

CREATE TABLE CachedUrls (
  UrlId int(11) NOT NULL AUTO_INCREMENT,
  Url varchar(255) NOT NULL DEFAULT '',
  DomainId int(11) NOT NULL DEFAULT '0',
  `Hash` bigint(11) NOT NULL DEFAULT '0',
  Prefixes varchar(255) NOT NULL DEFAULT '',
  ParsedVars text,
  Cached int(10) unsigned DEFAULT NULL,
  LifeTime int(11) NOT NULL DEFAULT '-1',
  PRIMARY KEY (UrlId),
  KEY Url (Url),
  KEY `Hash` (`Hash`),
  KEY Prefixes (Prefixes),
  KEY Cached (Cached),
  KEY LifeTime (LifeTime),
  KEY DomainId (DomainId)
);

CREATE TABLE SiteDomains (
  DomainId int(11) NOT NULL AUTO_INCREMENT,
  DomainName varchar(255) NOT NULL DEFAULT '',
  DomainNameUsesRegExp tinyint(4) NOT NULL DEFAULT '0',
  SSLUrl varchar(255) NOT NULL DEFAULT '',
  SSLUrlUsesRegExp tinyint(4) NOT NULL DEFAULT '0',
  AdminEmail varchar(255) NOT NULL DEFAULT '',
  DefaultEmailRecipients text,
  Country varchar(3) NOT NULL DEFAULT '',
  PrimaryLanguageId int(11) NOT NULL DEFAULT '0',
  Languages varchar(255) NOT NULL DEFAULT '',
  PrimaryThemeId int(11) NOT NULL DEFAULT '0',
  Themes varchar(255) NOT NULL DEFAULT '',
  DomainIPRange text,
  ExternalUrl varchar(255) NOT NULL DEFAULT '',
  RedirectOnIPMatch tinyint(4) NOT NULL DEFAULT '0',
  Priority int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (DomainId),
  KEY DomainName (DomainName),
  KEY DomainNameUsesRegExp (DomainNameUsesRegExp),
  KEY SSLUrl (SSLUrl),
  KEY SSLUrlUsesRegExp (SSLUrlUsesRegExp),
  KEY AdminEmail (AdminEmail),
  KEY Country (Country),
  KEY PrimaryLanguageId (PrimaryLanguageId),
  KEY Languages (Languages),
  KEY PrimaryThemeId (PrimaryThemeId),
  KEY Themes (Themes),
  KEY ExternalUrl (ExternalUrl),
  KEY RedirectOnIPMatch (RedirectOnIPMatch),
  KEY Priority (Priority)
);

CREATE TABLE CurlLog (
  LogId int(11) NOT NULL AUTO_INCREMENT,
  Message varchar(255) NOT NULL DEFAULT '',
  PageUrl varchar(255) NOT NULL DEFAULT '',
  RequestUrl varchar(255) NOT NULL DEFAULT '',
  PortalUserId int(11) NOT NULL,
  SessionKey int(11) NOT NULL,
  IsAdmin tinyint(4) NOT NULL,
  PageData text,
  RequestData text,
  ResponseData text,
  RequestDate int(11) DEFAULT NULL,
  ResponseDate int(11) DEFAULT NULL,
  ResponseHttpCode int(11) NOT NULL,
  CurlError varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (LogId),
  KEY Message (Message),
  KEY PageUrl (PageUrl),
  KEY RequestUrl (RequestUrl),
  KEY PortalUserId (PortalUserId),
  KEY SessionKey (SessionKey),
  KEY IsAdmin (IsAdmin),
  KEY RequestDate (RequestDate),
  KEY ResponseDate (ResponseDate),
  KEY ResponseHttpCode (ResponseHttpCode),
  KEY CurlError (CurlError)
);

CREATE TABLE PromoBlocks (
  BlockId int(11) NOT NULL AUTO_INCREMENT,
  l1_Title varchar(50) NOT NULL DEFAULT '',
  l2_Title varchar(50) NOT NULL DEFAULT '',
  l3_Title varchar(50) NOT NULL DEFAULT '',
  l4_Title varchar(50) NOT NULL DEFAULT '',
  l5_Title varchar(50) NOT NULL DEFAULT '',
  l1_ButtonText varchar(255) NOT NULL DEFAULT '',
  l2_ButtonText varchar(255) NOT NULL DEFAULT '',
  l3_ButtonText varchar(255) NOT NULL DEFAULT '',
  l4_ButtonText varchar(255) NOT NULL DEFAULT '',
  l5_ButtonText varchar(255) NOT NULL DEFAULT '',
  Priority int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(1) NOT NULL DEFAULT '1',
  l1_Image varchar(255) NOT NULL DEFAULT '',
  l2_Image varchar(255) NOT NULL DEFAULT '',
  l3_Image varchar(255) NOT NULL DEFAULT '',
  l4_Image varchar(255) NOT NULL DEFAULT '',
  l5_Image varchar(255) NOT NULL DEFAULT '',
  CSSClassName varchar(255) NOT NULL DEFAULT '',
  LinkType tinyint(1) NOT NULL DEFAULT '1',
  CategoryId int(11) DEFAULT NULL,
  ExternalLink varchar(255) NOT NULL DEFAULT '',
  OpenInNewWindow tinyint(3) unsigned NOT NULL DEFAULT '0',
  ScheduleFromDate int(11) DEFAULT NULL,
  ScheduleToDate int(11) DEFAULT NULL,
  NumberOfClicks int(11) NOT NULL DEFAULT '0',
  NumberOfViews int(11) NOT NULL DEFAULT '0',
  Sticky tinyint(1) NOT NULL DEFAULT '0',
  l1_Html text,
  l2_Html text,
  l3_Html text,
  l4_Html text,
  l5_Html text,
  PromoBlockGroupId int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (BlockId),
  KEY OpenInNewWindow (OpenInNewWindow),
  KEY PromoBlockGroupId (PromoBlockGroupId),
  KEY l1_Title (l1_Title(5)),
  KEY l2_Title (l2_Title(5)),
  KEY l3_Title (l3_Title(5)),
  KEY l4_Title (l4_Title(5)),
  KEY l5_Title (l5_Title(5)),
  KEY l1_ButtonText (l1_ButtonText(5)),
  KEY l2_ButtonText (l2_ButtonText(5)),
  KEY l3_ButtonText (l3_ButtonText(5)),
  KEY l4_ButtonText (l4_ButtonText(5)),
  KEY l5_ButtonText (l5_ButtonText(5))
);

CREATE TABLE PromoBlockGroups (
  PromoBlockGroupId int(11) NOT NULL AUTO_INCREMENT,
  Title varchar(255) NOT NULL DEFAULT '',
  CreatedOn int(10) unsigned DEFAULT NULL,
  `Status` tinyint(1) NOT NULL DEFAULT '1',
  RotationDelay decimal(9,2) DEFAULT NULL,
  TransitionTime decimal(9,2) DEFAULT NULL,
  TransitionControls tinyint(1) NOT NULL DEFAULT '1',
  TransitionEffect varchar(255) NOT NULL DEFAULT '',
  TransitionEffectCustom varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (PromoBlockGroupId)
);