(
	function() {
		CKEDITOR.plugins.add(
			'my_document',
			{
				init: function(editor) {
					var pluginName = 'my_document';

					CKEDITOR.dialog.add(pluginName, this.path + 'dialogs/document.js');
			        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));

			        editor.ui.addButton('Document',
						{
							label: 'Insert/Edit Document',
							command: pluginName,
							icon: CKEDITOR.plugins.getPath(pluginName) + 'images/document.gif'
						}
					);


					if (editor.addMenuItem) {
						// A group menu is required
						// order, as second parameter, is not required
						editor.addMenuGroup(pluginName);

						// Create a manu item
						editor.addMenuItem(
							'editDocument',
							{
								label: 'Document Properties',
								command: pluginName,
								icon: CKEDITOR.plugins.getPath(pluginName) + 'images/document.gif',
								group: pluginName
							}
						);
					}

					if (editor.contextMenu) {
						editor.contextMenu.addListener(
							function(element, selection) {  //function to be run when context menu is displayed
								if ( !element ) {
									return null;
								}

								var bInsideLink = ( element.is('a') || element.hasAscendant('a') ) ;

								if ( bInsideLink || editor.getCommand( 'unlink' ).state != CKEDITOR.TRISTATE_DISABLED ) {
									// Go up to the anchor to test its properties
									var oLink = element.is('a') ? element : element.getParent();
									var bIsAnchor = ( oLink && oLink.getAttribute('name') && !oLink.getAttribute('href') ) ;

									// If it isn't a link then don't add the Link context menu
									if ( !bIsAnchor && bInsideLink ) {
										var id = oLink.getAttribute( 'id' , 2 );

										if ( id && id.match(/^Doc_+/) ) {
											return { editDocument: CKEDITOR.TRISTATE_OFF };
										}
									}
								}

								return null;
							}
						);
					}


			    }
			}
		);

		// some code here
	}
)();