function CronManager ($field_mask, $field_prefix) {
	this.fieldMask = $field_mask;
	this.fieldPrefix = $field_prefix;
	this.fields = ['Minute', 'Hour', 'Day', 'Month', 'Weekday'];
}

CronManager.prototype.init = function () {
	var $manager = this;

	// populate all controls when common hint control changes
	this.getHintControl('Common').change(function($e) {
		var $values = $(this).val().split(' ');

		$manager.fields.each(function ($i) {
			var $field = this;

			$manager.getInputControl($field).val($values[$i]).change();
		});
	});

	this.fields.each(function () {
		var $field = this;

		// put selected hint value into the input
		$manager.getHintControl($field).change(function ($e) {
			$manager.getInputControl($field).val($(this).val()).change();
		});

		// put select field hint + common hint based on input value
		$manager.getInputControl($field).change(function ($e) {
			$manager.syncHintControl($field);
			$manager.syncHintControl('Common', $manager.getCombinedValue());
		}).change();

	});
}

CronManager.prototype.getCombinedValue = function () {
	var $ret = [],
		$manager = this;

	this.fields.each(function ($i) {
		$ret.push($manager.getInputControl(this).val());
	});

	return $ret.join(' ');
}

CronManager.prototype.getHintControl = function ($field) {
	return this.getInputControl($field, 'Hints');
}

CronManager.prototype.getInputControl = function ($field, $suffix) {
	if ( $suffix == undefined ) {
		$suffix = '';
	}

	return $(get_control(this.fieldMask, this.fieldPrefix + $field + $suffix));
}

CronManager.prototype.syncHintControl = function ($field, $input_value) {
	var $hint_control = this.getHintControl($field);

	if ( $input_value === undefined ) {
		$input_value = this.getInputControl($field).val();
	}

	if ( $('option[value="' + jq($input_value) + '"]', $hint_control).length == 1 ) {
		$hint_control.val($input_value);
	}
	else {
		$hint_control.val('');
	}

	if ( $field == 'Common' ) {
		var $old_value = $hint_control.data('old_value');

		if ( $old_value !== undefined && $old_value !== $input_value ) {
			// reset next run time to be regenerated according to new schedule on save
			$(get_control(this.fieldMask, 'NextRunOn_date')).val('');
			$(get_control(this.fieldMask, 'NextRunOn_time')).val('');
		}

		$hint_control.data('old_value', $input_value);
	}
}
