<?php
/**
* @version	$Id: reviews_config.php 15876 2013-07-05 11:11:19Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'rev',

		'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass'	=>	Array ('class' => 'ReviewsEventHandler', 'file' => 'reviews_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' =>	Array ('class' => 'ReviewsTagProcessor', 'file' => 'reviews_tag_processor.php', 'build_event' => 'OnBuild'),
		'AutoLoad'			=>	true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'RewriteListener' => 'CategoryItemRewrite:ReviewRewriteListener',

		'ParentPrefix' 		=> 'p', // replace all usage of rev to "p-rev" and then remove this param from here and Prefix too
		'ConfigMapping' => Array (
			'PerPage'				=>	'Comm_Perpage_Reviews',

			'ReviewDelayInterval'	=>	'product_ReviewDelay_Value',
			'ReviewDelayValue'		=>	'product_ReviewDelay_Interval',
		),

		'IDField'			=>	'ReviewId',
		'StatusField'		=>	Array ('Status'),	// field, that is affected by Approve/Decline events
		'TableName'			=>	TABLE_PREFIX.'CatalogReviews',
		'ParentTableKey'	=>	'ResourceId',	// linked field in master table
		'ForeignKey'		=>	'ItemId',		// linked field in subtable

		'AutoDelete'		=>	true,
		'AutoClone'			=>	true,

		'TitlePresets' => Array (
			'reviews_edit' => Array ('format' => "!la_title_Editing_Review!"),

			'reviews' => Array (
				'toolbar_buttons' => Array ('edit', 'delete', 'approve', 'decline', 'view', 'dbl-click'),
				),
		),

		'CalculatedFields' => Array (
			'' => Array (
				'ReviewedBy' => 'CASE %1$s.CreatedById WHEN ' . USER_ROOT . ' THEN "root" WHEN ' . USER_GUEST . ' THEN "Guest" ELSE IF(CONCAT(pu.FirstName, pu.LastName) <> "", CONCAT(pu.FirstName, " ", pu.LastName), pu.Username) END',
			),

			'products' => Array (
				'ReviewedBy'	=>	'CASE %1$s.CreatedById WHEN ' . USER_ROOT . ' THEN "root" WHEN ' . USER_GUEST . ' THEN "Guest" ELSE IF(CONCAT(pu.FirstName, pu.LastName) <> "", CONCAT(pu.FirstName, " ", pu.LastName), pu.Username) END',
				'ItemName'		=>	'pr.l1_Name',
				'ProductId'		=>	'pr.ProductId',
			),

			'product' => Array (
				'ReviewedBy'	=>	'CASE %1$s.CreatedById WHEN ' . USER_ROOT . ' THEN "root" WHEN ' . USER_GUEST . ' THEN "Guest" ELSE IF(CONCAT(pu.FirstName, pu.LastName) <> "", CONCAT(pu.FirstName, " ", pu.LastName), pu.Username) END',
				'ItemName'		=>	'pr.l1_Name',
				'ProductId'		=>	'pr.ProductId',
			),
		),

		// key - special, value - list select sql
		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
						FROM %1$s
					LEFT JOIN ' . TABLE_PREFIX . 'Users pu ON pu.PortalUserId = %1$s.CreatedById',

			'products'	=> 	'	SELECT %1$s.* %2$s
									FROM %1$s
								LEFT JOIN ' . TABLE_PREFIX . 'Products pr ON pr.ResourceId = %1$s.ItemId
					 				LEFT JOIN ' . TABLE_PREFIX . 'Users pu ON	pu.PortalUserId = %1$s.CreatedById',

			'product'	=> 	'	SELECT %1$s.* %2$s
									FROM %1$s
								LEFT JOIN ' . TABLE_PREFIX . 'Products pr ON pr.ResourceId = %1$s.ItemId
									LEFT JOIN ' . TABLE_PREFIX . 'Users pu ON	pu.PortalUserId = %1$s.CreatedById',
		),

		'ItemSQLs' => Array ('' => 'SELECT * FROM %s'),

		'ListSortings' => Array (
			'' => Array (
				'ForcedSorting' => Array ('Priority' => 'desc'),
				'Sorting' => Array ('ReviewId' => 'desc'),
			)
		),

		'Fields' =>	Array (
		    'ReviewId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'CreatedOn' => Array (
		    	'type' => 'int',
		    	'formatter' => 'kDateFormatter', 'default' => '#NOW#',
			),
		    'ReviewText' => Array (
		    	'type' => 'string',
		    	'formatter' => 'kFormatter',
		    	'using_fck' => 1, 'default' => null, 'required' => 1,
			),
		    'Rating' => Array (
		    	'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (
					0 => 'lu_None',
					1 => 'lu_Rating_1',
					2 => 'lu_Rating_2',
					3 => 'lu_Rating_3',
					4 => 'lu_Rating_4',
					5 => 'lu_Rating_5'),
				'use_phrases' => 1,
				'min_value_inc' => 0, 'max_value_inc' => 5, 'not_null' => 1, 'default' => 0,
			),
		    'IPAddress' => Array (
		    	'type' => 'string',
		    	'max_value_inc' => 15, 'not_null' =>1, 'default' => '',
			),
		    'ItemId' => Array (
		    	'type' => 'int',
		    	'not_null' => 1, 'default' => 0
			),
		    'CreatedById' => Array (
		    	'type' => 'int',
		    	'formatter' => 'kLEFTFormatter',
			 	'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
			 	'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users WHERE %s',
			 	'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD,
				'required' => 1, 'default' => NULL,
		    	'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
			),
		    'ItemType' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Status' => Array (
		    	'type' => 'int',
		    	'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
		    	'options' => Array (
					0 => 'la_Disabled',
					1 => 'la_Active',
					2 => 'la_Pending',
				),
				'not_null' =>1, 'default' => 2,
			),
		    'TextFormat' => Array (
		    	'type' => 'int',
		    	'formatter' => 'kOptionsFormatter',
		    	'options' => Array (0 => 'la_text', 1 => 'la_html'), 'use_phrases' => 1,
		    	'not_null' => 1, 'default' => 0,
			),
		    'Module' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			'HelpfulCount' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'NotHelpfulCount' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0)
		),

		'VirtualFields' => Array (
			'ReviewedBy' => Array ('type' => 'string', 'default' => ''),
			'CatalogItemName' => Array ('type' => 'string', 'default' => ''),
			'CatalogItemId' => Array ('type' => 'int', 'default' => 0),
			'CatalogItemCategory' => Array ('type' => 'int', 'default' => 0),

			'ItemName' => Array ('type' => 'string', 'default' => ''),
			'ProductId' => Array ('type' => 'int', 'default' => 0),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
					2 => 'icon16_pending.png',
				),
				'Fields' => Array (
					'ReviewId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
					'ReviewText' => Array ('filter_block' => 'grid_like_filter', 'width' => 210, 'first_chars' => 200, ),
					'ReviewedBy' => Array ( 'title' => 'la_col_ReviewedBy', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
					'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
					'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 80, ),
					'Rating' => Array ('filter_block' => 'grid_options_filter', 'width' => 80, ),
					'HelpfulCount' => Array ('filter_block' => 'grid_range_filter'),
					'NotHelpfulCount' => Array ('filter_block' => 'grid_range_filter'),
				),
			),

			'ReviewsSection' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
					2 => 'icon16_pending.png',
				),
				'Fields' => Array (
					'ReviewId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
					'ReviewText' => Array ('data_block' => 'grid_reviewtext_td', 'filter_block' => 'grid_like_filter', 'width' => 210, 'first_chars' => 200, ),
					'ReviewedBy' => Array ( 'title' => 'la_col_ReviewedBy', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
					'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
					'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 80, ),
					'Rating' => Array ('filter_block' => 'grid_options_filter', 'width' => 80, ),
					'HelpfulCount' => Array ('filter_block' => 'grid_range_filter'),
					'NotHelpfulCount' => Array ('filter_block' => 'grid_range_filter'),
				),
			),
		),
	);