<?php
/**
* @version	$Id: xml_helper5.php 14748 2011-11-09 09:35:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class XMLIterator implements Iterator
{
	private $var = array();

	public function __construct($array)
	{
		if ( is_array($array) ) {
			$this->var = $array;
		}
	}

	public function rewind()
	{
		reset($this->var);
	}

	public function current()
	{
		$var = current($this->var);
		return $var;
	}

	public function key()
	{
		$var = key($this->var);

		return $var;
	}

	public function next()
	{
		$var = next($this->var);

		return $var;
	}

	public function valid()
	{
		$var = $this->current() !== false;

		return $var;
	}
}

class kXMLNode5 extends kXMLNode implements IteratorAggregate {

    public function getIterator()
    {
    	$ret = new XMLIterator($this->Children);

        return $ret;
    }

    public function __destruct()
    {
//    	echo number_format(memory_get_usage()). ' &lt;-- Entered destructor for '.$this->Name.'<br/>';
    	unset($this->Attributes, $this->OriginalAttributes);

    	if ( isset($this->Children) ) {
	    	foreach ($this->Children as $key => $child) {
	    		if ( $this->Children[$key] instanceof kXMLNode5 ) {
	    			$this->Children[$key]->__destruct();
	    		}

	    		unset( $this->Children[$key] );
	    	}
    	}

    	unset($this->Children);
//    	echo number_format(memory_get_usage()). ' &lt;-- Destructed '.$this->Name.' Children <br/>';
    	unset($this->Name, $this->OriginalName);
    	unset($this->Data);
    	unset($this->firstChild);
    	unset($this->lastChild);
    	unset($this->Parent);
    	unset($this->Position);
    	unset($this->CRC);
    	unset($this);
    }
}

