function DragManager() {}

DragManager.DragObject = null;
DragManager.LastDragObject = null;
DragManager.MouseOffset = [0,0];
DragManager.ResizeHappening = false;
DragManager.ResizeTimer = null;
DragManager.InitialPos = null;
DragManager.Options = {};

DragManager.mouseCoords = function(ev)
{
	if(ev.pageX || ev.pageY){
		var res = {x:ev.pageX, y:ev.pageY};
	}
	else {
		var res = {
			x:ev.clientX + document.body.scrollLeft - document.body.clientLeft,
			y:ev.clientY + document.body.scrollTop  - document.body.clientTop
		};
	}
	return res;
}

DragManager.MakeDragable = function(object_id, startCallback, moveCallback, endCallback, options)
{
	var drag_object = document.getElementById(object_id);
	var cur_options = {'VerticalDrag': 1, 'HorizontalDrag': 1};
	if (options) {
		for(var i in options) {
			cur_options[i] = options[i];
		}
	}
	addEvent(drag_object, 'mousedown', function(ev){
		ev = ev || window.event;
		DragManager.InitialPos = findPos(drag_object);
		var coords = DragManager.mouseCoords(ev);
		var pos = findPos(drag_object);
		DragManager.MouseOffset = [coords.x - pos[0], coords.y - pos[1]];
		DragManager.DragObject = drag_object;
		DragManager.LastDragObject = drag_object;
		DragManager.DragObject.style.position = 'absolute';
		DragManager.Options = cur_options;
		startCallback(drag_object);
	});
	addEvent(document, 'mousemove', function(ev){
		ev = ev || window.event;
			var coords = DragManager.mouseCoords(ev);
		if(DragManager.DragObject){
			if (DragManager.Options.VerticalDrag) {
				DragManager.DragObject.style.top = (coords.y - DragManager.MouseOffset[1] ) + 'px' // ;
			}
			if (DragManager.Options.HorizontalDrag) {
				DragManager.DragObject.style.left = (coords.x - DragManager.MouseOffset[0] ) + 'px' // ;
			}
			moveCallback(drag_object, coords)
			return false;
		}
	});
	addEvent(document, 'mouseup', function(ev){
		var tmp = DragManager.DragObject;
		DragManager.DragObject = null;
		if(tmp){
			endCallback(tmp);
		}
	})
}

function init_resizer()
{
	DragManager.MakeDragable('resizer', resize_start,
		function(drag_object, coords) {
			if (DragManager.ResizeHappening && DragManager.ResizeTimer) {
				window.clearTimeout(DragManager.ResizeTimer);
				DragManager.ResizeTimer = false;
			}
			DragManager.ResizeHappening = true;
			DragManager.ResizeTimer = window.setTimeout(function() {
					var col = document.getElementById('col_a');
					var dim = getDimensions(col);
//						print_pre(dim);
					w = dim.innerWidth + (is.ie ? 0 : Math.round((dim.borders[1] + dim.borders[2])/2)) + (coords.x - DragManager.MouseOffset[0] - DragManager.InitialPos[0]);
					col.style.width = w+'px';
//						alert(' started at '+DragManager.InitialPos[0]+' with offset '+DragManager.MouseOffset[0]+' now coord: '+coords.x+' after setting w to '+w+' is inner: '+col.clientWidth + ' offset: '+col.offsetWidth)
					DragManager.ResizeHappening = false;
					DragManager.InitialPos = [coords.x - DragManager.MouseOffset[0], coords.y - DragManager.MouseOffset[1]];
				}, 100)

		}, resize_end)
}

function resize_start(obj)
{
//		alert('start at '+DragManager.InitialPos[0]);
}

function resize_end(obj)
{
//		alert('end');
}