<?php
/**
* @version	$Id: system_event_subscriptions_config.php 15608 2012-11-06 17:21:28Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'system-event-subscription',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'SystemEventSubscriptionEventHandler', 'file' => 'system_event_subscription_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'SystemEventSubscriptionTagProcessor', 'file' => 'system_event_subscription_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'SubscriptionId',

	'TableName' => TABLE_PREFIX . 'SystemEventSubscriptions',

	'TitleField' => 'SubscriptionId',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('system-event-subscription' => '!la_title_AddingSystemEventSubscription!'),
			'edit_status_labels' => Array ('system-event-subscription' => '!la_title_EditingSystemEventSubscription!'),
		),

		'system_event_subscription_list' => Array (
			'prefixes' => Array ('system-event-subscription_List'), 'format' => "!la_title_SystemEventSubscriptions!",
			'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'view', 'dbl-click'),
		),

		'system_event_subscription_edit' => Array (
			'prefixes' => Array ('system-event-subscription'), 'format' => "#system-event-subscription_status# '#system-event-subscription_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),
	),

	'PermSection' => Array('main' => 'in-portal:system_event_subscriptions'),

	'Sections' => Array (
		'in-portal:system_event_subscriptions' => Array (
			'parent'		=>	'in-portal:users',
			'icon'			=>	'system_event_subscriptions',
			'label'			=>	'la_title_SystemEventSubscriptions',
			'url'			=>	Array('t' => 'system_event_subscriptions/system_event_subscription_list', 'pass' => 'm'),
			'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
			'priority'		=>	6,
			'type'			=>	stTREE,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s
				LEFT JOIN ' . TABLE_PREFIX . 'EmailTemplates et ON %1$s.EmailTemplateId = et.TemplateId
				LEFT JOIN ' . TABLE_PREFIX . 'Users u ON %1$s.UserId = u.PortalUserId
				LEFT JOIN ' . TABLE_PREFIX . 'Categories c ON %1$s.CategoryId = c.CategoryId',
	),

	'CalculatedFields' => Array (
		'' => Array (
			'BindToSystemEvent' => 'et.BindToSystemEvent',
			'EmailTemplateName' => 'et.TemplateName',
			'Username' => 'CASE %1$s.UserId WHEN ' . USER_ROOT . ' THEN "root" WHEN ' . USER_GUEST . ' THEN "Guest" ELSE IF(CONCAT(u.FirstName, u.LastName) <> "", CONCAT(u.FirstName, " ", u.LastName), IF(%1$s.UserId IS NULL, "Guest", IF(u.Username = "", u.Email, u.Username))) END',
			'CategoryName' => 'c.l%2$s_Name',
			'ItemName' => '%1$s.ItemId',
			'ParentItemName' => '%1$s.ParentItemId',
		),
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('SubscriptionId' => 'desc'),
		)
	),

	'Fields' => Array (
		'SubscriptionId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'EmailTemplateId' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'EmailTemplates WHERE BindToSystemEvent <> "" ORDER BY TemplateName ASC', 'option_key_field' => 'TemplateId', 'option_title_field' => 'BindToSystemEvent',
			'required' => 1, 'default' => NULL
		),
		'SubscriberEmail' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'UserId' => Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users WHERE %s', 'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD, 'default' => NULL),
		'CategoryId' => Array ('type' => 'int', 'default' => NULL),
		'IncludeSublevels' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 1
		),
		'ItemId' => Array ('type' => 'int', 'default' => NULL),
		'ParentItemId' => Array ('type' => 'int', 'default' => NULL),
		'SubscribedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#')
	),

	'VirtualFields' => Array (
		'Username' => Array ('type' => 'string', 'default' => ''),
		'EmailTemplateName' => Array ('type' => 'string', 'default' => ''),
		'CategoryName' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Fields' => Array (
				'SubscriptionId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter', 'width' => 80),
				'EmailTemplateId' => Array ('title' => 'column:la_fld_SystemEvent', 'filter_block' => 'grid_options_filter', 'width' => 170),
				'EmailTemplateName' => Array ('filter_block' => 'grid_like_filter', 'width' => 170),
				'SubscriberEmail' => Array ('title' => 'column:la_fld_Email', 'filter_block' => 'grid_like_filter'),
				'UserId' => Array ('title' => 'la_col_PortalUserId', 'filter_block' => 'grid_range_filter', 'width' => 80),
				'Username' => Array ('filter_block' => 'grid_like_filter'),
				'CategoryId' => Array ('title' => 'column:la_fld_CategoryId', /*'data_block' => 'grid_category_td',*/ 'filter_block' => 'grid_range_filter', 'width' => 100),
				'IncludeSublevels' => Array ('filter_block' => 'grid_options_filter', 'width' => 100),
				'CategoryName' => Array ('title' => 'column:la_fld_Category', 'filter_block' => 'grid_like_filter', 'width' => 200),
				'ItemId' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
				'ItemName' => Array ('data_block' => 'grid_item_name_td', 'associated_field' => 'ItemId', 'filter_block' => 'grid_like_filter', 'width' => 120),
				'ParentItemId' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
				'ParentItemName' => Array ('data_block' => 'grid_item_name_td', 'associated_field' => 'ParentItemId', 'filter_block' => 'grid_like_filter', 'width' => 120),
				'SubscribedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 170)
			),
		),
	),
);