<?php

$config = Array (
	'Prefix' => 'promo-block',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'PromoBlockEventHandler', 'file' => 'promo_block_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'PromoBlockTagProcessor', 'file' => 'promo_block_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'BlockId',

	'TableName' => TABLE_PREFIX . 'PromoBlocks',

	'TitleField' => 'Title',

	'StatusField' => Array ('Status'),

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('promo-block' => '!la_title_AddingPromoBlock!'),
			'edit_status_labels' => Array ('promo-block' => '!la_title_EditingPromoBlock!'),
		),

		'promo_block_list' => Array ('prefixes' => Array ('promo-block-group', 'promo-block_List'), 'format' => "!la_tab_PromoBlocks! - #promo-block-group_titlefield# (#promo-block_recordcount#)"),
		'promo_block_edit' => Array ('prefixes' => Array ('promo-block'), 'format' => "#promo-block_status# '#promo-block_titlefield#'"),
	),

	'PermSection' => Array('main' => 'in-portal:promo_block_groups'),

	'CalculatedFields' => Array (
		'' => Array (
			'ConversionPercent' => 'IF(%1$s.NumberOfViews > 0, NumberOfClicks / NumberOfViews * 100, NULL)',
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Priority' => 'desc'),
		)
	),

	'Fields' => Array (
		'BlockId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'PromoBlockGroupId' => Array (
			'type' => 'int',
			'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'PromoBlockGroups ORDER BY Title', 'option_title_field' => 'Title', 'option_key_field' => 'PromoBlockGroupId',
			'not_null' => 1, 'required' => 1, 'default' => 0,
		),
		'Title' => Array (
			'type' => 'string', 'max_len' => 50,
			'formatter' => 'kMultiLanguage', 'db_type' => 'varchar(50)', 'not_null' => 1, 'required' => 1, 'default' => '',
		),
		'ButtonText' => Array (
			'type' => 'string', 'max_len' => 255,
			'formatter' => 'kMultiLanguage', 'db_type' => 'varchar(255)', 'not_null' => 1, 'default' => '',
		),
		'Status' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Enabled',  0 => 'la_Disabled'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 1,
		),
		'Priority' => Array(
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (),
			'not_null' => 1, 'required' => 1, 'default' => 0
		),
		'Sticky' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes',  0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		/*'CSSClassName' => Array(
			'type' => 'string',
			'formatter' => 'kOptionsFormatter',
			'options' => Array('promo-orange' => 'Orange', 'promo-green' => 'Green', 'promo-blue' => 'Blue'),
			'not_null' => 1, 'default' => '',
		),*/
		'LinkType' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Internal',  2 => 'la_opt_External'), 'use_phrases' => 1,
			'not_null' => 1, 'required' => 1, 'default' => 1,
		),
		'CategoryId' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'default' => NULL),
		'ExternalLink' => Array('type' => 'string', 'not_null' => 1, 'default' => ''),
		'OpenInNewWindow' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'ScheduleFromDate' => Array (
			'type' => 'int',
			'formatter' => 'kDateFormatter', 'time_format' => '', 'input_time_format' => '',
			'error_msgs' => Array ('wrong_date_interval' => '!la_ToDateMustBeGreaterThanFromDate!'),
			'default' => null,
		),
		'ScheduleToDate' => Array (
			'type' => 'int',
			'formatter' => 'kDateFormatter', 'time_format' => '', 'input_time_format' => '',
			'error_field' => 'ScheduleFromDate',
			'default' => null,
		),
		'NumberOfClicks' => Array ('type' => 'int', 'default' => 0, 'not_null' => 1),
		'NumberOfViews' => Array ('type' => 'int', 'default' => 0, 'not_null' => 1),
		'Html' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'db_type' => 'text', 'using_fck' => 1, 'default' => null),
	),

	'VirtualFields' => Array(
		'ConversionPercent' =>  Array('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%.0f', 'default' => NULL),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array ('default' => 'icon16_item.png', 0 => 'icon16_disabled.png'),
			'Fields' => Array (
				'BlockId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter', 'width' => 80),
				'Title' => Array ('filter_block' => 'grid_like_filter'),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 80),
				'Priority' => Array ('title' => 'column:la_fld_Order', 'filter_block' => 'grid_range_filter', 'width' => 80),
				'Sticky' => Array ('filter_block' => 'grid_options_filter', 'width' => 80),
//				'CSSClassName' => Array ('filter_block' => 'grid_options_filter'),
				'LinkType' => Array ('filter_block' => 'grid_options_filter'),
				'CategoryId' => Array ('title' => 'column:la_fld_Category', 'filter_block' => 'grid_options_filter', 'width' => 200),
				'ExternalLink' => Array ('filter_block' => 'grid_like_filter', 'width' => 200),
				'ScheduleFromDate' => Array ('title' => 'la_col_ScheduleFromDate', 'filter_block' => 'grid_date_range_filter', 'width' => 120),
				'ScheduleToDate' => Array ('title' => 'la_col_ScheduleToDate', 'filter_block' => 'grid_date_range_filter', 'width' => 120),
				'NumberOfClicks' => Array ('filter_block' => 'grid_range_filter'),
				'NumberOfViews' => Array ('filter_block' => 'grid_range_filter'),
				'ConversionPercent' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
			),
		),
	),
);
