<?php
/**
* @version	$Id: session_logs_config.php 15292 2012-04-12 08:45:37Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'session-log',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'SessionLogEventHandler', 'file' => 'session_log_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'Hooks' => Array (
			Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'u',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterLogin'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnStartSession',
			),

			Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'u',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnBeforeLogout'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnEndSession',
			),
		),

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'SessionLogId',
		'StatusField' => Array ('Status'),

		'TableName' => TABLE_PREFIX.'UserSessionLogs',

		'TitlePresets' => Array (
			'session_log_list' => Array ('prefixes' => Array('session-log_List'), 'format' => '!la_tab_SessionLogs!',
			'toolbar_buttons' => Array ('delete', 'view'),
			),
		),

		'PermSection' => Array('main' => 'in-portal:session_logs'),

		// don't forget to add corresponding permissions to install script
		// INSERT INTO Permissions VALUES (0, 'in-portal:session_logs.view', 11, 1, 1, 0), (0, 'in-portal:session_logs.delete', 11, 1, 1, 0);
		'Sections' => Array (
			'in-portal:session_logs' => Array (
				'parent'		=>	'in-portal:reports',
				'icon'			=>	'sessions_log',
				'label'			=>	'la_tab_SessionLog', // 'la_tab_SessionLogs',
				'url'			=>	Array('t' => 'logs/session_logs/session_log_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'delete'),
				'priority'		=>	2,
//				'show_mode'		=>	smSUPER_ADMIN,
				'type'			=>	stTREE,
			),
		),

		'TitleField' => 'SessionLogId',

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'Users AS u ON u.PortalUserId = %1$s.PortalUserId',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('SessionLogId' => 'desc'),
			)
		),

		'CalculatedFields' => Array(
			'' => Array(
				'UserLogin' => 'IF(%1$s.PortalUserId = ' . USER_ROOT . ', \'root\', u.Username)',
				'UserFirstName' => 'u.FirstName',
				'UserLastName' => 'u.LastName',
				'UserEmail' => 'u.Email',
				'Duration' => 'IFNULL(SessionEnd, UNIX_TIMESTAMP())-SessionStart',
			),
		),

		'ForceDontLogChanges' => true,

		'Fields' => Array (
		    'SessionLogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'PortalUserId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'SessionId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Status' => Array (
		    	'type' => 'int', 'formatter' => 'kOptionsFormatter',
		    	'options'=> array(0 => 'la_opt_Active', 1 => 'la_opt_LoggedOut', 2 => 'la_opt_Expired'),
		    	'use_phrases' => 1,
		    	'not_null' => 1, 'default' => 1
		    ),
		    'SessionStart' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'time_format' => 'H:i:s', 'default' => NULL),
		    'SessionEnd' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'time_format' => 'H:i:s', 'default' => NULL),
		    'IP' => Array ('type' => 'string', 'max_len' => 15, 'not_null' => 1, 'default' => ''),
		    'AffectedItems' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		),

		'VirtualFields' => Array(
			'Duration' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'date_format' => '', 'time_format' => 'H:i:s', 'use_timezone' => false, 'default' => NULL),
			'UserLogin' => Array ('type' => 'string', 'default' => ''),
			'UserFirstName' => Array ('type' => 'string', 'default' => ''),
			'UserLastName' => Array ('type' => 'string', 'default' => ''),
			'UserEmail' => Array ('type' => 'string', 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_item.png'),
				'Fields' => Array (
					'SessionLogId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'PortalUserId' => Array ('title' => 'la_col_PortalUserId', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'UserLogin' => Array ('title' => 'column:la_fld_Username', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
					'UserFirstName' => Array ('title' => 'column:la_fld_FirstName', 'filter_block' => 'grid_like_filter', 'width' => 120, ),
					'UserLastName' => Array ('title' => 'column:la_fld_LastName', 'filter_block' => 'grid_like_filter', 'width' => 120, ),
					'UserEmail' => Array ('title' => 'column:la_fld_Email', 'filter_block' => 'grid_like_filter', 'width' => 120, ),
					'SessionStart' => Array ('title' => 'la_col_SessionStart', 'filter_block' => 'grid_date_range_filter', 'width' => 120, ),
					'SessionEnd' => Array ('title' => 'la_col_SessionEnd', 'filter_block' => 'grid_date_range_filter', 'width' => 145,  ),
					'Duration' => Array ('filter_block' => 'grid_range_filter', 'width' => 100, ),
					'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100,  ),
					'IP' => Array ('title' => 'la_col_IP', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
					'AffectedItems' => Array ('title' => 'la_col_AffectedItems', 'data_block' => 'affected_td', 'filter_block' => 'grid_range_filter', 'width' => 120, ),
				),
			),
		),
	);