<?php
/**
* @version	$Id: email_logs_config.php 15608 2012-11-06 17:21:28Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'email-log',
		'ItemClass' => Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'EmailLogEventHandler', 'file' => 'email_log_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'EmailLogTagProcessor', 'file' => 'email_log_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'ScheduledTasks' => Array(
			'rotate_email_logs' => Array('EventName' => 'OnRotate', 'RunSchedule' => '0 0 * * *'),
		),

		'IDField' => 'EmailLogId',

		'TableName' => TABLE_PREFIX . 'EmailLog',

		'TitleField' => 'EmailLogId',

		'TitlePresets' => Array (
			'email_log_list' => Array ('prefixes' => Array('email-log_List'), 'format' => '!la_tab_EmailLog!'),

			'email_log_edit' => Array (
				'prefixes' => Array ('email-log'), 'format' => "!la_title_ViewingEmailLog! '#email-log_titlefield#'",
			),
		),

		'PermSection' => Array ('main' => 'in-portal:emaillog'),

		'Sections' => Array (
			'in-portal:emaillog' => Array (
				'parent'		=>	'in-portal:reports',
				'icon'			=>	'email_log',
				'label'			=>	'la_tab_EmailLog',
				'url'			=>	Array('t' => 'logs/email_logs/email_log_list', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'edit', 'delete'),
				'priority'		=>	5,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('SentOn' => 'desc'),
			)
		),

		'Fields' => Array (
			'EmailLogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'From' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'To' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'OtherRecipients' => Array ('type' => 'string', 'default' => NULL),
			'Subject' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'HtmlBody' => Array ('type' => 'string', 'default' => NULL),
			'TextBody' => Array ('type' => 'string', 'default' => NULL),
			'SentOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			'TemplateName' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'EventType' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Text_Admin', 0 => 'la_Text_User'), 'use_phrases' => 1,
				'default' => NULL
			),
			'EventParams' => Array ('type' => 'string', 'default' => NULL),
			'AccessKey' => Array ('type' => 'string', 'max_len' => 20, 'not_null' => 1, 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Fields' => Array (
					'EmailLogId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 80),
					'From' => Array ('title' => 'column:la_fld_Sender', 'filter_block' => 'grid_like_filter', 'width' => 200),
					'To' => Array ('title' => 'column:la_fld_Recipient', 'filter_block' => 'grid_like_filter', 'width' => 200),
					'Subject' => Array ('filter_block' => 'grid_like_filter', 'width' => 200),
					'TemplateName' => Array ('filter_block' => 'grid_like_filter', 'width' => 170),
					'EventType' => Array ('title' => 'column:la_fld_Type', 'filter_block' => 'grid_options_filter', 'width' => 60),
					'SentOn' => Array ('title' => 'la_prompt_SentOn', 'filter_block' => 'grid_date_range_filter', 'width' => 145),
//					'EventParams' => Array ('title' => 'la_col_EventParams', 'filter_block' => 'grid_like_filter'),
				),
			),
		),
	);