<?php
/**
 * @version	$Id: content_tp.php 15257 2012-04-03 09:46:32Z alex $
 * @package	In-Portal
 * @copyright	Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
 * @license	  GNU/GPL
 * In-Portal is Open Source software.
 * This means that this software may have been modified pursuant
 * the GNU General Public License, and as distributed it includes
 * or is derivative of works licensed under the GNU General Public License
 * or other free or open source software licenses.
 * See http://www.in-portal.org/license for copyright notices and details.
 */

defined('FULL_PATH') or die('restricted access!');

class ContentTagProcessor extends kDBTagProcessor {

	/**
	 * Creates a button for editing item in Admin Console
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function AdminEditButton($params)
	{
		if ( EDITING_MODE != EDITING_MODE_CONTENT ) {
			return '';
		}

		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$params['pass'] = 'm,c,content';
		$params['c_id'] = $object->GetDBField('PageId');
		$params['admin'] = 1;

		$params['temp_mode'] = 0;
		$params['template'] = 'categories/edit_content';
		$params['button_icon'] = 'content_mode.png';
		$params['button_class'] = 'cms-edit-btn';
		$params['button_title'] = '+' . $this->Application->Phrase('la_btn_EditContent', false, true);

		if ( defined('DEBUG_MODE') && DEBUG_MODE ) {
			$params['button_title'] .= ' - #' . $params['num'];
		}

		unset($params['num']);

		return parent::AdminEditButton($params);
	}
}