<?php
/**
* @version	$Id: left_formatter.php 15563 2012-10-09 16:05:41Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

/**
 * Replacement for kOptionsFormatter in case if options
 * should be selected from database. Use this formatter
 * only in case if formatter attached field is in edit form.
 *
 * For usage in grid just use LEFT JOIN clause to table
 * where requested options are located.
 */
class kLEFTFormatter extends kFormatter {

	/**
	 * Formats value of a given field
	 *
	 * @param string $value
	 * @param string $field_name
	 * @param kDBItem|kDBList $object
	 * @param string $format
	 * @return string
	 */
	function Format($value, $field_name, &$object, $format=null)
	{
		if ( is_null($value) ) {
			return '';
		}

		$options = $object->GetFieldOptions($field_name);
		if ( isset($format) ) {
			$options['format'] = $format;
		}

		if ( !isset($options['options'][$value]) ) {
			// required option is not defined in config => query for it
			$display_field = $this->_escapeField($options['left_title_field']);
			$match_field = $this->_escapeField($options['left_key_field']);

			$sql = sprintf($options['left_sql'], $display_field, $match_field . ' = ' . $this->Conn->qstr($value));
			$options['options'][$value] = $this->Conn->GetOne($sql);

			if ( $options['options'][$value] === false ) {
				return $value;
			}
		}

		return $options['options'][$value];
	}

	/**
	 * Escape field names, but not expressions
	 *
	 * @param string $field_name
	 * @return string
	 * @access protected
	 */
	protected function _escapeField($field_name)
	{
		if ( preg_match('/^[a-z_]+$/i', $field_name) ) {
			return '`' . $field_name . '`';
		}

		return $field_name;
	}

	/**
	 * Performs basic type validation on form field value
	 *
	 * @param mixed $value
	 * @param string $field_name
	 * @param kDBItem $object
	 * @return mixed
	 * @access public
	 */
	public function Parse($value, $field_name, &$object)
	{
		if ( $value == '' ) {
			return NULL;
		}

		$options = $object->GetFieldOptions($field_name);
		$found = isset($options['options']) ? array_search($value, $options['options']) : false;

		if ( $found !== false ) {
			// requested option found among field options
			return $found;
		}

		// requested option is not found in field options -> query for it
		$display_field = $this->_escapeField($options['left_key_field']);
		$match_field = $this->_escapeField($options['left_title_field']);

		$sql = sprintf($options['left_sql'], $display_field, $match_field . ' = ' . $this->Conn->qstr($value));
		$found = $this->Conn->GetOne($sql);

		if ( $found !== false ) {
			// option successfully retrieved from db -> cache it
			$options['options'][$found] = $value;
		}

		$skip_errors = array_key_exists('skip_errors', $options) && $options['skip_errors'];

		if ( $found === false && !$skip_errors ) {
			// option not found at all -> return not formatted value & set error
			$object->SetError($field_name, 'invalid_option', 'la_error_InvalidOption');
			return $value;
		}

		return $found;
	}
}