<?php
/**
* @version	$Id: product_option_formatters.php 15141 2012-03-04 08:08:18Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class kCombinationFormatter extends kFormatter {

		/**
		 * Formats value of a given field
		 *
		 * @param string $value
		 * @param string $field_name
		 * @param kDBItem|kDBList $object
		 * @param string $format
		 * @return string
		 */
		function Format($value, $field_name, $object, $format=null)
		{
			$o = '';
			$options = $object->GetFieldOptions($field_name);
			if ( isset($format) ) $options['format'] = $format;
			$data = unserialize($value);
			$opt_helper = $this->Application->recallObject('kProductOptionsHelper');

			$top_prefix = $this->Application->GetTopmostPrefix($object->Prefix);
			$use_temp = substr($this->Application->GetVar($top_prefix.'_mode'), 0, 1) == 't';

			foreach ($data as $key=>$val) {
				$conv_key = $opt_helper->ConvertKey($key, $object->GetDBField('ProductId'),$use_temp);

				if (is_array($val)) {
					$val = join(',', $val);
				}

				$o .= sprintf($options['format'], $conv_key['Name'], $val);
			}
			return $o;
		}

		/**
		 * Performs basic type validation on form field value
		 *
		 * @param mixed $value
		 * @param string $field_name
		 * @param kDBItem $object
		 * @return mixed
		 * @access public
		 */
		public function Parse($value, $field_name, &$object)
		{
			if ( !is_array($value) ) {
				$object->SetError($field_name, 'required');
				return '';
			}
			else {
				if ( $object->isRequired($field_name) ) {
					foreach ($value as $key => $val) {
						if ( $val == '' ) {
							$object->SetError($field_name, 'required');
						}
					}
				}
			}
			return serialize($value);
		}
	}

	class kCombPriceFormatter extends kFormatter {

		/**
		 * Formats value of a given field
		 *
		 * @param string $value
		 * @param string $field_name
		 * @param kDBItem|kDBList $object
		 * @param string $format
		 * @return string
		 */
		function Format($value, $field_name, $object, $format=null)
		{
			$options = $object->GetFieldOptions($field_name);
			$converted = array_key_exists('converted', $options) ? $options['converted'] : false;

			if ($converted) {
				$lang = $this->Application->recallObject('lang.current');
				return $lang->formatNumber($object->GetDBField($field_name), 2);
			}

			$data = unserialize($object->GetDBField('Combination'));
			$opt_helper = $this->Application->recallObject('kProductOptionsHelper');

			$price = $object->GetDBField('BasePrice');
			$addition = 0;

			$top_prefix = $this->Application->GetTopmostPrefix($object->Prefix);
			$use_temp = substr($this->Application->GetVar($top_prefix.'_mode'), 0, 1) == 't';

			foreach ($data as $key=>$val) {
				$conv_key = $opt_helper->ConvertKey($key, $object->GetDBField('ProductId'), $use_temp);
				$parsed = $opt_helper->ExplodeOptionValues($conv_key);
				if (!$parsed) continue;

				$conv_prices = $parsed['Prices'];
				$conv_price_types = $parsed['PriceTypes'];

				if ($conv_price_types[$val] == '$')
				{
					$addition += $conv_prices[$val];
				}
				elseif ($conv_price_types[$val] == '%')
				{
					$addition += $price * $conv_prices[$val] / 100;
				}
			}

			$price += $addition;

			$price_type = $object->GetDBField('PriceType');
			$price_mod = $object->GetDBField('Price');
			switch ($price_type) {
				case 1: // = override
					$price = $price_mod;
					break;
				case 2: // flat
					$price = $price + $price_mod;
					break;
				case 3: // percent
					$price = $price * (1 + $price_mod / 100);
					break;
			}
			return $price;
		}
	}