<?php
/**
* @version	$Id: pricing_tag_processor.php 15156 2012-03-04 09:27:14Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class PricingTagProcessor extends kDBTagProcessor {

	function ProductPrice($params)
	{
		$object = $this->Application->recallObject($params['PrefixSpecial']);
		$price = $object->GetField('Price');

		// display selected currency by default
		if (!isset($params['currency']) || $params['currency'] == 'selected') {
			$iso = $this->Application->RecallVar('curr_iso');
		}
		elseif ($params['currency'] == 'primary') {
			$iso = 'USD';
		}
		else { //explicit currency
			$iso = $params['currency'];
		}

		// convert primary currency to selected (if they are the same, converter will just return)

		$converter = $this->Application->recallObject('CurrencyRates');
		/* @var $converter CurrencyRates */

		$price = $converter->Convert($price, 'PRIMARY', $iso);

		$currency = $this->Application->recallObject('curr.-'.$iso, null, Array('skip_autoload' => true));
		if( !$currency->isLoaded() ) $currency->Load($iso, 'ISO');

		$symbol = $currency->GetDBField('Symbol');
		if (!$symbol) $symbol = $currency->GetDBField('ISO');
		$formatted = '';
		if ($currency->GetDBField('SymbolPosition') == 0) {
			$formatted .= $symbol;
		}
		$formatted .= $price;
		if ($currency->GetDBField('SymbolPosition') == 1) {
			$formatted .= $symbol;
		}

		return $formatted;
	}

	function Product_ListPriceBrackets($params)
	{
		return $this->PrintList2($params);
	}

	function Field($params)
	{
		$field = $this->SelectParam($params, 'name,field');
		$value = parent::Field($params);
		if (($field == 'MaxQty') && ($value == -1)) {
			$value = '&infin;';
		}
		return $value;
	}

	function Product_HasQuantityPricing($params)
	{
		return (int)$this->TotalRecords($params) > 1;
	}


	function ShowPricingForm($params)
	{
		$br_object = $this->getObject( Array('skip_autoload' => true) );

		$br_data = $this->Application->GetVar("pr_tang");

		$group_id = $this->Application->getVar('group_id');
		if($group_id>0){
			$where_group=' AND GroupId = '.$group_id.' ';
		}

		if(!$br_data)
		{
			$sql = 	'SELECT * FROM '.$br_object->TableName.' WHERE ProductId = '.$this->Application->GetVar('p_id').' '.$where_group;
			$brackets = $this->Conn->Query($sql, 'PriceId');

			usort($brackets, 'pr_bracket_comp');

			$dummy = $this->Application->recallObject($this->Prefix.'.-dummy', null, array('skip_autoload' => true));
			/* @var $dummy kDBItem */

			foreach($brackets as $id => $values)
			{
				foreach($values as $value_key=>$value_val){
					$dummy->SetDBField($value_key, $value_val);
					$brackets[$id][$value_key] = $dummy->GetField($value_key);
				}
			}

			$br_data=$brackets;
			$this->Application->SetVar($this->getPrefixSpecial(true), $brackets);
		}
		else
		{
			usort($br_data , 'pr_bracket_comp');

		}

		$ret = '';
		if( is_array($br_data) )
		{

			$block_params=$this->prepareTagParams($params);
			$block_params['IdField']='PriceId';
			$block_params['name'] = $params['block'];
			$first = true;

			// this is needed to find next id
			$br_data_copy=$br_data;
			foreach($br_data as $id => $values)
			{

				foreach($values as $value_key=>$value_val){
					$block_params[$value_key] = $value_val;
				}
				reset($values);

				next($br_data_copy);
				$next_bracket=current($br_data_copy);

				$block_params['id']	= $values["PriceId"];
				$block_params['min']	= ($id == -1) ? ($values['MinQty'] ? $values['MinQty'] : 0) : $values['MinQty'];
				$block_params['max'] = ($values['MaxQty'] == -1) ? '&infin;' : $values['MaxQty'];
				$block_params['next_min_id']=$next_bracket['PriceId'];

				if ($first)
				{
					$block_params['first'] = 1;
					$first = false;
				}
				else
				{
					$block_params['first'] = 0;
				}
				$ret .= $this->Application->ParseBlock($block_params, 1);
			}
		}
		return $ret;
	}

	function AddToCartLink($params)
	{
		$value = $this->Field(array('name'=>'PriceId'));
		//$this->Application->SetVar('p_id', $this->Application->GetVar($this->getPrefixSpecial().'_id'));
		$this->Application->SetVar('pr_id', $value);
		return $this->Application->HREF($params['template'], '', Array('pass' => 'm,p,pr,ord', 'ord_event' => 'OnAddToCart'));
	}
}