<?php
/**
* @version	$Id: constants.php 15020 2012-01-09 17:14:45Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	// order statuses
	define('ORDER_STATUS_INCOMPLETE',	0);
	define('ORDER_STATUS_PENDING',		1);
	define('ORDER_STATUS_BACKORDERS',	2);
	define('ORDER_STATUS_TOSHIP',		3);
	define('ORDER_STATUS_PROCESSED',	4);
	define('ORDER_STATUS_DENIED',		5);
	define('ORDER_STATUS_ARCHIVED',		6);

	/**
	 * ID of order, that 100% not in database
	 *
	 */
	define('FAKE_ORDER_ID', -1);

	define('PRODUCT_TYPE_TANGIBLE',		1);
	define('PRODUCT_TYPE_SUBSCRIPTION',	2);
	define('PRODUCT_TYPE_SERVICE',		3);
	define('PRODUCT_TYPE_DOWNLOADABLE',	4);
	define('PRODUCT_TYPE_PACKAGE',		5);

	// payment gateway processing statuses
	define('SHIPPING_CONTROL_DIRECT', 3);
	define('SHIPPING_CONTROL_PREAUTH', 4);

	// gift certificate statuses
	define('gcENABLED', 1);
	define('gcUSED', 2);
	define('gcDISABLED', 0);

	define('USPS_LABEL_FOLDER', WRITEABLE . '/user_files/labels/');

	define('ORDER_SHIP_ALL_TOGETHER', 0);
	define('ORDER_SHIP_BACKORDERS_SEPARATELY', 1);
	define('ORDER_SHIP_BACKORDERS_UPON_AVAILABLE', 2);

	define('ORDER_GROUP_SHIPPMENTS_AUTO', 0);
	define('ORDER_GROUP_SHIPPMENTS_MANUAL', 1);

	define('PRODUCT_SHIPPING_MODE_ANY_AND_SELECTED', 0);
	define('PRODUCT_SHIPPING_MODE_SELECTED_ONLY', 1);

	class OrderCheckoutError {
		const STATE_CHANGED = 10;
		const CHANGED_AFTER_LOGIN = 11;

		const QTY_UNAVAILABLE = 20; // orditems:Quantity (users tries to order more, then in stock)
		const QTY_OUT_OF_STOCK = 21; // orditems:Quantity (product was sold out, after it was added to cart, but before checkout)
		const QTY_CHANGED_TO_MINIMAL = 22; // orditems:Quantity (qty change to minimal available by price brackets)

		const COUPON_APPLIED = 30; // orditems:ItemData, general
		const COUPON_REMOVED = 31; // orditems:ItemData, general
		const COUPON_REMOVED_AUTOMATICALLY = 32; // when discount is more efficient, then coupon being applied
		const COUPON_CODE_INVALID = 33; // general
		const COUPON_CODE_EXPIRED = 34; // general

		const GC_APPLIED = 40; // general
		const GC_REMOVED = 41; // general
		const GC_REMOVED_AUTOMATICALLY = 42; // general
		const GC_CODE_INVALID = 43; // general
		const GC_CODE_EXPIRED = 44; // general

		// new, to integrate
		const DISCOUNT_APPLIED = 50; // orditems:ItemData, general
		const DISCOUNT_REMOVED = 51; // orditems:ItemData, general

		const FIELD_UPDATE_SUCCESS = 60; // when order item field is changed + not discount/coupon related
		const FIELD_UPDATE_ERROR = 61; // when order item field can't be changed + not discount/coupon related
	}

	class OrderCheckoutErrorType {
		const PRODUCT = 1;
		const COUPON = 2;
		const GIFT_CERTIFICATE = 3;
		const DISCOUNT = 4;
	}

	class ProductInventory {
		const DISABLED = 0;
		const BY_PRODUCT = 1;
		const BY_OPTIONS = 2;
	}

	class ProductBackorder {
		const AUTO = 2;
		const ALWAYS = 1;
		const NEVER = 0;
	}

	class OptionType {
		const DROPDOWN = 1;
		const TEXT = 5;
		const TEXTAREA = 4;
		const RADIO = 3;
		const CHECKBOX = 6;
	}

	class OptionCombinationPriceType {
		const EQUALS = 1;
		const FLAT = 2;
		const PECENT = 3;
	}

	class DiscountType {
		const FLAT = 1;
		const PERCENT = 2;
	}

	class DiscountItemType {
		const PRODUCT = 1;
		const CATEGORY = 2;
		const WHOLE_ORDER = 0;
	}

	class CouponType {
		const FLAT = 1;
		const PERCENT = 2;
	}

	class CouponItemType {
		const PRODUCT = 1;
		const CATEGORY = 2;
		const WHOLE_ORDER = 0;
	}
