<?php
/**
* @version	$Id: worldpay.php 14258 2011-03-16 21:43:52Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	require_once GW_CLASS_PATH.'/gw_base.php';

	$class_name = 'kGWWorldPay'; // for automatic installation

	class kGWWorldPay extends kGWBase
	{
		function InstallData()
		{
			$data = array(
				'Gateway' => Array('Name' => 'Worldpay', 'ClassName' => 'kGWWorldPay', 'ClassFile' => 'worldpay.php', 'RequireCCFields' => 0),
				'ConfigFields' => Array(
					'submit_url' => Array('Name' => 'Submit URL', 'Type' => 'text', 'ValueList' => '', 'Default' => 'https://select.worldpay.com/wcc/purchase'),
					'instId' => Array('Name' => 'Installation ID', 'Type' => 'text', 'ValueList' => '', 'Default' => ''),
					'callback_pw' => Array('Name' => 'Callback Password', 'Type' => 'text', 'ValueList' => '', 'Default' => ''),
				)
			);
			return $data;
		}

		/**
		 * Returns payment form submit url
		 *
		 * @param Array $gw_params gateway params from payment type config
		 * @return string
		 */
		function getFormAction($gw_params)
		{
			return $gw_params['submit_url'];
		}

		/**
		 * Processed input data and convets it to fields understandable by gateway
		 *
		 * @param Array $item_data
		 * @param Array $tag_params additional params for gateway passed through tag
		 * @param Array $gw_params gateway params from payment type config
		 * @return Array
		 */
		function getHiddenFields($item_data, $tag_params, $gw_params)
		{
			$ret = Array();

			$ret['instId'] = $gw_params['instId'];
			$ret['cartId'] = $item_data['OrderNumber'];

			if (!$this->IsTestMode()) {
				$ret['amount'] = sprintf('%.2f', $item_data['TotalAmount']); // the total amount to be billed, in decimal form, without a currency symbol. (8 characters, decimal, 2 characters: Example: 99999999.99)
			}
			else {
				$ret['testMode'] = 100; // 100 - success, 101 - failure
				$ret['amount'] = 1;
			}

			$ret['currency'] = 'USD';
			$ret['desc'] = 'Order #'.$item_data['OrderNumber'];

			$ret['name'] = $item_data['BillingTo'];
			$ret['address'] = $item_data['BillingAddress1'];
			if ($item_data['BillingAddress2']) {
				$ret['address'] .= '&#10;'.$item_data['BillingAddress2'];
			}
			$ret['postcode'] = $item_data['BillingZip'];

			$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
			/* @var $cs_helper kCountryStatesHelper */

			$ret['country'] = $cs_helper->getCountryIso( $item_data['BillingCountry'] );
			$ret['tel'] = $item_data['BillingPhone'];
			$ret['fax'] = $item_data['BillingFax'];
			$ret['email'] = $item_data['BillingEmail'];
			$ret['fixContact'] = 1; // contact-info not editable ?

			$return_params = Array ('pass' => 'm', 'sid' => $this->Application->GetSID(), 'admin' => 1);
			$ret['MC_return_page'] = $this->Application->HREF($tag_params['return_template'], '', $return_params);
			$ret['MC_cancel_return_page'] = $this->Application->HREF($tag_params['cancel_template'], '', $return_params);
			$ret['MC_callback'] = $this->getNotificationUrl() . '?sid='.$this->Application->GetSID().'&admin=1&order_id='.$item_data['OrderId'];

			return $ret;
		}

		function processNotification($gw_params)
		{
    		// http://support.worldpay.com/kb/integration_guides/junior/integration/help/appendicies/sjig_10100.html
    		// SubmitURL: https://select.worldpay.com/wcc/purchase
			// for Notification to work do this in gateway Admin Console:
    		// Callback URL: <WPDISPLAY ITEM=MC_callback>
    		// Callback enabled? [x]
    		// Use callback response?[x]
			$transaction_verified = ($this->Application->GetVar('callbackPW') == $gw_params['callback_pw']);
    		if (!$transaction_verified) {
    			return 0;
    		}

    		$transaction_status = $this->Application->GetVar('transStatus') == 'Y' ? 1 : 0;

    		$curl_helper =& $this->Application->recallObject('CurlHelper');
			/* @var $curl_helper kCurlHelper */

			$url = $this->Application->GetVar($transaction_status ? 'MC_return_page' : 'MC_cancel_return_page');
			echo $curl_helper->Send($url);

    		return $transaction_status;
		}
	}