<?php
/**
* @version	$Id: currency_rates.php 14258 2011-03-16 21:43:52Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class BankLVCurrencyRates extends CurrencyRates  {

	public function __construct()
	{
		$this->RateSource = 'http://www.bank.lv/ValutuKursi/XML/xml.cfm';

		parent::__construct();
	}

	function GetRatesData()
	{
		$xml_parser = xml_parser_create();

		$curl_helper =& $this->Application->recallObject('CurlHelper');
		/* @var $curl_helper kCurlHelper */

		$xml = $curl_helper->Send($this->RateSource);

		xml_parse_into_struct($xml_parser, $xml, $struct, $index);
		$data_res = Array();
		$currency = '';
		foreach($struct as $element)
		{
			switch($element['tag'])
			{
				case 'ID':
					$currency = $element['value'];
					$data_res[$currency]['ID'] = $currency;
					$data_res[$currency]['TARGET'] = 'LVL';
				break;
				case 'UNITS':
					$data_res[$currency]['UNITS'] = $element['value'];
				break;
				case 'RATE':
					$data_res[$currency]['RATE'] = $element['value'];
				break;
				default:
			}
		}

		if(!$data_res['LVL'])
		{
			$data_res['LVL']['ID'] = 'LVL';
			$data_res['LVL']['UNITS'] = 1;
			$data_res['LVL']['TARGET'] = 'LVL';
			$data_res['LVL']['RATE'] = 1;
		}
		$this->ExchangeRates = $data_res;
	}
}
