<?php
/**
* @version	$Id: shipping_quote_engine_event_handler.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ShippingQuoteEngineEventHandler extends kDBEventHandler {

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnBeforeItemUpdate(&$event)
	{
		parent::OnBeforeItemUpdate($event);

		$object =& $event->getObject();
		/* @var $object kDBItem */

		$engine =& $this->Application->recallObject( $object->GetDBField('ClassName') );
		/* @var $engine ShippingQuoteEngine */

		$engine_fields = $engine->GetEngineFields();
		$properties = $object->GetDBField('Properties');
		$properties = $properties ? unserialize($properties) : Array ();

		// common fields for all shipping quote engines
		if ($object->GetDBField('AccountPassword') != '') {
			// don't erase password by accident
			$engine_fields[] = 'AccountPassword';
		}

		// save shipping quote specific fields
		foreach ($engine_fields as $engine_field) {
			$properties[$engine_field] = $object->GetDBField($engine_field);
		}

		$object->SetDBField('Properties', serialize($properties));

		$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
		/* @var $cs_helper kCountryStatesHelper */

		$from_country = $this->Application->ConfigValue('Comm_Shipping_Country');
		$has_states = strlen($from_country) == 3 ? $cs_helper->CountryHasStates($from_country) : false;

		$valid_address = 	$from_country && ($has_states && $this->Application->ConfigValue('Comm_Shipping_State') || !$has_states) &&
							$this->Application->ConfigValue('Comm_Shipping_City') && $this->Application->ConfigValue('Comm_Shipping_ZIP');

		if (!function_exists('curl_init')) {
			$object->SetError('Status', 'curl_not_present');
		}
		elseif (($object->GetDBField('Status') == STATUS_ACTIVE) && !$valid_address) {
			$object->SetError('Status', 'from_info_not_filled_in');
		}
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function iterateItems(&$event)
	{
//		$event->setEventParam('SkipProcessing', 1);
		parent::iterateItems($event);
		if($event->Name == 'OnMassApprove')
		{
			$event->status = erSUCCESS;
			$event->redirect = true;
		}
	}

	/**
	 * Sets virtual fields from serialized properties array
	 *
	 * @param kEvent $event
	 */
	function OnAfterItemLoad(&$event)
	{
		parent::OnAfterItemLoad($event);

		$object =& $event->getObject();
		/* @var $object kDBItem */

		$properties = $object->GetDBField('Properties');

		if ($properties) {
			$object->SetDBFieldsFromHash( unserialize($properties) );
		}
	}

	/**
	 * Deletes cached shipping quotes on any setting change
	 *
	 * @param kEvent $event
	 */
	function OnAfterItemCreate(&$event)
	{
		parent::OnAfterItemCreate($event);

		$this->_deleteQuoteCache();
	}

	/**
	 * Deletes cached shipping quotes on any setting change
	 *
	 * @param kEvent $event
	 */
	function OnAfterItemUpdate(&$event)
	{
		parent::OnAfterItemUpdate($event);

		$this->_deleteQuoteCache();
	}

	/**
	 * Deletes cached shipping quotes on any setting change
	 *
	 * @param kEvent $event
	 */
	function OnAfterItemDelete(&$event)
	{
		parent::OnAfterItemDelete($event);

		$this->_deleteQuoteCache();
	}

	/**
	 * Deletes cached shipping quotes
	 *
	 */
	function _deleteQuoteCache()
	{
		$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Cache
				WHERE VarName LIKE "ShippingQuotes%"';
		$this->Conn->Query($sql);
	}
}