<?php
/**
* @version	$Id: shipping_quote_engine.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ShippingQuoteEngine extends kHelper {

	/**
	 * Quote engine specific properties
	 *
	 * @var Array
	 */
	var $properties = Array ();

	function ShippingQuoteEngine()
	{
		parent::kHelper();

		$this->initProperties();
	}

	/**
	 * $params = Array(
	 *		'AccountLogin'		=>	'login',
	 *		'AccountPassword'	=>	'pass',
	 *		'carriers'	=>	Array(
	 *							Array(
	 *								'name'		=>	'UPS',
	 *								'account'	=>	'',
	 *								'invoiced'	=>	'0'
	 *							),
	 *							Array(
	 *								'name'		=>	'DHL',
	 *								'account'	=>	'',
	 *								'invoiced'	=>	'0'
	 *							),
	 *							Array(
	 *								'name'		=>	'FDX',
	 *								'account'	=>	'',
	 *								'invoiced'	=>	'0'
	 *							),
	 *							Array(
	 *								'name'		=>	'USP',
	 *								'account'	=>	'',
	 *								'invoiced'	=>	'0'
	 *							),
	 *							Array(
	 *								'name'		=>	'ARB',
	 *								'account'	=>	'',
	 *								'invoiced'	=>	'0'
	 *							),
	 *						),
	 *		'classes'		=>	Array('1DY', '2DY', '3DY', 'GND'),
	 *
	 *		'ShipMethod'	=>	'DRP',
	 *
	 *		'orig_name'		=>	'John%20Smith',
	 *		'orig_addr1'	=>	'2275%20Union%20Road',
	 *		'orig_city'		=>	'Cheektowaga',
	 *		'orig_state'	=>	'NY',
	 *		'orig_postal'	=>	'14227',
	 *		'orig_country'	=>	'US',
	 *
	 *		// this section is required
	 *		'dest_name'		=>	'Vasya%20Pupkin',
	 *		'dest_addr1'	=>	'175%20E.Hawthorn%20pkwy.',
	 *		'dest_city'		=>	'Vernon%20Hills',
	 *		'dest_state'	=>	'IL',
	 *		'dest_postal'	=>	'60061',
	 *		'dest_country'	=>	'US',
	 *
	 *		// this section is required
	 *		'packages' 		=>	Array(
	 *			Array(
	 *				'package_key'	=>	'package1',
	 *				'weight'		=>	'50',
	 *				'weight_unit'	=>	'LB',
	 *				'length'		=>	'25',
	 *				'width'			=>	'15',
	 *				'height'		=>	'15',
	 *				'dim_unit'		=>	'IN',
	 *				'packaging'		=>	'BOX',
	 *				'contents'		=>	'OTR',
	 *				'insurance'		=>	'0'
	 *			),
	 *			Array(
	 *				'package_key'	=>	'package2',
	 *				'weight'		=>	'50',
	 *				'weight_unit'	=>	'LB',
	 *				'length'		=>	'25',
	 *				'width'			=>	'15',
	 *				'height'		=>	'15',
	 *				'dim_unit'		=>	'IN',
	 *				'packaging'		=>	'BOX',
	 *				'contents'		=>	'OTR',
	 *				'insurance'		=>	'0'
	 *			),
	 *		),
	 *
	 *		'shipment_id'	=>	1234;
	 *	);
	 *
	 *
	 *	Returns:
	 *
	 *	$quotes = Array(
	 *		'package1'	=>
	 *			Array(
	 *				Array(
	 *					'id'	=>	'INTSH_FDX_2DY',
	 *					'type' => 'FDX',
	 *					..
	 *					'amount' =>	24.24,
	 *				)
	 *				Array(
	 *					'type' => 'FDX',
	 *					..
	 *					'amount' =>	24.24,
	 *				)
	 *			),
	 *		'package2'	=>
	 *			Array(
	 *				Array(
	 *					'id'	=>	'INTSH_FDX_3DY',
	 *					'type' => 'FDX',
	 *	 				..
	 *					'amount' =>	24.24,
	 *				)
	 *				Array(
	 *					'type' => 'FDX',
	 *					..
	 *					'amount' =>	24.24,
	 *				)
	 *			),
	 *		)
	 *
	 * @param Array $params
	 */
	function GetShippingQuotes($params)
	{

	}

	/**
	 * Returns list of shipping types, that can be selected on product editing page
	 *
	 * @return Array
	 */
	function GetAvailableTypes()
	{
		return Array ();

	}

	/**
	 * Returns virtual field names, that will be saved as properties
	 *
	 * @return Array
	 */
	function GetEngineFields()
	{
		return Array ();
	}

	/**
	 * Sends order to shipping quote engine
	 *
	 * @param OrdersItem $object
	 * @param bool $dry_run
	 * @return Array
	 */
	function MakeOrder(&$object, $dry_run = false)
	{
		return Array ();
	}

	/**
	 * Loads properties of shipping quote engine
	 *
	 */
	function initProperties()
	{
		$sql = 'SELECT Properties, FlatSurcharge, PercentSurcharge
				FROM ' . $this->Application->getUnitOption('sqe', 'TableName') . '
				WHERE LOWER(ClassName) = ' . $this->Conn->qstr( strtolower( get_class($this) ) );
		$data = $this->Conn->GetRow($sql);

		if (is_array($data)) {
			$properties = $data['Properties'] ? unserialize($data['Properties']) : Array ();
			$properties['FlatSurcharge'] = $data['FlatSurcharge'];
			$properties['PercentSurcharge'] = $data['PercentSurcharge'];

			$this->properties = $properties;
		}
		else {
			$this->properties = Array ();
		}
	}
}