<?php
/**
* @version	$Id: currencies_tag_processor.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class CurrenciesTagProcessor extends kDBTagProcessor {

	function DisableUnusedWarning($params)
	{
		$saved_ids = $this->Application->RecallVar('saved_curr_ids');			// when saving currency(-ies)
		$check_all = $this->Application->RecallVar('check_unused_currencies');	// when saving payment type
		$ret = '';
		if($saved_ids || $check_all)
		{
			$sql = 'SELECT DISTINCT CurrencyId FROM '.$this->Application->getUnitOption('ptc', 'TableName');
			$used_ids = $this->Conn->GetCol($sql);
			if($check_all)
			{
				$sql = 'SELECT DISTINCT CurrencyId FROM '.$this->Application->getUnitOption('curr', 'TableName');
				$all_ids = $this->Conn->GetCol($sql);
				$unused_ids = implode(',', array_diff($all_ids, $used_ids) );
				$this->Application->RemoveVar('check_unused_currencies');
			}
			else
			{
				$saved_ids = explode(',', $saved_ids);
				$unused_ids = implode(',', array_diff($saved_ids, $used_ids) );
				$this->Application->RemoveVar('saved_curr_ids');
			}

			if($unused_ids)
			{
				$this->Application->SetVar('unused_ids', $unused_ids);
				$sql = 'SELECT ISO FROM '.$this->Application->getUnitOption($this->Prefix, 'TableName').' WHERE CurrencyId IN('.$unused_ids.') AND Status = 1';
				if($params['unused_iso'] = implode(', ', $this->Conn->GetCol($sql)))
				{
					$params['unused_ids'] = $unused_ids;
					$params['name'] = $params['block'];
					$ret = $this->Application->ParseBlock($params);
				}
			}
		}
		return $ret;
	}

	function ListCurrencies($params)
	{
		return $this->PrintList2($params);
	}

	function SelectedCurrency($params)
	{
		$object =& $this->Application->recallObject($this->getPrefixSpecial());

		return $object->GetDBField('ISO') == $this->Application->RecallVar('curr_iso');
	}

	function PrimaryCurrencyISO($params)
	{
		$sql = 'SELECT ISO FROM '.$this->Application->getUnitOption($this->Prefix, 'TableName').' WHERE IsPrimary = 1';
		return $this->Conn->GetOne($sql);
	}

	function PrimaryCurrencyName($params)
	{
		$sql = 'SELECT Name FROM '.$this->Application->getUnitOption($this->Prefix, 'TableName').' WHERE IsPrimary = 1';
		return $this->Application->Phrase( $this->Conn->GetOne($sql) );
	}
}