<?php
/**
* @version	$Id: affiliate_payments_event_handler.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class AffiliatePaymentsEventHandler extends kDBEventHandler {

		/**
		 * Enter description here...
		 *
		 * @param kDBItem $object
		 * @param kEvent $event
		 */
		function prepareObject(&$object, &$event)
		{
			if($event->Special == 'log') return false;

			$parent_info = $object->getLinkedInfo();
			$parent_object =& $this->Application->recallObject($parent_info['ParentPrefix']);
			$options = $object->getFieldOptions('PaymentTypeId');

			if($parent_object->isLoaded())
			{
				$options['default'] = $parent_object->GetDBField('PaymentTypeId');
				$object->SetDBField('PaymentTypeId', $parent_object->GetDBField('PaymentTypeId'));
			}

			if($this->Application->GetVar($event->Prefix_Special.'_event') != 'OnNew' && $this->Application->GetVar($event->Prefix_Special.'_event') != 'OnCreate')
			{
				$options['options'][0] = '';
			}

			$object->setFieldOptions('PaymentTypeId', $options);
		}

		/**
		 * Set's fields based on affiliate currently beeing edited
		 *
		 * @param kEvent $event
		 */
		function OnNew(&$event)
		{
			parent::OnNew($event);

			$affiliate =& $this->Application->recallObject('affil');
			$object =& $event->getObject( Array('skip_autoload'=>true) );
			$object->SetDBField('Amount', $affiliate->GetDBField('AmountToPay') );
			$object->SetDBField('AffiliateId', $affiliate->GetID() );
		}

		/**
		 * Set's day of payment for newly created payments
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			$object =& $event->getObject( Array('skip_autoload'=>true) );
		}

		/**
		 * Updates Affiliate Record On Successfuly payment creation
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemCreate(&$event)
		{
			$object =& $event->getObject( Array('skip_autoload' => true) );
			$parent_info = $object->getLinkedInfo();
			$sql = 'SELECT MAX(PaymentDate) FROM '.$object->TableName.'
					WHERE '.$parent_info['ParentTableKey'].' = '.$parent_info['ParentId'];
			$payment_date = $this->Conn->GetOne($sql);

			$amount_payed = $object->GetDBField('Amount');

			$affiliate =& $this->Application->recallObject('affil');
			$affiliate->SetDBField( 'AmountToPay', $affiliate->GetDBField('AmountToPay') - $amount_payed );
			$affiliate->SetDBField('LastPaymentDate_date', $payment_date);
			$affiliate->SetDBField('LastPaymentDate_time', $payment_date);
			$affiliate->Update();
		}

		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();
			if($event->Special == 'log')
			{
				$object->removeFilter('parent_filter');
			}

			$types = $event->getEventParam('types');
			if ($types=='my_payments')
			{
				$user_id = $this->Application->RecallVar('user_id');
				$object->removeFilter('parent_filter');
				$object->addFilter('my_payments', 'au.PortalUserId = '.$user_id);
			}

			if ($types=='myvisitororders')
			{
				$user_id = $this->Application->RecallVar('user_id');
				$object->addFilter('myitems_orders','ord.OrderId IS NOT NULL');
				$object->addFilter('myitems_user1','au.PortalUserId = '.$user_id);
				$object->addFilter('myitems_user2','au.PortalUserId > 0');
			}
		}

	}