<?php
/**
* @version	$Id: download_helper.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class DownloadHelper extends kHelper {

		function CheckAccess($file_id, $product_id)
		{
			$sql = 'SELECT FileAccessId FROM '.TABLE_PREFIX.'UserFileAccess
							WHERE PortalUserId = '.$this->Application->RecallVar('user_id').'
							AND ProductId = '.$product_id;
			return $this->Conn->GetOne($sql);
		}

		function SendFile($file_id, $product_id)
		{
			$file_object =& $this->Application->recallObject('file', null, Array('skip_autoload' => true));

			$sql = $file_id ?
						'SELECT FileId, FilePath, RealPath, MIMEType FROM '.$this->Application->getUnitOption('file', 'TableName').'
							WHERE FileId = '.$file_id :
						'SELECT FileId, FilePath, RealPath, MIMEType FROM '.$this->Application->getUnitOption('file', 'TableName').'
							WHERE ProductId = '.$product_id.' AND IsPrimary = 1';
			$file_info = $this->Conn->GetRow($sql);

			$field_options = $file_object->getFieldOptions('RealPath');
			$file_info['real_path'] = FULL_PATH.$field_options['upload_dir'].'/'.$file_info['RealPath'];
			$file_info = $this->DoSendFile($file_info);
			return $file_info;
		}

		function DoSendFile($file_info)
		{
			$content_type = function_exists('mime_content_type') ? mime_content_type($file_info['real_path']) : $file_info['MIMEType'];

			header('Content-type: '.$content_type);
			header('Content-Disposition: attachment; filename="'.$file_info['FilePath'].'"');
			header('Content-Length: '.filesize($file_info['real_path']));

			$file_info['download_start'] = adodb_mktime();
			readfile($file_info['real_path']);
			flush();
			$file_info['download_end'] = adodb_mktime(); // this is incorrect
			define('SKIP_OUT_COMPRESSION', 1);
			return $file_info;
		}

		function LogDownload($product_id, $file_info)
		{
			$down_object =& $this->Application->recallObject('down', null, Array('skip_autoload' => true));
			$user_object =& $this->Application->recallObject('u.current');
			$product_object =& $this->Application->recallObject( 'p' );

			$down_object->SetDBField('PortalUserId', $this->Application->RecallVar('user_id'));
			$down_object->SetDBField('Username', $user_object->GetDBField('Login'));
			$down_object->SetDBField('ProductId', $product_id);
			$down_object->SetDBField('ProductName', $product_object->GetField('Name'));
			$down_object->SetDBField('FileId', $file_info['FileId']);
			$down_object->SetDBField('Filename', $file_info['FilePath']);
			$down_object->SetDBField('IPAddress', $_SERVER['REMOTE_ADDR']);
			$down_object->SetDBField('StartedOn_date', $file_info['download_start']);
			$down_object->SetDBField('StartedOn_time', $file_info['download_start']);

			$down_object->Create();
		}

	}