<?php
/**
* @version	$Id: brackets_event_handler.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class BracketsEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array(
								'OnMoreBrackets'	=>	Array('subitem' => 'add|edit'),
								'OnInfinity'		=>	Array('subitem' => 'add|edit'),
								'OnArrange'			=>	Array('subitem' => 'add|edit'),
						);
		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	function prepareObject(&$object, &$event)
	{
		if($this->Application->GetVar('s_id') === false)
		{
			return;
		}

		$shipping_object =& $this->Application->recallObject('s');
		$lang_object =& $this->Application->recallObject('lang.current');

		if($lang_object->GetDBField('UnitSystem') == 2 && $shipping_object->GetDBField('Type') == 1)
		{
			$fields = Array('Start', 'End');
			$formatter =& $this->Application->recallObject('kUnitFormatter');
			foreach($fields as $field)
			{
				$options = $object->GetFieldOptions($field);
				$options['formatter'] = 'kUnitFormatter';
				$object->SetFieldOptions($field, $options);
				$formatter->prepareOptions($field, $options, $object);
			}
		}
	}

	function prepareBrackets(&$event)
	{
		$lang_object =& $this->Application->recallObject('lang.current');
		$shipping_object =& $this->Application->recallObject('s');
		if($lang_object->GetDBField('UnitSystem') != 2 || $shipping_object->GetDBField('Type') != 1)
		{
			return;
		}

		$item_info = $this->Application->GetVar( $event->Prefix_Special );
		foreach($item_info as $id => $item_data)
		{
			if($item_info[$id]['Start_a'] === '' && $item_info[$id]['Start_b'] === '')
			{
				$item_info[$id]['Start'] = '';
			}
			else
			{
				$item_info[$id]['Start'] = Pounds2Kg($item_info[$id]['Start_a'], $item_info[$id]['Start_b']);
			}

			if($item_info[$id]['End_a'] == '&#8734;' || $item_info[$id]['End_a'] == '&infin;')
			{
				$item_info[$id]['End'] = '&#8734;';
			}
			elseif($item_info[$id]['End_a'] === '' && $item_info[$id]['End_b'] === '')
			{
				$item_info[$id]['End'] = '';
			}
			else
			{
				$item_info[$id]['End'] = Pounds2Kg($item_info[$id]['End_a'], $item_info[$id]['End_b']);
			}
		}
		$this->Application->SetVar( $event->Prefix_Special, $item_info );
	}

	/**
	 * Adds additional 5 empty brackets
	 *
	 * @param kEvent $event
	 */
	function OnMoreBrackets(&$event)
	{
		$shipping_object =& $this->Application->recallObject('s');
		$default_start = ($shipping_object->GetDBField('Type') == 1) ? 0 : 1;

		$this->prepareBrackets($event);

		$event->redirect = false;

		$brackets_helper =& $this->Application->recallObject('BracketsHelper');
		$brackets_helper->InitHelper('Start', 'End', Array(), $default_start );
		$brackets_helper->OnMoreBrackets($event);
	}

	/**
	 * Arrange brackets
	 *
	 * @param kEvent $event
	 */
	function OnArrange(&$event)
	{
		$shipping_object =& $this->Application->recallObject('s');
		$default_start = ($shipping_object->GetDBField('Type') == 1) ? 0 : 1;

		$this->prepareBrackets($event);

		$event->redirect = false;
		$brackets_helper =& $this->Application->recallObject('BracketsHelper');
		/* @var $brackets_helper kBracketsHelper */

		$brackets_helper->InitHelper('Start', 'End', Array(), $default_start);

		$brackets_helper->arrangeBrackets($event);
		$event->CallSubEvent('OnPreSaveBrackets');
	}

	/**
	 * Arrange infinity brackets
	 *
	 * @param kEvent $event
	 */
	function OnInfinity(&$event)
	{
		$shipping_object =& $this->Application->recallObject('s');
		$default_start = ($shipping_object->GetDBField('Type') == 1) ? 0 : 1;

		$this->prepareBrackets($event);

		$event->redirect = false;
		$brackets_helper =& $this->Application->recallObject('BracketsHelper');
		$brackets_helper->InitHelper('Start', 'End', Array(), $default_start );
		$brackets_helper->arrangeBrackets($event);

		$event->CallSubEvent('OnPreSaveBrackets');

		$brackets_helper->OnInfinity($event);

		$event->CallSubEvent('OnPreSaveBrackets');
	}

	function OnBeforeItemUpdate(&$event)
	{
		$shipping_object =& $this->Application->recallObject('s');
		$default_start = ($shipping_object->GetDBField('Type') == 1) ? 0 : 1;

		$object =& $event->getObject();
		$linked_info = $object->getLinkedInfo();
		$object->SetDBField($linked_info['ParentTableKey'], $linked_info['ParentId']);

		$brackets_helper =& $this->Application->recallObject('BracketsHelper');
		$brackets_helper->InitHelper('Start', 'End', Array(), $default_start );
		$brackets_helper->replaceInfinity($event);
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnPreSaveBrackets(&$event)
	{
		$lang_object =& $this->Application->recallObject('lang.current');
		$shipping_object =& $this->Application->recallObject('s');
		if($lang_object->GetDBField('UnitSystem') == 2 && $shipping_object->GetDBField('Type') == 1)
		{
			$item_info = $this->Application->GetVar( $event->Prefix_Special );
			if(is_array($item_info))
			{
				foreach($item_info as $id => $values)
				{
					if($values['End'] == -1)
					{
						$item_info[$id]['End_a'] = -1 / POUND_TO_KG;
						$item_info[$id]['End_b'] = 0;
					}
				}
				$this->Application->SetVar( $event->Prefix_Special, $item_info );
			}
		}

		$default_start = ($shipping_object->GetDBField('Type') == 1) ? 0 : 1;

		$brackets_helper =& $this->Application->recallObject('BracketsHelper');
		$brackets_helper->InitHelper('Start', 'End', Array(), $default_start );
		$brackets_helper->OnPreSaveBrackets($event);
	}

}