<?php
/**
* @version	$Id: manufacturers_event_handler.php 13465 2010-04-28 15:08:00Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ManufacturersEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array(
			'OnItemBuild' => Array('self' => true),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function SetCustomQuery(&$event)
	{
		if ($this->Application->isAdminUser) {
			return ;
		}

		$category_id = $this->Application->GetVar('m_cat_id');
		$parent_category_id = $event->getEventParam('parent_cat_id');

		if ($parent_category_id) {
			if ($parent_category_id != 'any' && $parent_category_id > 0) {
				$category_id = $parent_category_id;
			}
		}

		$sql = 'SELECT m.ManufacturerId, COUNT(p.ProductId)
				FROM '.TABLE_PREFIX.'Manufacturers m
				LEFT JOIN '.TABLE_PREFIX.'Products p ON p.ManufacturerId = m.ManufacturerId
				LEFT JOIN '.TABLE_PREFIX.'CategoryItems ci ON ci.ItemResourceId = p.ResourceId
				LEFT JOIN '.TABLE_PREFIX.'Category c ON c.CategoryId = ci.CategoryId
				WHERE (ci.PrimaryCat = 1) AND (p.Status = ' . STATUS_ACTIVE . ') AND (c.Status = ' . STATUS_ACTIVE . ') GROUP BY m.ManufacturerId';

		// add category filter

		$tree_indexes = $this->Application->getTreeIndex($category_id);

		// if category_id is 0 returs false
		if ($tree_indexes) {
			$sql .=  ' AND c.TreeLeft BETWEEN '.$tree_indexes['TreeLeft'].' AND '.$tree_indexes['TreeRight'];
		}

		$manufacturers = $this->Conn->GetCol($sql);

		$object =& $event->getObject();

		$object->addFilter('category_manufacturer_filter', $manufacturers ? '%1$s.ManufacturerId IN (' . implode(',', $manufacturers) . ')' : 'FALSE');
	}


	/**
	 * Prefill states dropdown with correct values
	 *
	 * @param kEvent $event
	 * @access public
	 */
	function OnAfterItemLoad(&$event)
	{
		parent::OnAfterItemLoad($event);

		$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
		/* @var $cs_helper kCountryStatesHelper */

		$cs_helper->PopulateStates($event, 'State', 'Country');
	}

	/**
	 * Processes states
	 *
	 * @param kEvent $event
	 */
	function OnBeforeItemUpdate(&$event)
	{
		parent::OnBeforeItemUpdate($event);

		$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
		/* @var $cs_helper kCountryStatesHelper */

		$cs_helper->CheckStateField($event, 'State', 'Country');
		$cs_helper->PopulateStates($event, 'State', 'Country');
	}

	/**
	 * Processes states
	 *
	 * @param kEvent $event
	 */
	function OnBeforeItemCreate(&$event)
	{
		parent::OnBeforeItemCreate($event);

		$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
		/* @var $cs_helper kCountryStatesHelper */

		$cs_helper->CheckStateField($event, 'State', 'Country');
		$cs_helper->PopulateStates($event, 'State', 'Country');
	}
}