<?php
/**
* @version	$Id: taxes_config.php 13549 2010-05-11 21:03:39Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'tax',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'TaxesEventHandler', 'file' => 'taxes_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'TaxesTagProcessor', 'file' => 'taxes_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,
					'hooks'				=>	Array (),
					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					/*'Hooks'				=>	Array (
							Array (
								'Mode' => hBEFORE,
								'Conditional' => true,
								'HookToPrefix' => 'tax',
								'HookToSpecial' => '',
								'HookToEvent' => Array ( 'onEdit' ),
								'DoPrefix' => '',
								'DoSpecial' => '',
								'DoEvent' => 'OnLoadZoneForm',
							),
						),*/
					'IDField'			=>	'TaxZoneId',
					'TitleField'		=>  'Name',
					'TitlePresets'		=>	Array (
												'default'	=>	Array (	'new_status_labels'		=> Array ('tax' => '!la_title_AddingTaxZone!'),
																		'edit_status_labels'	=> Array ('tax' => '!la_title_EditingTaxZone!'),
																		'new_titlefield'		=> Array ('tax' => '!la_title_NewTaxZone!'),
																),
												'taxes_list' =>Array (	'prefixes'				=> Array ('tax_List'),
																		'format'				=>	"!la_title_Taxes!",
																),
												'taxes_edit' =>Array (	'prefixes'				=> Array ('tax'),
																		'new_titlefield'		=> Array ('tax' => '!la_title_NewTax!'),
																		'format'				=> "#tax_status# '#tax_titlefield#' - !la_title_General!",
																),


											),
					'PermSection'		=>	Array ('main' => 'in-commerce:taxes'),

					'Sections'			=>	Array (
						'in-commerce:taxes'	=>	Array (
							'parent'		=>	'in-commerce:setting_folder',
							'icon'			=>	'conf_taxes',
							'label'			=>	'la_tab_Taxes',
							'url'			=>	Array ('t' => 'in-commerce/taxes/taxes_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	6,
							'type'			=>	stTREE,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'TaxZones',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'SubItems' =>	Array ('taxdst'),

					'ListSQLs'			=>	Array (	'' =>	'SELECT %1$s.* %2$s FROM %s'),
																		 // key - special, value - list select sql


					'ListSortings'	=> 	Array (
																'' => Array (
																	'Sorting' => Array ('Name' => 'asc', 'TaxValue' => 'asc'),
																)
															),
					'Fields'			=>	Array (
					    'TaxZoneId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
					    'Name' => Array ('type' => 'string', 'not_null' => 1, 'default' => '', 'required' => 1, 'max_len' =>100, 'error_msgs' => Array ('required' => 'Please fill in')),
					    'Type' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array (1 => 'la_ByCountry', 2 => 'la_ByState', 3 => 'la_ByZIP'), 'not_null' => 1, 'default' => 1),
					    'TaxValue' => Array ('type' => 'double', 'not_null' => 1, 'default' => 0),
					    'ApplyToShipping' => Array (
					    	'type' => 'int', 
					    	'formatter' => 'kOptionsFormatter', 
					    	'options' =>Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
							'default' => 0, 'not_null' => 1, 
						),
					    'ApplyToProcessing' => Array (
					    	'type' => 'int', 
					    	'formatter' => 'kOptionsFormatter', 
					    	'options' =>Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
							'default' => 0, 'not_null' => 1, 
						), 
					),

					'Grids'	=> Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								'module' => 'core',
								'module' => 'core',
							),
							'Fields' => Array (
								'TaxZoneId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
								'Name' => Array ( 'title' => 'la_col_TaxZoneName', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'TaxValue' => Array ( 'title' => 'la_col_TaxValue', 'filter_block' => 'grid_float_range_filter', 'width' => 110, ),
								'Type' => Array ( 'title' => 'la_col_ZoneType', 'filter_block' => 'grid_options_filter', 'width' => 90, ),
								'ApplyToShipping' => Array ( 'title' => 'la_col_TaxApplyToShipping', 'filter_block' => 'grid_options_filter', 'width' => 140, ),
								'ApplyToProcessing' => Array ( 'title' => 'la_col_TaxApplyToProcessing', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
							),
						),
					),
	);