<?php
/**
* @version	$Id: coupon_items_event_handler.php 13745 2010-06-09 17:32:28Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class CouponItemsEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array(
								'OnEntireOrder'	=>	Array('subitem' => 'add|edit'),
						);
		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Adds products from selected categories and their sub-categories and directly selected products to coupon items with duplicate checking
	 *
	 * @param kEvent $event
	 */
	function OnProcessSelected(&$event)
	{
		// uses another handler event, because does the same stuff but on different table
		$di_handler =& $this->Application->recallObject('di_EventHandler');
		$di_handler->OnProcessSelected($event);
	}

	/**
	 * Allows to set discount on entire order
	 *
	 * @param kEvent $event
	 * @todo get parent item id through $object->getLinkedInfo()['ParentId']
	 * @access public
	 */
	function OnEntireOrder(&$event)
	{
		$object =& $event->GetObject();
		$sql = 'DELETE FROM '.$object->TableName.' WHERE CouponId='.$this->Application->GetVar('coup_id');
		$this->Conn->Query($sql);

		$object->SetDBField('CouponId', $this->Application->GetVar('coup_id'));
		$object->SetDBField('ItemResourceId', -1);
		$object->SetDBField('ItemType', 0);

		if ( $object->Create() ) {
			$this->customProcessing($event, 'after');
			$event->status = erSUCCESS;
			$event->redirect_params = Array('opener' => 's'); //stay!
		}
		else {
			$event->status = erFAIL;
			$this->Application->SetVar($event->Prefix_Special.'_SaveEvent','OnCreate');
			$object->setID(0);
		}
	}

	/**
	 * Deletes discount items where hooked item (product) is used
	 *
	 * @param kEvent $event
	 */
	function OnDeleteCouponItem(&$event)
	{
		$main_object =& $event->MasterEvent->getObject();
		$resource_id = $main_object->GetDBField('ResourceId');

		$table = $this->Application->getUnitOption($event->Prefix,'TableName');
		$sql = 'DELETE FROM '.$table.' WHERE ItemResourceId = '.$resource_id;
		$this->Conn->Query($sql);
	}

	/**
	 * Makes ItemName calcualted field from primary language
	 *
	 * @param kEvent $event
	 */
	function OnAfterConfigRead(&$event)
	{
		parent::OnAfterConfigRead($event);

		$calculated_fields = $this->Application->getUnitOption($event->Prefix, 'CalculatedFields');

		$language_id = $this->Application->GetVar('m_lang');
		$primary_language_id = $this->Application->GetDefaultLanguageId();

		$calculated_fields['']['ItemName'] = 'COALESCE(p.l' . $language_id . '_Name, p.l' . $primary_language_id . '_Name)';
		$this->Application->setUnitOption($event->Prefix, 'CalculatedFields', $calculated_fields);
	}
}