<inp2:adm_SetPopupSize width="650" height="480"/>

<inp2:m_include t="incs/header"/>
<inp2:m_RenderElement name="combined_header" prefix="s" section="in-commerce:shipping" title_preset="zones_edit"/>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
<tbody>
	<tr>
  	<td>
  		<script type="text/javascript">
				a_toolbar = new ToolBar();
				a_toolbar.AddButton( new ToolBarButton('select', '<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>', function() {
							SelectAll(document.getElementById('location_list[]'));
							SelectToString(document.getElementById('location_list[]'));
							submit_event('z','<inp2:z_SaveEvent/>');
						}
					) );
				a_toolbar.AddButton( new ToolBarButton('cancel', '<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>', function() {
							submit_event('z','OnCancel');
						}
				 ) );

				a_toolbar.AddButton( new ToolBarSeparator('sep1') );

				a_toolbar.AddButton( new ToolBarButton('prev', '<inp2:m_phrase label="la_ToolTip_Prev" escape="1"/>', function() {
							go_to_id('z', '<inp2:z_PrevId/>');
						}
				 ) );
				a_toolbar.AddButton( new ToolBarButton('next', '<inp2:m_phrase label="la_ToolTip_Next" escape="1"/>', function() {
							go_to_id('z', '<inp2:z_NextId/>');
						}
				 ) );

				a_toolbar.AddButton( new ToolBarSeparator('sep2') );

				a_toolbar.Render();

				<inp2:m_if check="z_IsSingle" >
					a_toolbar.HideButton('prev');
					a_toolbar.HideButton('next');
					a_toolbar.HideButton('sep1');
					a_toolbar.HideButton('sep2');
				<inp2:m_else/>
					<inp2:m_if check="z_IsLast" >
						a_toolbar.DisableButton('next');
					</inp2:m_if>
					<inp2:m_if check="z_IsFirst" >
						a_toolbar.DisableButton('prev');
					</inp2:m_if>
				</inp2:m_if>

			</script>
		</td>
	</tr>
</tbody>
</table>

<inp2:m_DefineElement name="destination_block" selected="">
	<option value="<inp2:m_param name="id"/>" <inp2:m_param name="selected"/>><inp2:m_param name="destination_title"/></option>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="countries_multiple">
	<tr class="<inp2:m_odd_even odd='edit-form-odd' even='edit-form-even'/>">
		<inp2:m_inc param="tab_index" by="1"/>
		<td class="label-cell">&nbsp;</td>
		<td class="control-mid">&nbsp;</td>
		<td class="control-cell">
			<table>
			<tr><td>
				<inp2:m_Phrase label="la_zones_SelectedCountries"/>:<br/>
				<select name="location_list[]" id="location_list[]" multiple onchange="SelectToString(this)" size="10" style="width: 200px">
					<inp2:z_ShowCountries block="destination_block" show="current"/>
				</select>

			</td>
			<td>
				<input class="button" type=button onclick="MoveSelected(this.form.ShippingZoneIdChooser, document.getElementById('location_list[]'))" value="&lt;"><br/>
				<input class="button" type=button onclick="MoveSelected(document.getElementById('location_list[]'), this.form.ShippingZoneIdChooser)" value="&gt;">
			</td>
			<td>
				<inp2:m_Phrase label="la_zones_AvailableCountries"/>:<br/>
				<select name="ShippingZoneIdChooser" multiple size="10" size="10" style="width: 200px">
					<inp2:z_ShowCountries block="destination_block" show="available"/>
				</select>
			</td>
			</tr>
			</table>
		</td>
	</tr>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="states_multiple">
	<tr class="<inp2:m_odd_even odd='edit-form-odd' even='edit-form-even'/>">
		<td class="label-cell">&nbsp;</td>
		<td class="control-mid">&nbsp;</td>
		<td class="control-cell">
				<select name="CountrySelector" onChange="change_country()">
					<inp2:z_ShowCountries block="destination_block" show="has_states"/>
				</select>
					<br />
			<table>
			<tr><td>
				<inp2:m_Phrase label="la_zones_SelectedStates"/>:<br/>
				<select name="location_list[]" id="location_list[]" multiple onchange="SelectToString(this)" size="10" style="width: 200px">
					<inp2:z_ShowStates block="destination_block" show="current"/>
				</select>
			</td>
			<td>
				<input class="button" type=button onclick="MoveSelected(this.form.ShippingZoneIdChooser, document.getElementById('location_list[]'))" value="&lt;"><br/>
				<input class="button" type=button onclick="MoveSelected(document.getElementById('location_list[]'), this.form.ShippingZoneIdChooser)" value="&gt;">
			</td>
			<td>
				<inp2:m_Phrase label="la_zones_AvailableStates"/>:<br/>
				<select name="ShippingZoneIdChooser" multiple size="10" style="width: 200px">
					<inp2:z_ShowStates block="destination_block" show="available"/>
				</select>
			</td>
			</tr>
			</table>
		</td>
	</tr>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="zips_multiple">
	<tr class="<inp2:m_odd_even odd='edit-form-odd' even='edit-form-even'/>">
		<td class="label-cell">&nbsp;</td>
		<td class="control-mid">&nbsp;</td>
		<td class="control-cell">
				<select name="CountrySelector" onChange="change_country()">
					<inp2:z_ShowCountries block="destination_block" show="all"/>
				</select>
					<br />
			<table>
			<tr><td>
				<inp2:m_Phrase label="la_zones_SelectedZips"/>:<br/>
				<select name="location_list[]" id="location_list[]" multiple onchange="SelectToString(this)" size="10" style="width: 200px">
					<inp2:z_ShowZips block="destination_block" show="current"/>
				</select>
			</td>
			<td>
				<input class="button" type=button onclick="MoveSelected(this.form.ShippingZoneIdChooser, document.getElementById('location_list[]'))" value="&lt;"><br/>
				<input class="button" type=button onclick="MoveSelected(document.getElementById('location_list[]'), this.form.ShippingZoneIdChooser)" value="&gt;">
			</td>
			<td>
				<inp2:m_Phrase label="la_zones_AvailableZips"/>:<br/>
				<select name="ShippingZoneIdChooser" multiple size="10" style="width: 200px">
					<inp2:z_ShowZips block="destination_block" show="available"/>
				</select>
			</td>
			</tr>
			</table>
			<br>
			<input type="text" name="zone_add" id="zone_add"> <input type="button" onClick="add_zone(document.getElementById('location_list[]'))" value="<inp2:m_Phrase label='la_btn_AddLocation'/>" class="button"/>
		</td>
	</tr>
</inp2:m_DefineElement>


<inp2:z_SaveWarning name="grid_save_warning"/>
<inp2:z_ErrorWarning name="form_error_warning"/>

<!--## used for OnCountryChange event ##-->
<input type="hidden" name="z_id" value="<inp2:z_Field name='ZoneID'/>"/>

<div id="scroll_container">
	<table class="edit-form">
		<inp2:m_RenderElement name="subsection" title="la_section_ShippingZone"/>
			<inp2:m_RenderElement name="inp_id_label" prefix="z" field="ZoneID" title="la_fld_Id"/>

			<inp2:m_RenderElement name="inp_label" prefix="z" field="ShippingTypeID" title="la_fld_ShippingTypeId"/>

			<inp2:m_RenderElement name="inp_edit_box" prefix="z" field="Name" title="la_fld_ShipZoneName" size="40"/>
			<inp2:m_RenderElement name="inp_edit_checkbox" prefix="z" field="CODallowed" title="la_fld_CODallowed"/>
			<inp2:m_RenderElement name="inp_edit_radio" prefix="z" field="Type" title="la_fld_Zone_Type"/>

			<inp2:m_if check="z_Field" field="Type" equals_to="1" db="db">
				<inp2:m_RenderElement name="countries_multiple" prefix="z" />
			</inp2:m_if>

			<inp2:m_if check="z_Field" field="Type" equals_to="2" db="db">
				<inp2:m_RenderElement name="states_multiple" prefix="z" />
			</inp2:m_if>

			<inp2:m_if check="z_Field" field="Type" equals_to="3" db="db">
				<inp2:m_RenderElement name="zips_multiple" prefix="z" />
			</inp2:m_if>

		<inp2:m_RenderElement name="inp_edit_filler"/>
	</table>
</div>

<input type="hidden" value="" name="location_id" id="location_id">
<input type="hidden" value="" name="selected_destinations" id="selected_destinations">
<input type="hidden" name="z_OriginalSaveEvent" id="z_OriginalSaveEvent" value="<inp2:z_SaveEvent/>">

<inp2:m_RenderElement name="inp_edit_hidden" prefix="z" field="ShippingTypeID"/>

<script>
	document.getElementById('z[<inp2:z_field field="ZoneID"/>][Type]_1').onchange = change_type;
	document.getElementById('z[<inp2:z_field field="ZoneID"/>][Type]_2').onchange = change_type;
	document.getElementById('z[<inp2:z_field field="ZoneID"/>][Type]_3').onchange = change_type;

	function change_type()
	{
		submit_event('z','OnTypeChange');
	}

	function change_country()
	{
		submit_event('z','OnCountryChange');
	}

	function remove_location(location_id)
	{
		document.getElementById('location_id').value = location_id;
		submit_event('z', 'OnRemoveLocation');
	}

	function SelectToString(aSelect)
	{
		// written by Slava, patched by Alex, modified by SergeyG
		var result = '';
		for (var i=0; i < aSelect.length; i++)
		{
			cur = aSelect.options[i];
			if(aSelect.options[i].selected == true) result += cur.value+',';
		}
		if(result.length > 0) result = result.substring(0,result.length-1);
		document.getElementById('selected_destinations').value = result;
		return result;
	}

	function add_zone(aSelect){
		var el = document.getElementById('zone_add');
		if (el)
		{
			if (el.value=='') return;
			var found = false;
			var valueArray;

			for (i = 0; i < aSelect.options.length; i++){
				valueArray = aSelect.options[i].value.split("|");
				if (valueArray[1] == el.value){
					found = true;
					break;
				}
			}
			if (!found){
				aSelect.options[aSelect.length] = new Option(el.value, '0|'+el.value);
				el.value='';
			}
		}
	}

function SelectContainsValue(selectObject, searchValue)
{
	for (i = 0; i < selectObject.options.length; i++){
		if (selectObject.options[i].text == searchValue){
			return true;
		}
	}
	return false;
}

function SelectToArray(aSelect)
{
	var an_arr = new Array();
	for (var i=0; i < aSelect.length; i++)
	{
		cur = aSelect.options[i];
		an_arr[an_arr.length] = new Array(cur.text, cur.value, cur.selected);
	}
	return an_arr;
}

function ArrayToSelect(anArray, aSelect)
{
	var initial_length = aSelect.length;
	for (var i=initial_length-1; i >= 0; i--) {	aSelect.options[i] = null; }

	for (var i=0; i < anArray.length; i++)
	{
		cur = anArray[i];
		aSelect.options[aSelect.length] = new Option(cur[0], cur[1]);
	}
}

function SelectCompare(a, b)
{
	if (a[0] < b[0])
		return -1;
	if (a[0] > b[0])
		return 1;
	return 0;
}

function MoveSelected(FromList, ToList)
{
	FromArr = SelectToArray(FromList);
	ToArr = SelectToArray(ToList);

	NewFrom = Array();

	for (var i=FromArr.length-1; i >= 0; i--)
	{
		cur = FromArr[i];
		if (cur[2] && !SelectContainsValue(ToList, cur[0])) {
			ToArr[ToArr.length] = cur;
		}
		else if(SelectContainsValue(ToList, cur[0])) {

		}
		else {
			NewFrom[NewFrom.length] = cur;
		}
	}

	NewFrom.sort(SelectCompare);
	ToArr.sort(SelectCompare);

	FromList = ArrayToSelect(NewFrom, FromList);
	ToList = ArrayToSelect(ToArr, ToList);
}

function SelectToString2(aSelect)
{
	var result = '';
	for (var i=0; i < aSelect.length; i++)
	{
		cur = aSelect.options[i];
		result += cur.value+',';
	}
	return result;
}


function SelectAll(aSelect)
{
	for (var i=0; i < aSelect.length; i++)
	{
		cur = aSelect.options[i];
		aSelect.options[i].selected = true;
	}
// -----------
}

function OnlySelectedToString(aSelect)
{
	var result = '';
	for (var i=0; i < aSelect.length; i++)
	{
		cur = aSelect.options[i];
		if (cur.selected)
			result += cur.value+',';
	}
	return result;
}

function SelectMultipleSelected(aSelect, aStr)
{
	for (var i=0; i < aSelect.length; i++)
	{
		cur = aSelect.options[i];
		if (aStr.match("(^|\,)+"+cur.value+"(,|$)+") ) {
			aSelect.options[i].selected = true;
			}
	}
}

function SelectAll(aSelect)
{
	for (var i=0; i < aSelect.length; i++)
	{
		cur = aSelect.options[i];
		aSelect.options[i].selected = true;
	}
}

// --------------

</SCRIPT>

<inp2:m_include t="incs/footer"/>