<?php
/**
* @version	$Id: shipping_quote_collector.php 13164 2010-02-24 14:13:28Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ShippingQuoteCollector extends ShippingQuoteEngine {

	function GetShippingQuotes($params)
	{
		if(!$params['dest_city'] || !$params['dest_country'] ||
				(($params['dest_country'] == 'US' || $params['dest_country'] == 'CA') && !$params['dest_state']) ||
				!$params['dest_postal'] || !$params['packages'])
		{
			return Array();
		}

		$db =& $this->Application->GetADODBConnection();

		$cached_var_name = 'ShippingQuotes'.crc32(serialize($params));

		$shipping_types = $this->Application->getDBCache($cached_var_name);

		if ($shipping_types) {
			return unserialize($shipping_types);
		}

		$sql = 'SELECT Classname FROM '.$this->Application->getUnitOption('sqe', 'TableName').' WHERE Status = 1';
		$classes = $db->GetCol($sql);
		$classes[] = 'CustomShippingQuoteEngine'; // always persists
		$shipping_types = Array();
		foreach($classes as $class)
		{
			$object =& $this->Application->recallObject($class);
			$new_shipping_types = $object->GetShippingQuotes($params);
			$shipping_types = array_merge($shipping_types, $new_shipping_types);
		}
		uasort($shipping_types, Array(&$this, 'price_sort'));

		//exclude not available shipping quotes by products
		$limit_types = unserialize($params['limit_types']);
		if (is_array($limit_types) && !in_array('ANY', $limit_types)) {
			if (count($limit_types) == 0) break;
			$available_types = array();
			foreach ($shipping_types as $a_type)
			{
				$include = false; //exclude by default
				foreach ($limit_types as $limit)
				{
					$include = $include || preg_match("/^$limit/", $a_type['ShippingId']);
					if ($include) break;
				}
				if (!$include) continue;
				$available_types[$a_type['ShippingId']] = $a_type;
			}
			$shipping_types = $available_types;
		}

		//exclude Selected Products Only shipping types, not matching products
		$available_types = array();
		foreach ($shipping_types as $a_type) {
			if (getArrayValue($a_type, 'SelectedOnly')) {
				if (!is_array($limit_types) || !in_array($a_type['ShippingId'], $limit_types)) continue;
			}
			$available_types[$a_type['ShippingId']] = $a_type;
		}
		$shipping_types = $available_types;

		$this->Application->setDBCache($cached_var_name, serialize($shipping_types), 24 * 3600);

		return $shipping_types;
	}

	function GetAvailableShippingTypes()
	{
		$db =& $this->Application->GetADODBConnection();
		$sql = 'SELECT Classname FROM '.$this->Application->getUnitOption('sqe', 'TableName').' WHERE Status = 1';
		$classes = $db->GetCol($sql);
		$classes[] = 'CustomShippingQuoteEngine'; // always persists
		$shipping_types = Array();
		foreach($classes as $class)
		{
			$object =& $this->Application->recallObject($class);
			$new_shipping_types = $object->GetAvailableTypes();
			$shipping_types = array_merge($shipping_types, $new_shipping_types);
		}
		uasort($shipping_types, Array(&$this, 'SortShippingTypes'));

		return $shipping_types;
	}

	function SortShippingTypes($elem1, $elem2)
	{
		if($elem1['_Name'] < $elem2['_Name'])
		{
			return -1;
		}
		elseif($elem1['_Name'] > $elem2['_Name'])
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	function price_sort($elem1, $elem2)
	{
		if($elem1['TotalCost'] < $elem2['TotalCost'])
		{
			return -1;
		}
		elseif($elem1['TotalCost'] > $elem2['TotalCost'])
		{
			return 1;
		}
		else
		{
			return 0;
		}

	}
}