<?php
/**
* @version	$Id: authorizenet.php 13578 2010-05-19 07:25:51Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	require_once GW_CLASS_PATH.'/gw_base.php';

	class kGWAuthorizeNet extends kGWBase
	{
		function DirectPayment($item_data, $gw_params)
		{
			$post_fields = Array();
			// -- Login Information --
			$post_fields['x_version']			=	'3.1';
			$post_fields['x_delim_data']		=	'True';
			$post_fields['x_encap_char']		=	$gw_params['encapsulate_char'];
			$post_fields['x_relay_response']	=	'False';
			$post_fields['x_type']				=	$gw_params['shipping_control'] == SHIPPING_CONTROL_PREAUTH ? 'AUTH_ONLY' : 'AUTH_CAPTURE';
			$post_fields['x_login']				=	$gw_params['user_account'];
			$post_fields['x_tran_key']			=	$gw_params['transaction_key'];

			if( $this->IsTestMode() ) $post_fields['x_test_request'] = 'True';

			// -- Payment Details --
			$names = explode(' ', $item_data['PaymentNameOnCard'], 2);
			$post_fields['x_first_name']		=	getArrayValue($names, 0);
			$post_fields['x_last_name']			=	getArrayValue($names, 1);
			$post_fields['x_amount']			=	sprintf('%.2f', $item_data['TotalAmount']);
			$post_fields['x_company']			=	$item_data['BillingCompany'];
			$post_fields['x_card_num']			=	$item_data['PaymentAccount'];
			$post_fields['x_card_code']			=	$item_data['PaymentCVV2'];
			$post_fields['x_exp_date']			=	$item_data['PaymentCCExpDate'];
			$post_fields['x_address']			=	$item_data['BillingAddress1'].' '.$item_data['BillingAddress2'];
			$post_fields['x_city']				=	$item_data['BillingCity'];
			$post_fields['x_state']				=	$item_data['BillingState'];
			$post_fields['x_zip']				=	$item_data['BillingZip'];

			$recurring = getArrayValue($item_data, 'IsRecurringBilling') ? 'YES' : 'NO';
			$post_fields['x_recurring_billing'] = $recurring;

			$billing_email = $item_data['BillingEmail'];
			if (!$billing_email) {
				$billing_email = $this->Conn->GetOne('	SELECT Email FROM '.$this->Application->getUnitOption('u', 'TableName').'
											WHERE PortalUserId = '.$this->Application->RecallVar('user_id'));
			}
			$post_fields['x_email'] = $billing_email;
			$post_fields['x_phone'] = $item_data['BillingPhone'];

			$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
			/* @var $cs_helper kCountryStatesHelper */

			$post_fields['x_country']			=	$cs_helper->getCountryIso( $item_data['BillingCountry'] );
			$post_fields['x_cust_id']			=	$item_data['PortalUserId'];
			$post_fields['x_invoice_num']		=	$item_data['OrderNumber'];
			$post_fields['x_description']		=	'Invoice #'.$item_data['OrderNumber'];
			$post_fields['x_email_customer']	=	'FALSE';

			$this->gw_responce = curl_post($gw_params['submit_url'], $post_fields);
			$gw_responce = $this->parseGWResponce(null, $gw_params);

			// gw_error_msg: $gw_response['responce_reason_text']
			// gw_error_code: $gw_response['responce_reason_code']
			return (is_numeric($gw_responce['responce_code']) && $gw_responce['responce_code'] == 1) ? true : false;
		}

		/**
		 * Perform SALE type transaction direct from php script wihtout redirecting to 3rd-party website
		 *
		 * @param Array $item_data
		 * @param Array $gw_params
		 * @return bool
		 */
		function Charge($item_data, $gw_params)
		{
			$gw_responce = unserialize( $item_data['GWResult1'] );

			if( ($item_data['PortalUserId'] != $gw_responce['customer_id']) && ($gw_repsponce['customer_id'] != USER_GUEST && !$this->Application->isAdmin)) return false;

			if( ( strtolower($gw_responce['transaction_type']) == 'auth_only') )
			{
				$post_fields = Array();
				// -- Login Information --
				$post_fields['x_version']			=	'3.1';
				$post_fields['x_delim_data']		=	'True';
				$post_fields['x_encap_char']		=	$gw_params['encapsulate_char'];
				$post_fields['x_relay_response']	=	'False';
				$post_fields['x_type']				=	'PRIOR_AUTH_CAPTURE'; // $gw_params['shipping_control'] == SHIPPING_CONTROL_PREAUTH ? 'PRIOR_AUTH_CAPTURE' : 'AUTH_CAPTURE'; // AUTH_CAPTURE not fully impletemnted/needed here
				$post_fields['x_login']				=	$gw_params['user_account'];
				$post_fields['x_tran_key']			=	$gw_params['transaction_key'];
				$post_fields['x_trans_id']			=	$gw_responce['transaction_id'];

				if( $this->IsTestMode() ) $post_fields['x_test_request'] = 'True';

				$this->gw_responce = curl_post($gw_params['submit_url'], $post_fields);
				$gw_responce = $this->parseGWResponce(null, $gw_params);

				// gw_error_msg: $gw_response['responce_reason_text']
				// gw_error_code: $gw_response['responce_reason_code']
				return (is_numeric($gw_responce['responce_code']) && $gw_responce['responce_code'] == 1) || $this->IsTestMode() ? true : false;
			}
			else
			{
				return true;
			}
		}

		/**
		 * Parse previosly saved gw responce into associative array
		 *
		 * @param string $gw_responce
		 * @param Array $gw_params
		 * @return Array
		 */
		function parseGWResponce($gw_responce = null, $gw_params)
		{
			if( !isset($gw_responce) ) $gw_responce = $this->gw_responce;

			if ($this->Application->isDebugMode()) {
				$this->Application->Debugger->appendHTML('Curl Error #'.$GLOBALS['curl_errorno'].'; Error Message: '.$GLOBALS['curl_error']);

				$this->Application->Debugger->appendHTML('Authorize.Net Responce:');
				$this->Application->Debugger->dumpVars($gw_responce);
			}

			$fields = Array('responce_code','responce_sub_code','responce_reason_code','responce_reason_text',
							'approval_code','avs_result_code','transaction_id','invoice_number','description',
							'amount','method','transaction_type','customer_id','first_name','last_name','company',
							'address','city','state','zip','country','phone','fax','email');

			$encapsulate_char = $gw_params['encapsulate_char'];
			if($encapsulate_char)
			{
				$ec_length = strlen($encapsulate_char);
				$gw_responce = substr($gw_responce, $ec_length, $ec_length * -1);
			}

			$gw_responce = explode($encapsulate_char.','.$encapsulate_char, $gw_responce);
			$ret = Array();
			foreach($fields as $field_index => $field_name)
			{
				$ret[$field_name] = $gw_responce[$field_index];
				unset($gw_responce[$field_index]);
			}
			$this->parsed_responce = $ret;
			return array_merge_recursive2($ret, $gw_responce); // returns unparsed fields with they original indexes together with parsed ones
		}

		function getGWResponce()
		{
			return serialize($this->parsed_responce);
		}

		function getErrorMsg()
		{
			return $this->parsed_responce['responce_reason_text'];
		}

		function GetTestCCNumbers()
		{
			return array('370000000000002', '6011000000000012', '5424000000000015', '4007000000027', '4222222222222');
		}
	}