<?php
/**
* @version	$Id: addresses_config.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'addr',
					'ItemClass'			=>	Array('class'=>'AddressesItem','file'=>'addresses_item.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'AddressesList','file'=>'addresses_list.php','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class' => 'AddressesEventHandler', 'file' => 'addresses_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array('class' => 'AddressesTagProcessor', 'file' => 'addresses_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,

					'Hooks'				=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => '',
													'HookToSpecial' => '*',
													'HookToEvent' => Array('OnAfterItemLoad', 'OnBeforeItemCreate', 'OnBeforeItemUpdate'),
													'DoPrefix' => '',
													'DoSpecial' => '*',
													'DoEvent' => 'OnPrepareStates',
												),

												// create/update profile addres (in addresses table)
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => '#PARENT#',
													'HookToSpecial' => '*',
													'HookToEvent' => Array('OnAfterItemCreate', 'OnAfterItemUpdate'),
													'DoPrefix' => '',
													'DoSpecial' => '*',
													'DoEvent' => 'OnUpdateUserProfile',
												),

												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => '',
													'HookToSpecial' => '*',
													'HookToEvent' => Array('OnAfterItemCreate', 'OnAfterItemUpdate'),
													'DoPrefix' => '',
													'DoSpecial' => '*',
													'DoEvent' => 'OnUpdateProfileAddress',
												),
											),

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'event',
												4 	=>	'mode',
											),
					'IDField'			=>	'AddressId',

					'TableName'			=>	TABLE_PREFIX.'Addresses',

					'ParentTableKey'=>	'PortalUserId',	// linked field in master table
					'ForeignKey'	=>	'PortalUserId',	// linked field in subtable
					'ParentPrefix' 	=>	'u',
					'AutoDelete'	=>	true,
					'AutoClone'		=>	true,

					'CalculatedFields'	=>	Array(
													''	=>	Array(
																	'ShortAddress'	=>	'CONCAT( TRIM(CONCAT(Address1," ",Address2)),", ",City," ...")',
															),
											),

					'ListSQLs'			=>	Array(''	=>	'SELECT %1$s.* %2$s FROM %1$s'), // key - special, value - list select sql

					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s'),

					'ListSortings'	=> 	Array(''	=>	Array('Sorting' => Array('IsProfileAddress' => 'desc')) ),

					'Fields'			=>	Array(
													'AddressId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
													'PortalUserId' => Array('type' => 'int','not_null' => 1, 'default' => 0),
													'To' => Array('type' => 'string','not_null' => '1', 'required' => 1, 'default' => ''),
													'Company' => Array('type' => 'string','not_null' => '1','default' => ''),
													'Phone' => Array('type' => 'string','not_null' => '1', 'required' => 1, 'default' => ''),
													'Fax' => Array('type' => 'string','not_null' => '1','default' => ''),
													'Email' => Array('type' => 'string','formatter'=>'kFormatter', 'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i','not_null' => '1','default' => ''),
													'Address1' => Array('type' => 'string','not_null' => '1', 'required' => 1, 'default' => ''),
													'Address2' => Array('type' => 'string','not_null' => '1','default' => ''),
													'City' => Array('type' => 'string','not_null' => '1', 'required' => 1, 'default' => ''),
													'State'	=>	Array('type' => 'string', 'formatter' => 'kOptionsFormatter',
							            								'options' => Array(),
												            			'option_key_field'=>'DestAbbr', 'option_title_field'=>'Translation',
												            			'not_null' => '1', 'default' => ''),

													'Zip' => Array('type' => 'string','not_null' => '1', 'required' => 1, 'default' => ''),
													'Country'	=>	Array('type' => 'string', 'formatter'		=>	'kOptionsFormatter',
							            									'options_sql'	=>	'	SELECT %1$s
																									FROM '.TABLE_PREFIX.'StdDestinations
																									LEFT JOIN '.TABLE_PREFIX.'Phrase
																										ON '.TABLE_PREFIX.'Phrase.Phrase = '.TABLE_PREFIX.'StdDestinations.DestName
																									WHERE
																									DestType = 1 AND LanguageId = %2$s
																									ORDER BY Translation',
												            				'option_key_field' => 'DestAbbr', 'option_title_field' => 'Translation',
												            				'not_null' => '1', 'required' => 1, 'default' => ''),

													'LastUsedAsBilling' => Array('type' => 'int','not_null' => 1, 'default' => 0),
            										'LastUsedAsShipping' => Array('type' => 'int','not_null' => 1, 'default' => 0),
            										'IsProfileAddress' => Array('type' => 'int','not_null' => 1, 'default' => 0),
											),

					'VirtualFields'	=> 	Array(
												'ShortAddress' => Array('type'=>'string'),
										),

					'Grids'	=> Array(),

	);