<inp2:adm_SetPopupSize width="1000" height="680"/>

<inp2:m_include t="incs/header"/>

<inp2:m_if check="p_Field" name="InventoryStatus" equals_to="2" db="db">
	  <inp2:m_RenderElement name="combined_header" prefix="p" section="in-portal:browse" pagination="1" pagination_prefix="poc.grid" grid="Inventory" title_preset="inventory" tab_preset="Default"/>
<inp2:m_else/>
	<inp2:m_RenderElement name="combined_header" prefix="p" section="in-portal:browse" title_preset="inventory" tab_preset="Default"/>
</inp2:m_if>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
<tbody>
	<tr>
  	<td>
  		<script type="text/javascript">
				a_toolbar = new ToolBar();

				function edit() {

				}

				a_toolbar.AddButton( new ToolBarButton('select', '<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>', function() {
							submit_event('p','<inp2:p_SaveEvent/>');
						}
					) );
				a_toolbar.AddButton( new ToolBarButton('cancel', '<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>', function() {
							submit_event('p','OnCancelEdit');
						}
				 ) );

				a_toolbar.AddButton( new ToolBarSeparator('sep1') );

				a_toolbar.AddButton( new ToolBarButton('prev', '<inp2:m_phrase label="la_ToolTip_Prev" escape="1"/>', function() {
							go_to_id('p', '<inp2:p_PrevId/>');
						}
				 ) );
				a_toolbar.AddButton( new ToolBarButton('next', '<inp2:m_phrase label="la_ToolTip_Next" escape="1"/>', function() {
							go_to_id('p', '<inp2:p_NextId/>');
						}
				 ) );

				 <inp2:m_if check="p_Field" name="InventoryStatus" equals_to="2" db="db">
					  a_toolbar.AddButton( new ToolBarSeparator('sep4') );

						a_toolbar.AddButton( new ToolBarButton('view', '<inp2:m_phrase label="la_ToolTip_View" escape="1"/>', function() {
									show_viewmenu(a_toolbar,'view');
								}
						) );
				</inp2:m_if>

				a_toolbar.Render();

				<inp2:m_if check="p_IsSingle" >
					a_toolbar.HideButton('prev');
					a_toolbar.HideButton('next');
					a_toolbar.HideButton('sep1');
				<inp2:m_else/>
					<inp2:m_if check="p_IsLast" >
						a_toolbar.DisableButton('next');
					</inp2:m_if>
					<inp2:m_if check="p_IsFirst" >
						a_toolbar.DisableButton('prev');
					</inp2:m_if>
				</inp2:m_if>
			</script>
		</td>

		<inp2:m_if check="p_Field" name="InventoryStatus" equals_to="2" db="db">
			  <inp2:m_RenderElement name="search_main_toolbar" prefix="poc.grid" grid="Inventory"/>
		</inp2:m_if>
	</tr>
</tbody>
</table>

<!-- block definitions: begin -->
<inp2:m_DefineElement name="inp_edit_inventory">
	<tr class="<inp2:m_odd_even odd='edit-form-odd' even='edit-form-even'/>">
		<inp2:m_RenderElement name="inp_edit_field_caption" prefix="$prefix" field="$field" title="$title"/>
		<td class="control-cell">
			<input type="text" name="<inp2:{$prefix}_InputName field="$field"/>" id="<inp2:{$prefix}_InputName field="$field"/>" value="<inp2:{$prefix}_Field field="$field"/>" tabindex="<inp2:m_get param="tab_index"/>" size="<inp2:m_param name="size"/>" />&nbsp;
			<input type="button" class="button" id="Add" value="<inp2:m_phrase label="la_btn_Add"/>" onclick="processButton('p', 'OnQtyAdd')">&nbsp;
			<input type="button" class="button" id="Remove" value="<inp2:m_phrase label="la_btn_Remove"/>" onclick="processButton('p', 'OnQtyRemove')">&nbsp;
			<input type="button" class="button" id="Order" value="<inp2:m_phrase label="la_btn_Order"/>" onclick="processButton('p', 'OnQtyOrder')">&nbsp;
			<input type="button" class="button" id="ReceiveOrder" value="<inp2:m_phrase label="la_btn_ReceiveOrder"/>" onclick="processButton('p', 'OnQtyReceiveOrder')">&nbsp;
			<input type="button" class="button" id="CancelOrder" value="<inp2:m_phrase label="la_btn_CancelOrder"/>" onclick="processButton('p', 'OnQtyCancelOrder')">&nbsp;
		</td>
		<inp2:m_RenderElement name="inp_edit_error" pass_params="1"/>
	</tr>
</inp2:m_DefineElement>
<!-- block definitions: end -->

<inp2:m_ifnot check="p_Field" name="InventoryStatus" equals_to="2" db="db">
	<inp2:p_SaveWarning name="grid_save_warning"/>
</inp2:m_ifnot>

<inp2:p_ErrorWarning name="form_error_warning"/>

<div id="scroll_container"<inp2:m_if check="p_Field" name="InventoryStatus" equals_to="2" db="db"> style="height: 142px;"</inp2:m_if>>
	<table class="edit-form"<inp2:m_if check="p_Field" name="InventoryStatus" equals_to="2" db="db"> style="border-bottom: 1px solid black;"</inp2:m_if>>
		<inp2:m_RenderElement name="subsection" title="!la_section_Product!"/>
			<inp2:m_RenderElement name="inp_edit_radio" prefix="p" field="InventoryStatus" title="la_fld_InventoryStatus" onchange="change_inventory_status()"/>

			<inp2:m_ifnot check="p_Field" name="InventoryStatus" db="db" equals_to="2">
				<!-- inventory by product / inventory disabled -->
				<inp2:m_RenderElement name="inp_label" prefix="p" field="QtyInStock" title="!la_fld_QtyInStock!"/>
				<inp2:m_RenderElement name="inp_label" prefix="p" field="QtyReserved" title="!la_fld_QtyReserved!"/>
				<inp2:m_RenderElement name="inp_label" prefix="p" field="QtyBackOrdered" title="!la_fld_QtyBackOrdered!"/>
				<inp2:m_RenderElement name="inp_label" prefix="p" field="QtyOnOrder" title="!la_fld_QtyOnOrder!"/>
			</inp2:m_ifnot>

			<inp2:m_RenderElement name="inp_edit_inventory" prefix="p" field="Qty" title="!la_fld_Qty!" size="3"/>
			<inp2:m_RenderElement name="inp_edit_textarea" prefix="p" field="InventoryComment" title="!la_fld_Comment!" cols="40" rows="3"/>
		<inp2:m_RenderElement name="inp_edit_filler"/>
	</table>
</div>

<inp2:m_if check="p_Field" name="InventoryStatus" equals_to="2" db="db">
	<!-- inventory by product options -->
	<inp2:m_DefineElement name="grid_combination_td">
		<inp2:Field field="$field" grid="$grid" no_special="1"/>
		<inp2:m_ifnot check="Field" field="Priority" equals_to="0"><span class="priority"><sup><inp2:Field field="Priority" /></sup></span></inp2:m_ifnot>
	</inp2:m_DefineElement>

	<inp2:m_RenderElement name="grid" main_special="" PrefixSpecial="poc.grid" IdField="CombinationId" grid="Inventory"/>
</inp2:m_if>

<script type="text/javascript">
	var $inventory_status = <inp2:p_Field name="InventoryStatus" db="db"/>;
	function getInventoryStatus() {
		var $i = 0;
		var $status_id = '<inp2:p_InputName field="InventoryStatus"/>';

		while ($i <= 2) {
			if (document.getElementById($status_id + '_' + $i).checked) {
				return $i;
			}
			$i++;
		}

		return 0;
	}

	function change_inventory_status()
	{
		var $new_inventory_status = getInventoryStatus();
		if (confirm('<inp2:m_phrase label="la_warning_ChangeInventoryStatus" />')) {
			$inventory_status = $new_inventory_status;
			affect_dependent_elements();
			go_to_tab('p', t);
		}
		else {
			var $status_id = '<inp2:p_InputName field="InventoryStatus"/>';
			document.getElementById($status_id + '_' + $new_inventory_status).checked = false;
			document.getElementById($status_id + '_' + $inventory_status).checked = true;
			document.getElementById($status_id + '_' + $inventory_status).focus();
		}
	}

	function iterateButtons($disabled, $class_name) {
		var $i = 0;
		var $buttons = Array('Add', 'Remove', 'Order', 'ReceiveOrder', 'CancelOrder');

		while ($i < $buttons.length) {
			document.getElementById($buttons[$i]).disabled = $disabled;
			document.getElementById($buttons[$i]).className = $class_name;
			$i++;
		}
	}

	function processButton($prefix, $event) {
		if ($inventory_status == 2) {
			if (Grids['poc.grid'].GetSelected().length == 0) {
				alert('<inp2:m_phrase name="la_warning_SelectOptionCombination" escape="1"/>')
			}
			else {
				// go next if option combination is selected
				submit_event($prefix, $event);
			}
		}
		else {
			// go next if not using option combination inventory
			submit_event($prefix, $event);
		}
	}

	function affect_dependent_elements()
	{
		var $inventory_disabled = document.getElementById('<inp2:p_InputName field="InventoryStatus"/>_0').checked;

		iterateButtons($inventory_disabled, $inventory_disabled ? 'button-disabled' : 'button');
		document.getElementById('<inp2:p_InputName field="Qty"/>').disabled = $inventory_disabled;
		document.getElementById('<inp2:p_InputName field="InventoryComment"/>').disabled = $inventory_disabled;

		document.getElementById('<inp2:p_InputName field="InventoryStatus"/>_2').disabled = <inp2:poc.grid_TotalRecords/> > 0 ? false : true;
	}

	affect_dependent_elements();
</script>

<inp2:m_include t="incs/footer"/>