<?php
/**
* @version	$Id: affiliate_plans_config.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'ap',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'AffiliatePlansEventHandler','file'=>'affiliate_plans_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'kDBTagProcessor','file'=>'','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'AggregateTags' => Array(
													),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'event',
												4 	=>	'mode',
											),

					'IDField'			=>	'AffiliatePlanId',
					'StatusField'		=>	Array('Enabled', 'IsPrimary'),	// field, that is affected by Approve/Decline events

					'TitleField'		=>	'Name',
					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('ap'=>'!la_title_Adding_Affiliate_Plan!'),
																		'edit_status_labels'	=> Array('ap'=>'!la_title_Editing_Affiliate_Plan!'),
																		'new_titlefield'		=> Array('ap'=>'!la_title_New_Affiliate_Plan!'),
																),

												'affiliate_plans_list'	=>	Array('prefixes' => Array('ap_List'), 'format' => "!la_title_AffiliatePlans!"),
												'affiliate_plans_edit' => Array('prefixes' => Array('ap'), 'format' => "#ap_status# '#ap_titlefield#' - !la_title_General!"),
												'affiliate_plans_brackets'	=>	Array('prefixes' => Array('ap','apbrackets_List'), 'format' => "#ap_status# '#ap_titlefield#' - !la_title_AffiliatePlansBrackets!"),
												'affiliate_plans_items'	=>	Array('prefixes' => Array('ap','api_List'), 'format' => "#ap_status# '#ap_titlefield#' - !la_title_AffiliatePlansBrackets!"),

											),

					'EditTabPresets' => Array (
   						'Default' => Array (
   							'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/affiliate_plans/affiliate_plans_edit', 'priority' => 1),
							'brackets' => Array ('title' => 'la_tab_Brackets', 't' => 'in-commerce/affiliate_plans/affiliate_plans_brackets', 'priority' => 2),
//							'items' => Array ('title' => 'la_tab_Items', 't' => 'in-commerce/affiliate_plans/affiliate_plans_items', 'priority' => 3),
   						),
   					),

					'PermSection'		=>	Array('main' => 'in-commerce:affiliate_plans'),

					'Sections'			=>	Array(
													'in-commerce:affiliate_plans'	=>	Array(
																								'parent'		=>	'in-commerce:affiliates_folder',
																								'icon'			=>	'affiliates',
																								'label'			=>	'la_tab_AffiliatePlans',
																								'url'			=>	Array('t' => 'in-commerce/affiliate_plans/affiliate_plans_list', 'pass' => 'm'),
																								'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline', 'advanced:set_primary'),
																								'priority'		=>	5.2, // <parent_priority>.<own_priority>, because this section replaces parent in tree
																								'type'			=>	stTAB,
																						),
											),

					'TableName'			=>	TABLE_PREFIX.'AffiliatePlans',

					'ListSQLs'			=>	Array('' => 'SELECT * FROM %s'),
					'ItemSQLs'			=>	Array('' => 'SELECT * FROM %s'),

					'SubItems'	=> Array('apbrackets', /*'api'*/),
					'ListSortings'	=> 	Array(
												'' => Array(
															'ForcedSorting' => Array('IsPrimary' => 'desc'),
															'Sorting' => Array('Name' => 'desc'),
														)
										),

					'Fields' => Array(
							            'AffiliatePlanId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
							            'Name' => Array('type' => 'string', 'unique' => Array(), 'not_null' => '1', 'required' => 1, 'default' => ''),
							            'PlanType' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(/*0 => 'la_by_amount',*/ 1 => 'la_by_amount', 2 => 'la_by_items_sold'), 'use_phrases' => 1, 'required' => 1, 'not_null' => 1, 'default' => 1),
							            'ResetInterval' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(86400 => 'la_day', 604800 => 'la_week', 2628000 => 'la_month', 7884000 => 'la_quartely', 31536000 => 'la_year'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
							            'PaymentType' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(0 => 'la_regular', 1 => 'la_by_request'), 'use_phrases' => 1, 'not_null' => 1,'default' => 0),
							            'MinPaymentAmount' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'Enabled' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(0 => 'la_Disabled', 1 => 'la_Enabled'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
							            'IsPrimary' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
								),

					'Grids'	=> Array(
								'Default'		=>	Array(
									'Icons' => Array (
										'default' => 'icon16_item.png',
										'0_0' => 'icon16_disabled.png',
										'0_1' => 'icon16_disabled.png',
										'1_0' => 'icon16_item.png',
										'1_1' => 'icon16_primary.png',
										'module' => 'core',
									),
									'Fields' => Array(
										'AffiliatePlanId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
										'Name' 			=> Array( 'title'=>'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
										'PlanType'		=> Array( 'title' => 'la_col_PlanType', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
										'Enabled'		=> Array( 'title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
									),
								),

							),
	);