<?php
/**
* @version	$Id: affiliates_config.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'affil',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'AffiliatesEventHandler','file'=>'affiliates_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'AffiliatesTagProcessor','file'=>'affiliates_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'Hooks'	=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'u',
													'HookToSpecial' => '',
													'HookToEvent' => Array('OnCreate'),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnRegisterAsAffiliate',
												),
												Array(
													'Mode' => hBEFORE,
													'Conditional' => false,
													'HookToPrefix' => 'u',
													'HookToSpecial' => '',
													'HookToEvent' => Array('OnCreate'),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnCheckAffiliateAgreement',
												),
											),
					'AggregateTags' => Array(
												Array(
													'AggregateTo' => 'u',
													'AggregatedTagName' => 'IsAffiliate',
													'LocalTagName' => 'User_IsAffiliate',
												),
												Array(
													'AggregateTo' => 'u',
													'AggregatedTagName' => 'AffiliateIsNotActive',
													'LocalTagName' => 'User_AffiliateIsNotActive',
												),
												Array(
													'AggregateTo' => 'u',
													'AggregatedTagName' => 'AffiliateField',
													'LocalTagName' => 'CurrentUserAffiliateField',
												),
												Array(
													'AggregateTo' => 'u',
													'AggregatedTagName' => 'IsAffiliateOrRegisterAsAffiliateAllowed',
													'LocalTagName' => 'IsAffiliateOrRegisterAsAffiliateAllowed',
												),
												Array(
													'AggregateTo' => 'm',
													'AggregatedTagName' => 'RequireAffiliate',
													'LocalTagName' => 'Main_RequireAffiliate',
												),

												Array(
													'AggregateTo' => 'm',
													'AggregatedTagName' => 'AllowAffiliateRegistration',
													'LocalTagName' => 'AllowAffiliateRegistration',
												),
										),

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'event',
												4 	=>	'mode',
											),

					'RegularEvents'		=>	Array(
													'store_affiliate' => Array('EventName' => 'OnStoreAffiliate', 'RunInterval' => 0, 'Type' => reBEFORE),
													'reset_affiliate_stats' => Array('EventName' => 'OnResetStatistics', 'RunInterval' => 0, 'Type' => reBEFORE),
											),

					'IDField'			=>	'AffiliateId',
					'StatusField'		=>	Array('Status'),	// field, that is affected by Approve/Decline events

					'TitleField'		=>	'UserName',
					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('affil'=>'!la_title_Adding_Affiliate!'),
																		'edit_status_labels'	=> Array('affil'=>'!la_title_Editing_Affiliate!'),
																		'new_titlefield'		=> Array('affil'=>'!la_title_New_Affiliate!'),
																),

												'affiliates_list'	=>	Array('prefixes' => Array('affil_List'), 'format' => "!la_title_Affiliates!"),
												'affiliates_edit' => Array('prefixes' => Array('affil'), 'format' => "#affil_status# '#affil_titlefield#' - !la_title_General!"),
												'affiliate_payments' => Array('prefixes' => Array('affil', 'apayments_List'), 'format' => "#affil_status# '#affil_titlefield#' - !la_title_Payments!"),
												'affiliates_payout' => Array('prefixes' => Array('affil','apayments'), 'format' => "!la_title_PayOut_To! '#affil_titlefield#'"),
											),

					'EditTabPresets' => Array (
   						'Default' => Array (
   							'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/affiliate_plans/affiliates_edit', 'priority' => 1),
							'payments' => Array ('title' => 'la_tab_Payments', 't' => 'in-commerce/affiliate_plans/affiliate_edit_payments', 'priority' => 2),
   						),
   					),

					'PermSection'		=>	Array('main' => 'in-commerce:affiliates'),

					'Sections'			=>	Array(
						'in-commerce:affiliates_folder'	=>	Array(
							'parent'		=>	'in-commerce',
							'icon'			=>	'affiliates',
							'label'			=>	'la_tab_Affiliates',
							'use_parent_header' => 1,
							'permissions'	=>	Array(),
							'priority'		=>	5,
							'type'			=>	stTREE,
						),

						'in-commerce:affiliates'	=>	Array(
							'parent'		=>	'in-commerce:affiliates_folder',
							'icon'			=>	'affiliates',
							'label'			=>	'la_tab_Affiliates',
							'url'			=>	Array('t' => 'in-commerce/affiliate_plans/affiliates_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
							'priority'		=>	5.1, // <parent_priority>.<own_priority>, because this section replaces parent in tree
							'type'			=>	stTAB,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'Affiliates',

					'CalculatedFields' => Array(
								'' => Array (
										'UserId' => 'u.PortalUserId',
										'UserName' => 'IF( LENGTH(u.Login), u.Login, \'\')',
										'PlanName' => 'ap.Name',
									),
								),

					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'AffiliatePlans ap ON %1$s.AffiliatePlanId = ap.AffiliatePlanId'),

					'ItemSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'AffiliatePlans ap ON %1$s.AffiliatePlanId = ap.AffiliatePlanId'),
					'SubItems'	=> Array('apayments'),

					'ListSortings'	=> 	Array(
												'' => Array(
															'Sorting' => Array('CreatedOn' => 'desc', 'UserName' => 'asc'),
														)
										),

					'Fields' => Array(
										'AffiliateId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										'PortalUserId' => Array('type' => 'int',  'unique'=>Array('PortalUserId'), 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!', 'unique' => '!la_affiliate_already_exists!'), 'options' => Array(-1 => 'root', -2 => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'required' => 1, 'not_null' => 1, 'default' => 0, ),
										'AffiliatePlanId' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options_sql'=>'SELECT Name, AffiliatePlanId FROM '.TABLE_PREFIX.'AffiliatePlans WHERE Enabled = 1 ORDER BY Name', 'option_key_field'=>'AffiliatePlanId', 'option_title_field'=>'Name', 'not_null' => 1, 'default' => 0),
										'AccumulatedAmount' => Array('type' => 'double', 'formatter'=>'kFormatter', 'format'=>'%.02f', 'not_null' => '1','default' => '0.00'),
										'AmountToPay' => Array('type' => 'double', 'formatter'=>'kFormatter', 'format'=>'%.02f', 'not_null' => '1','default' => '0.00'),
										'LastPaymentDate' => Array('type' => 'int', 'formatter'=>'kDateFormatter', 'default' => NULL),
										'LastOrderDate' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
										'Status' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options'=>Array(1=>'la_Active', 2=>'la_Pending', 0=>'la_Disabled'), 'use_phrases'=>1, 'not_null' => '1','default' => 2),
										'AffiliateCode' => Array('type' => 'string', 'not_null' => '1', 'default' => ''),
										'ItemsSold' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										'PaymentTypeId' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options' => Array(0 => ''), 'options_sql'=>'SELECT Name, PaymentTypeId FROM '.TABLE_PREFIX.'AffiliatePaymentTypes WHERE Status = 1 ORDER BY IsPrimary DESC, Priority DESC, Name ASC', 'option_key_field'=>'PaymentTypeId', 'option_title_field'=>'Name', 'not_null' => 1, 'default' => 0),
										'SSN' => Array('type' => 'string','not_null' => '1','default' => '', 'required' => 1),
										'Comments' => Array('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),
										'CreatedOn' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
								),
					'VirtualFields'	=> 	Array(
												'UserName' => Array('type'=>'string', 'default' => ''),
												'PlanName' => Array('type'=>'string', 'default' => ''),
											),

					'Grids'	=> Array(
						'Default' => Array(
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								2 => 'icon16_primary.png',
								'module' => 'core',
							),
							'Fields' => Array(
																				'AffiliateId'		=> Array( 'title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
																				'UserName'			=> Array( 'title' => 'la_col_UserName', 'data_block' => 'grid_userlink_td', 'filter_block' => 'grid_like_filter'),
																				'PlanName' 			=> Array( 'title'=>'la_col_PlanName', 'filter_block' => 'grid_like_filter'),

																				'PaymentTypeId'		=> Array( 'title' => 'la_col_PaymentType', 'filter_block' => 'grid_options_filter', 'width' => 120, ),
																				'CreatedOn'			=> Array( 'title' => 'la_col_RegisteredOn', 'format' => '_regional_DateFormat', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
																				'Status'			=> Array( 'title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
																		),
													),

								),
	);