<?php
/**
* @version	$Id: gw_notify.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	define('FULL_PATH', realpath(dirname(__FILE__).'/..'));
	define('REL_PATH', 'in-commerce');
	include_once(FULL_PATH.'/core/kernel/startup.php');

	$application =& kApplication::Instance();
	$application->Init();

	/*$fh = fopen(FULL_PATH.'/gw.log', 'a');
	fwrite ($fh, "\n\n".date('d/m/y h:i:s').":\n");
	foreach ($_REQUEST as $key => $val)
	{
		fwrite($fh, "<input type=\"text\" name=\"$key\" value=\"$val\">\n");
	}
	fclose($fh);*/

	$db =& $application->GetADODBConnection();

	$application->setUnitOption('ord','AutoLoad',false);
	$order =& $application->recallObject('ord');

	$order_id = $application->GetVar('order_id');
	if ($order_id) {
		$order->Load($order_id);
	}

	$gw_data = $order->getGatewayData($application->GetVar('payment_type_id'));
	$application->registerClass( $gw_data['ClassName'], GW_CLASS_PATH.'/'.$gw_data['ClassFile'] );
	$gateway_object =& $application->recallObject( $gw_data['ClassName'] );

	$transaction_status = $gateway_object->processNotification($gw_data['gw_params']);

	$sql = 'UPDATE %s SET GWResult1 = %s WHERE %s = %s';
	$sql = sprintf($sql, $order->TableName, $db->qstr($gateway_object->getGWResponce()), $order->IDField, $order->GetID() );
	$db->Query($sql);
	$order->SetDBField('GWResult1', $gateway_object->getGWResponce() );

	$sql = 'UPDATE %s SET TransactionStatus = %s WHERE %s = %s';
	$db->Query( sprintf($sql, $order->TableName, $transaction_status, $order->IDField, $order->GetID()) );
	$order->SetDBField('TransactionStatus', $transaction_status);

	if($transaction_status == 1)
	{
		$dummy_var = '10';
		$application->HandleEvent($dummy_var, 'ord:OnCompleteOrder');
	}
	else {
		$application->StoreVar('gw_error', $gateway_object->getErrorMsg());
	}

	$application->Done();