<!--##
<NAME>Product - Add Review</NAME>
<DESC>Add Product Review Form</DESC>
<SECTION>Platform||Products</SECTION>
##-->

<inp2:m_RequireLogin login_template="platform/login/register" permissions="PRODUCT.REVIEW|PRODUCT.REVIEW.PENDING"/>

<!--## PAGE TITLE ELEMENT ##-->
<inp2:m_DefineElement name="page_title">
	<inp2:p_Field name="Name"/>
</inp2:m_DefineElement>
<!--## //PAGE TITLE ELEMENT ##-->

<!--## SIDE-BAR ELEMENT ##-->
<inp2:m_DefineElement name="sidebar">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/cart_indicator.elm" design="blue_box" data_exists="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/login.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/action_box.elm" item_actions="1" design="blue_box"/>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## //SIDE-BAR ELEMENT ##-->

<inp2:m_DefineElement name="content">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_include template="platform/elements/navigation_bar.elm" titles="__item__,lu_title_ReviewProduct" templates="__default__,in-commerce/products/add_review" show_category="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement design="content_box">
				<inp2:m_Capture to_var="header">
					<inp2:m_phrase name="lu_title_ProductDetails"/>
				</inp2:m_Capture>

				<table class="fullwidth table-border">
					<tr><td class="item-padding">

				<img src="<inp2:m_TemplatesBase module="In-Commerce"/>img/shopping_cart_item.gif" alt=""/> <span class="text-title">
				<a href="<inp2:p_ProductLink template="__default__"/>"><inp2:p_Field name="Name"/></a></span>

				<inp2:m_if check="p_Field" name="IsHot"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_hot.gif" alt="<inp2:m_Phrase name="lu_Hot" no_editing="1"/>"/></inp2:m_if>
				<inp2:m_if check="p_Field" name="IsNew"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_new.gif" alt="<inp2:m_Phrase name="lu_New" no_editing="1"/>"/></inp2:m_if>
				<inp2:m_if check="p_Field" name="IsPop"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_popular.gif" alt="<inp2:m_Phrase name="lu_Pop" no_editing="1"/>"/></inp2:m_if>
				<inp2:m_if check="p_IsEditorsPick"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_pick.gif" alt="<inp2:m_Phrase name="lu_Pick" no_editing="1"/>"/></inp2:m_if>
				<inp2:m_if check="p_IsFavorite"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_favorite.gif" alt="<inp2:m_Phrase name="lu_Favorite" no_editing="1"/>"/></inp2:m_if>

				<inp2:p_VotesIndicator render_as="rating_element"/>

				<br />
				<br />

				<table>
					<tr>
						<td style="text-align: center; padding-right: 10px;" valign="top">
							<!--## Check if image exists ##-->
							<inp2:m_if check="p_ImageSrc" MaxWidth="fullsize">
								<a href="<inp2:p_ImageSrc MaxWidth="fullsize" DefaultImage="platform/img/no_picture.gif"/>" class="thickbox" rel="product-images" target="_blank" title="<inp2:p_Field name='Name' html_escape='1'/>">
								<inp2:p_Image render_as="image_element" Primary="1" MaxWidth="thumbnail" DefaultImage="platform/img/no_picture.gif"/><br />
							</a>
							<!--## Check if image exists ##-->
							<inp2:m_else/>
								<inp2:p_Image render_as="image_element" Primary="1" MaxWidth="thumbnail" DefaultImage="platform/img/no_picture.gif"/><br />
							</inp2:m_if>
							<br />
						</td>
						<td valign="top">
							<strong><inp2:m_phrase label="lu_Added"/>:</strong> <inp2:p_field field="CreatedOn_date" format="_regional_DateFormat"/><br />
							<strong><inp2:m_phrase label="lu_Hits"/>:</strong> <inp2:p_field field="Hits"/><br />
							<strong><inp2:m_phrase label="lu_Reviews"/>:</strong> <inp2:p_field field="CachedReviewsQty"/>

							<strong><inp2:m_phrase label="lu_Rating"/>:</strong> <inp2:p_field field="CachedRating"/> (<inp2:m_phrase label="lu_Votes"/>: <inp2:p_field field="CachedVotesQty"/>)

							<br />

							<inp2:m_if check="p_Field" name="ManufacturerId">
								<strong><inp2:m_Phrase label="lu_fld_Manufacturer"/>:</strong> <inp2:p_field name="ManufacturerId"/> (<inp2:m_Phrase label="lu_comm_OtherProductsBy"/> <a href="<inp2:p_ManufacturerLink template="in-commerce/products/manufacturer_products" />"><inp2:p_Field name="ManufacturerId"/></a> <inp2:m_Phrase label="lu_comm_OtherProducts"/>) <br />
							</inp2:m_if>

							<inp2:m_if check="p_Field" name="MSRP">
								<strong><inp2:m_Phrase label="lu_fld_MSRP"/>:</strong> <span class="product-price-msrp"><inp2:p_Field name="MSRP" currency="selected"/></span> <br />
							</inp2:m_if>

							<strong><inp2:m_Phrase label="lu_fld_OurPrice"/>: <span class="product-price"><inp2:p_Field name="Price" currency="selected"/></span></strong> <br />

							<inp2:m_if check="p_Savings">
								<strong><inp2:m_Phrase label="lu_fld_YouSave"/>: <span class="product-price"><inp2:p_Savings currency="selected" /> (<inp2:p_Savings type="percent"/>%)</span></strong><br/>
							</inp2:m_if>
							<br />

							<inp2:m_if check="p_Field" name="DescriptionExcerpt">
								<span class="listing-field-name"><inp2:m_Phrase label="lu_fld_Description"/>:</span> <inp2:p_Field name="DescriptionExcerpt" nl2br="1"/><br/>
							</inp2:m_if>


						</td>
					</tr>
					</table>
				</td></tr></table>
			</inp2:m_RenderElement>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement design="content_box">
				<inp2:m_Capture to_var="header">
					<inp2:m_phrase name="lu_title_ReviewThisProduct"/>
				</inp2:m_Capture>

				<inp2:m_if check="p_HasPermission" permissions="PRODUCT.REVIEW|PRODUCT.REVIEW.PENDING">
					<inp2:m_if check="p-rev_AlreadyReviewed">
						<inp2:m_Phrase label="lu_ErrorAlreadyReviewed"/><br/><br/>
						<table>
							<inp2:p-rev_PrintList render_as="review_element" type="current_user"/>
						</table>
						<inp2:m_include template="platform/elements/pagination.elm" prefix="p-rev"/>
					<inp2:m_else/>
						<inp2:p-rev_PresetFormFields/>
						<span class="field-required">*</span> <inp2:m_phrase name="lu_IndicatesRequired"/><br /><br />

						<inp2:m_if check="p-rev_HasError" field="any">
							<inp2:m_RenderElement name="error_message" />
						</inp2:m_if>

						<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/grey_pix.gif" width="100%" height="1" align="absmiddle" alt="" /><br /><br />

						<form method="post" action="<inp2:m_FormAction/>">
							<table class="form-data fullwidth">
								<inp2:m_RenderElement name="inp_edit_radio" prefix="p-rev" field="Rating" title="lu_fld_Rating"/>
								<inp2:m_RenderElement name="inp_edit_textarea" prefix="p-rev" field="ReviewText" rows="8" cols="40" title="lu_fld_ReviewText" is_last="1"/>

								<inp2:m_RenderElement design="inp_edit_buttons">
									<input type="hidden" name="success_template" value="in-commerce/products/add_review_confirm" />
										<input type="hidden" name="success_pending_template" value="in-commerce/products/add_review_pending_confirm" />
										<input class="button" type="submit" name="events[p-rev][OnCreate]" value="<inp2:m_Phrase label="lu_btn_Create" no_editing="1"/>" />
								</inp2:m_RenderElement>
							</table>
						</form>
					</inp2:m_if>
				<inp2:m_else/>
					<inp2:m_phrase name="lu_text_NoProductReviewPermission"/>
				</inp2:m_if>
			</inp2:m_RenderElement>
		</div>
	</div>
</inp2:m_DefineElement>

<inp2:m_include template="platform/designs/default_design.des" pass_params="1"/>