<?php
/**
* @version	$Id: zones_tag_processor.php 12303 2009-08-17 01:54:03Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ZonesTagProcessor extends kDBTagProcessor
{
	/*
	function ShowDestinations($param)
	{
		$zone =& $this->Application->recallObject('z');
		$zone->SetDBField('ZoneID', $zone->ID);
		$destination =& $this->Application->recallObject('dst');

		if(!$this->Application->GetVar('loaded'))
		{
			if ($zone->GetID() == 0)
			{
				$this->Application->DeleteVar('dst');
			}
			else
			{
				$sql = 'SELECT * FROM '.$destination->TableName.' WHERE ShippingZoneId='.$zone->GetID();
				$res = $this->Conn->Query($sql);
				if (is_array($res)) foreach ($res as $dest_record)
				{
					$temp[$dest_record['ZoneDestId']]['ZoneDestId'] = $dest_record['ZoneDestId'];
					$temp[$dest_record['ZoneDestId']]['StdDestId'] = $dest_record['StdDestId'];
					$temp[$dest_record['ZoneDestId']]['DestValue'] = $dest_record['DestValue'];
				}
				$this->Application->SetVar('dst', $temp);
			}
		}

		$hidden_clause = '<input type="hidden" name="loaded" value="1"><input type="hidden" name="zone_id" value="'.$zone->GetDBField('ZoneID').'">';

		switch ( $zone->GetDBField('Type') )
		{
			case 1:

				$sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations WHERE DestType=1';
				$res = $this->Conn->Query($sql, 'DestId');
				$dropdown = '<select name="country">'."\n";
				foreach ($res as $record)
				{
					$dropdown .= '<option value="'.$record['DestId'].'">'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
				}
				$dropdown .= '</select>'."\n";

				$form_params = Array();
				$form_params['dropdown'] = $dropdown;
				$form_params['block'] = $param['block'];
				$form_params['res'] = $res;
				$ret = $this->ShowDestionationForm($form_params);

				break;
			case 2:

				$country_sql = 'SELECT d1.* FROM '.TABLE_PREFIX.'StdDestinations d1,
								'.TABLE_PREFIX.'StdDestinations d2
								WHERE d1.DestType=1 AND d1.DestId=d2.DestParentId
								GROUP BY d1.DestId';
				if( !($current_country = $this->Application->GetVar('StatesCountry')) )
				{
					$current_country_sql = 'SELECT sd.DestParentId FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
												ON zd.StdDestId = sd.DestId
												WHERE sd.DestType=2 AND zd.ShippingZoneId='.$zone->GetDBField('ZoneID');
					if($zone->GetDBField('ZoneID'))
					{
						$current_country = $this->Conn->GetOne($current_country_sql);
					}

					if(!$current_country)
					{
						$current_country_sql = '	SELECT d1.DestId FROM '.TABLE_PREFIX.'StdDestinations d1
													LEFT JOIN '.TABLE_PREFIX.'StdDestinations d2
													ON d1.DestId = d2.DestParentId
													WHERE d1.DestType=1
													AND d2.DestId IS NOT NULL';
						$current_country = $this->Conn->GetOne($current_country_sql);
					}
				}
				$states_sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations WHERE DestType=2 AND DestParentId='.$current_country;
				$countries = $this->Conn->Query($country_sql, 'DestId');
				$states = $this->Conn->Query($states_sql, 'DestId');

				if($countries)
				{
					$countries_dropdown = '<select name="StatesCountry" onchange="submit_event(\'z\', \'OnCountryChange\')">'."\n";
					foreach ($countries as $record)
					{
						$countries_dropdown .= '<option value="'.$record['DestId'].'" ';
						if($record['DestId'] == $current_country)
						{
							$countries_dropdown .= 'selected';
						}
						$countries_dropdown .= '>'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
					}
					$countries_dropdown .= '</select>'."\n";
				}

				if($states)
				{
					$states_dropdown = '<select name="state">'."\n";
					foreach ($states as $id => $record)
					{
						$states_dropdown .= '<option value="'.$record['DestId'].'">'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
					}
					$states_dropdown .= '</select>'."\n";
				}

				$form_params = Array();
				$table = '<table border="0"><tr><td>'.$this->Application->Phrase('la_fld_Country').': </td><td>'.$countries_dropdown.'</td></tr>';
				$table .= '<tr><td>'.$this->Application->Phrase('la_fld_State').': </td><td>'.$states_dropdown.'</td></tr></table>';
				$form_params['dropdown'] = $table;
				$form_params['block'] = $param['block'];
				$form_params['res'] = $states;
				$ret = $this->ShowDestionationForm($form_params);

				break;
			case 3:

				$country_sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations WHERE DestType=1';
				if( !($current_country = $this->Application->GetVar('ZIPCountry')) )
				{
					$current_country_sql = 'SELECT StdDestId FROM '.$destination->TableName.'
												WHERE ShippingZoneId='.$zone->GetDBField('ZoneID');
					$cur_country = (int)$this->Conn->GetOne($current_country_sql);
					if($zone->GetDBField('ZoneID') && $cur_country)
					{
						$current_country = $cur_country;
					}
					else
					{
						$current_country_sql = 'SELECT MIN(DestId) FROM '.TABLE_PREFIX.'StdDestinations';
						$current_country = (int)$this->Conn->GetOne($current_country_sql);
					}
				}
				$countries = $this->Conn->Query($country_sql, 'DestId');

				if($countries)
				{
					$countries_dropdown = '<select name="ZIPCountry" onchange="submit_event(\'z\', \'OnCountryChange\')">'."\n";
					foreach ($countries as $record)
					{
						$countries_dropdown .= '<option value="'.$record['DestId'].'" ';
						if($record['DestId'] == $current_country)
						{
							$countries_dropdown .= 'selected';
						}
						$countries_dropdown .= '>'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
					}
					$countries_dropdown .= '</select>'."\n";
				}


				$sql = 'SELECT DestValue FROM '.TABLE_PREFIX.'ShippingZonesDestinations WHERE NOT(DestValue IS NULL) AND DestValue<>"" AND StdDestId='.$current_country;
				$res = array_unique( $this->Conn->GetCol($sql) );
				$dropdown = '<input type="text" name="zip_input" id="zip_input" size="15">';
				if($res)
				{
					$dropdown .= ' or <select name="zip_dropdown">'."\n";
					$dropdown .= '<option value=""></option>';
					foreach ($res as $record)
					{
						$dropdown .= '<option value="'.$record.'">'.$record.'</option>'."\n";
					}
					$dropdown .= '</select>'."\n";
				}

				$table = '<table border="0"><tr><td>'.$this->Application->Phrase('la_fld_Country').': </td><td>'.$countries_dropdown.'</td></tr>';
				$table .= '<tr><td>'.$this->Application->Phrase('la_fld_ZIP').': </td><td>'.$dropdown.'</td></tr></table>';

				$form_params = Array();
				$form_params['dropdown'] = $table;
				$form_params['block'] = $param['block'];
				$form_params['res'] = $res;
				$ret = $this->ShowDestionationForm($form_params);

				break;
			default:
		}

		$ret .= $hidden_clause;
		return $ret;
	}

	function ShowDestionationForm($param)
	{
		$add_button = '<input type="button" class="button" value="'.$this->Application->Phrase('la_btn_AddLocation').'" onclick="submit_event(\'z\', \'OnAddLocation\')">';

		$main_processor =& $this->Application->RecallObject('m_TagProcessor');
		$oddevenparam['odd'] = 'table-color1';
		$oddevenparam['even'] = 'table-color2';
		$ret = '<tr class="'.$main_processor->Odd_Even($oddevenparam).'"><td></td><td>'.$param['dropdown'].'</td><td>'.$add_button.'</td></tr>';

		$dest_list = $this->Application->GetVar('dst');
		if (is_array($dest_list) && count($dest_list))
		{
			$ret .= '<tr class="'.$main_processor->Odd_Even($oddevenparam).'"><td></td><td><select multiple name="location_list" onchange="SelectToString(this)">';
			$hidden = '';

			foreach ($dest_list as $id => $destination)
			{
				$params = $destination;
				$params['id'] = $id;
				$hidden .= '<input type="hidden" id="dst['.$destination['ZoneDestId'].'][ZoneDestId]" name="dst['.$destination['ZoneDestId'].'][ZoneDestId]" value="'.$destination['ZoneDestId'].'">';

				$zones_object =& $this->Application->recallObject('z');

				switch($zones_object->GetDBField('Type'))
				{
					case 1:
						$params['destination_title'] = $this->Application->Phrase( $param['res'][$destination['StdDestId']]['DestName'] );
						$hidden .= '<input type="hidden" id="dst['.$destination['ZoneDestId'].'][StdDestId]" name="dst['.$destination['ZoneDestId'].'][StdDestId]" value="'.$destination['StdDestId'].'">';
						break;
					case 2:
						$params['destination_title'] = $this->Application->Phrase( $param['res'][$destination['StdDestId']]['DestName'] );
						$hidden .= '<input type="hidden" id="dst['.$destination['ZoneDestId'].'][StdDestId]" name="dst['.$destination['ZoneDestId'].'][StdDestId]" value="'.$destination['StdDestId'].'">';
						break;
					case 3:
						$params['destination_title'] = $destination['DestValue'];
						$hidden .= '<input type="hidden" id="dst['.$destination['ZoneDestId'].'][DestValue]" name="dst['.$destination['ZoneDestId'].'][DestValue]" value="'.$destination['DestValue'].'">';

				}

				$params['name']	= $param['block'];
				$ret .= $main_processor->ParseBlock($params);
			}
			$ret .= '</select></td><td><input type="button" class="button" value="'.$this->Application->Phrase('la_btn_RemoveLocations').'" onclick="remove_location('.$destination['ZoneDestId'].')"></td><tr>';
			$ret .= $hidden;
		}

		return $ret;
	}
	*/


	function ShowCountries($param){

		$param = $this->prepareTagParams($param);
		$param['name'] = $param['block'];

		$destination 	= &$this->Application->recallObject('dst');
		$zone 			= &$this->Application->recallObject('z');

		$selected_country = Array(); // this prevents 241 warnings to me raised :D
		switch ($param['show']){
			case 'current':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=1
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND zd.ShippingZoneId='.$zone->GetDBField('ZoneID').'
												ORDER BY Translation
												';
				break;
			case 'available':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=1
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND zd.ShippingZoneId IS NULL
												ORDER BY Translation
												';
				break;
			case 'all':

				$selected_country = $this->Application->GetVar('CountrySelector');
				if (!$selected_country){
					// get 1st available country ID
					$selected_country = $this->Conn->GetOne('SELECT StdDestId FROM '.$destination->TableName.'
								WHERE ShippingZoneId='.$zone->GetDBField('ZoneID'));
					if ($selected_country){
						$this->Application->SetVar('CountrySelector', $selected_country);
					}
				}

				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=1
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												ORDER BY Translation
												';
				break;
			case 'has_states':
				$has_states = $this->Conn->GetCol('SELECT DISTINCT DestParentId FROM '.TABLE_PREFIX.'StdDestinations sd
												WHERE sd.DestType=2');
				$selected_country = $this->Application->GetVar('CountrySelector');

				if ($selected_country && !in_array($selected_country, $has_states)){
					$selected_country = $has_states[0];
					$this->Application->SetVar('CountrySelector', $selected_country);
				}

				if (!$selected_country){
					// get 1st available country ID
					$selected_country = $this->Conn->GetOne('SELECT DestParentId FROM '.TABLE_PREFIX.'StdDestinations sd
								LEFT JOIN '.$destination->TableName.' zd
								ON zd.StdDestId = sd.DestId
								WHERE sd.DestType=2
								AND zd.ShippingZoneId='.$zone->GetDBField('ZoneID'));
					if ($selected_country){
						$this->Application->SetVar('CountrySelector', $selected_country);
					}
					else {
						$selected_country = $has_states[0];
						$this->Application->SetVar('CountrySelector', $selected_country);
					}
				}


				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=1
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND DestId IN ('.implode(',', $has_states).')
												ORDER BY Translation
												';
				break;
		}

		$countries = $this->Conn->Query($sql);
		$o = '';


		foreach($countries as $key => $country) {
			$param['id'] = $country['DestId'];
			$param['destination_title'] = $this->Application->Phrase($country['DestName']);
			if ($selected_country && $selected_country == $param['id']){
				$param['selected'] = ' selected="selected"';
			}
			else {
				$param['selected']='';
			}
			$o .= $this->Application->ParseBlock($param);
		}
		return $o;

	}

	function ShowStates($param){

		$param = $this->prepareTagParams($param);
		$param['name'] = $param['block'];

		$destination 	= &$this->Application->recallObject('dst');
		$zone 			= &$this->Application->recallObject('z');

		switch ($param['show']){
			case 'current':
				$sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=2
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND sd.DestParentId='.$this->Application->GetVar('CountrySelector').'
												AND zd.ShippingZoneId='.$zone->GetDBField('ZoneID').'
												ORDER BY Translation
												';
				break;
			case 'available':
				$sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=2
												AND zd.ShippingZoneId IS NULL
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND sd.DestParentId='.$this->Application->GetVar('CountrySelector').'
												ORDER BY Translation
												';

				break;
			case 'all':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=2
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND sd.DestParentId='.$this->Application->GetVar('CountrySelector').'
												ORDER BY Translations
												';
				break;
		}

		$states = $this->Conn->Query($sql);
		$o = '';
		foreach($states as $key => $state) {
			$param['id'] = $state['DestId'];
			$param['destination_title'] = $this->Application->Phrase($state['DestName']);
			$o .= $this->Application->ParseBlock($param);
		}
		return $o;

	}

	function ShowZips($param){

		$param = $this->prepareTagParams($param);
		$param['name'] = $param['block'];

		$destination 	= &$this->Application->recallObject('dst');
		$zone 			= &$this->Application->recallObject('z');

		$country_selector = $this->Application->GetVar('CountrySelector');
		if (!$country_selector){
			$country_selector=0;
		}

		switch ($param['show']){
			case 'current':
				$sql = 'SELECT * FROM '.$destination->TableName.'
												WHERE NOT(DestValue IS NULL)
												AND DestValue<>""
												AND ShippingZoneID='.$zone->GetDBField('ZoneID').'
												ORDER BY DestValue
												';
				break;
			case 'available':
				$selected_zips = $this->Conn->GetCol('SELECT DestValue FROM '.$destination->TableName.'
												WHERE NOT(DestValue IS NULL)
												AND DestValue<>""
												AND ShippingZoneID='.$zone->GetDBField('ZoneID').'
												ORDER BY DestValue
												');

				$sql = 'SELECT DISTINCT(DestValue) FROM '.$this->Application->getUnitOption('dst', 'TableName').'
												WHERE NOT(DestValue IS NULL)
												AND ShippingZoneID!='.$zone->GetDBField('ZoneID').'
												AND DestValue NOT IN ("'.implode('", "', $selected_zips).'")
												AND DestValue<>"" AND StdDestId='.$country_selector.'
												ORDER BY DestValue
												';

				break;
			case 'all':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												WHERE sd.DestType=3 AND sd.DestParentId='.$country_selector.'
												ORDER BY DestValue
												';
				break;
		}

		$zips = $this->Conn->Query($sql);
		$o = '';
		foreach($zips as $key => $zip) {
			$param['id'] = $zip['DestId'].'|'.$zip['DestValue'];
			$param['destination_title'] = $zip['DestValue'];
			$o .= $this->Application->ParseBlock($param);
		}
		return $o;

	}
}