<?php
/**
* @version	$Id: order_items_config.php 12489 2009-09-15 04:05:56Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'orditems',
		'ItemClass' => Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array('class' => 'OrderItemsEventHandler', 'file' => 'order_items_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array('class' => 'OrderItemsTagProcessor', 'file' => 'order_items_tag_processor.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'AggregateTags' => Array (
			Array (
				'AggregateTo' => '#PARENT#',
				'AggregatedTagName' => 'ItemFieldEquals',
				'LocalTagName' => 'FieldEquals',
			),
		),

		'Hooks' => Array (
			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => '#PARENT#',
				'HookToSpecial' => '',
				'HookToEvent' => Array('OnPreSave', 'OnRecalculateItems'),
				'DoPrefix' => '',
				'DoSpecial' => '',
				'DoEvent' => 'OnUpdate',
			),
		),

		'QueryString' => Array (
			1 => 'id',
			2 => 'page',
			3 => 'event',
		),

		'IDField' => 'OrderItemId',
		'TitleField' => 'OrderItemId',
		'StatusField' => Array ('Status'),

		'TableName' => TABLE_PREFIX.'OrderItems',

		'ParentTableKey' => 'OrderId',
		'ForeignKey' => 'OrderId',
		'ParentPrefix' => 'ord',
		'AutoDelete' => true,
		'AutoClone' => true,

		'ItemType' => 11,

		'CalculatedFields' => Array (
			''	=> Array (
				'ExtendedPrice' => '%1$s.Price * %1$s.Quantity',
				'ExtendedPriceFlat' => '%1$s.FlatPrice * %1$s.Quantity',
				'QuantityAvailable' => 'IF( ISNULL(p.QtyInStock) AND ISNULL(p.ProductId),"!la_ProductDeleted!", IF(p.Type = 1, IF(p.InventoryStatus = 2, poc.QtyInStock, p.QtyInStock), "") )',
				'ItemDiscount' => '(%1$s.FlatPrice - %1$s.Price)',
				'SKU' => 'IF(p.InventoryStatus = 2 OR NOT ISNULL(poc.CombinationCRC), poc.SKU, p.SKU)', // inventory by options OR combination found
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.*, p.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'Products p ON %1$s.ProductId = p.ProductId
					LEFT JOIN '.TABLE_PREFIX.'ProductOptionCombinations poc ON (%1$s.ProductId = poc.ProductId) AND (%1$s.OptionsSalt = poc.CombinationCRC)',
		),

		'ItemSQLs' => Array (
			'' => 'SELECT *, (Quantity*Price) AS ExtendedPrice, 0 AS QuantityAvailable FROM %s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('ProductName' => 'asc', 'BackOrderFlag' => 'asc'),
			)
		),

		'Fields' => Array (
			'OrderItemId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
			'OrderId' => Array('type' => 'int','not_null' => 1, 'default' => 0),
			'ProductId' => Array('type' => 'int','not_null' => 1, 'default' => 0),
			'ProductName' => Array('type' => 'string','not_null' => 1, 'default' => ''),
			'Quantity' => Array('type' => 'int','not_null' => 1, 'default' => 0),
			'QuantityReserved' => Array('type' => 'int', 'default' => null),
			'FlatPrice' => Array('type' => 'double','formatter'=>'kFormatter','format'=>'%01.2f','not_null' => '1','default' => '0.0000'),
			'Price' => Array('type' => 'double','formatter'=>'kFormatter','format'=>'%01.2f','not_null' => '1','default' => '0.0000'),
			'Cost' => Array('type' => 'double','formatter'=>'kFormatter','format'=>'%01.2f','not_null' => '1','default' => '0.0000'),
			'BackOrderFlag' => Array('type' => 'int', 'default' => 0),
			'Weight' => Array ('type' => 'double', 'default' => NULL),
			'ShippingTypeId' => Array ('type' => 'string', 'default' => NULL),
			'ItemData' => Array('type' => 'string','default' => null),
			'OptionsSalt' => Array('type' => 'int', 'default' => 0),
			'SplitShippingGroup' => Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
			'PackageNum' => Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
			'ReturnType' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Refund', 2 => 'la_opt_Exchange', 3 => 'la_opt_Warranty'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
		    'ReturnAmount' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => 0),
		    'ReturnedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		),

		'VirtualFields' => Array (
			'ExtendedPrice'	=>	Array('type'=>'double','formatter'=>'kFormatter','format'=>'%01.2f','default'=>'0.00'),
			'ExtendedPriceFlat'	=>	Array('type'=>'double','formatter'=>'kFormatter','format'=>'%01.2f','default'=>'0.00'),
			'QuantityAvailable'	=>	Array('type'=>'int','default'=>0),
			'DiscountType'	=>	Array('type'=>'string','default'=>''),
			'DiscountId'	=>	Array('type'=>'int','default'=>0),
			'Name'			=>	Array('formatter' => 'kMultiLanguage'),
			'ItemDiscount'	=>	Array('type'=>'double','formatter'=>'kFormatter','format'=>'%01.2f','default'=>'0.00'),
			'SKU'				=>	Array('type' => 'string', 'default' => ''),
			'MinQtyFreeShipping'=> Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_product.png',
					0 => 'icon16_product_disabled.png',
					1 => 'icon16_product.png',
					2 => 'icon16_product_pending.png',
				),
				'Fields' => Array (
					'ProductName' => Array ('title' => 'la_col_ProductNameId', 'data_block' => 'grid_productname_td', 'filter_block' => 'grid_like_filter'),
					'Quantity' => Array ('title' => 'la_col_Quantity', 'data_block' => 'grid_quantity_td', 'filter_block' => 'grid_range_filter'),
					'QuantityReserved' => Array ('title' => 'la_col_QuantityReserved', 'filter_block' => 'grid_range_filter'),
					'QuantityAvailable' => Array ('title' => 'la_col_QuantityAvailable', 'filter_block' => 'grid_range_filter'),
					'Price' => Array ('title' => 'la_col_Price', 'data_block' => 'grid_price_td', 'filter_block' => 'grid_float_range_filter'),
					'ExtendedPrice' => Array ('title' => 'la_col_ExtendedPrice', 'data_block' => 'grid_extendedprice_td', 'filter_block' => 'grid_float_range_filter'),

					'ReturnType' => Array ('title' => 'la_col_ReturnType', 'data_block' => 'grid_options_td', 'filter_block' => 'grid_options_filter'),
					'ReturnAmount' => Array ('title' => 'la_col_ReturnAmount', 'data_block' => 'grid_edit_td', 'filter_block' => 'grid_float_range_filter'),
					'ReturnedOn' => Array ('title' => 'la_col_ReturnedOn', 'data_block' => 'grid_date_td', 'filter_block' => 'grid_date_range_filter'),
				),
			),

			'NotEditable' => Array (
				'Icons' => Array (
					'default' => 'icon16_product.png',
					0 => 'icon16_product_disabled.png',
					1 => 'icon16_product.png',
					2 => 'icon16_product_pending.png',
				),
				'Fields' => Array (
					'ProductName' => Array ('title' => 'la_col_ProductNameId', 'data_block' => 'grid_productname_td'),
					'Quantity' => Array ('title' => 'la_col_Quantity', 'filter_block' => 'grid_range_filter'),
					'QuantityReserved' => Array ('title' => 'la_col_QuantityReserved', 'filter_block' => 'grid_range_filter'),
					'QuantityAvailable' => Array ('title' => 'la_col_QuantityAvailable', 'filter_block' => 'grid_range_filter'),
					'Price' => Array ('title' => 'la_col_Price', 'filter_block' => 'grid_float_range_filter'),
					'ExtendedPrice' => Array ('title' => 'la_col_ExtendedPrice', 'filter_block' => 'grid_float_range_filter'),

					'ReturnType' => Array ('title' => 'la_col_ReturnType', 'data_block' => 'grid_options_td', 'filter_block' => 'grid_options_filter'),
					'ReturnAmount' => Array ('title' => 'la_col_ReturnAmount', 'data_block' => 'grid_edit_td', 'filter_block' => 'grid_float_range_filter'),
					'ReturnedOn' => Array ('title' => 'la_col_ReturnedOn', 'data_block' => 'grid_date_td', 'filter_block' => 'grid_date_range_filter'),
				),
			),
		),
	);