<?php
/**
* @version	$Id: affiliates_tag_processor.php 12303 2009-08-17 01:54:03Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class AffiliatesTagProcessor extends kDBTagProcessor {

		/**
		 * Returns link to be placed on other sites
		 *
		 * @param Array $params
		 * @return string
		 */
		function GetAffiliateLink($params)
		{
			$object =& $this->getObject($params);
			$params['affiliate'] = $object->GetDBField('AffiliateCode');
			$params['prefix'] = '_FRONT_END_';
			$params['index_file'] = 'index.php';
			$params['no_pass'] = 1; // don't work
			$params['__SSL__'] = 0;
			$params['__NO_SID__'] = 1; // don't work

			$link = $this->Application->ProcessParsedTag('m', 'Link', $params);

			// remove env manually (because no_pass parameter don't work)
			return preg_replace('/(.*)\/index.php\?env=(.*)&amp;(.*)/', '\\1/index.php?\\3', $link);
		}

		/**
		 * Returns link to be placed on other sites (for current user)
		 *
		 * @param Array $params
		 * @return string
		 */
		function GetUserAffiliateLink($params)
		{
			$object =& $this->Application->recallObject( $this->getPrefixSpecial(), $this->Prefix, array_merge($params, array('skip_autoload'=>true)) );
			$object->Load(array('PortalUserId' => $this->Application->RecallVar('user_id')));

//			return $this->GetAffiliateLink($params);

			$params['no_pass'] = 1; // don't work
			$params['index_file'] = 'index.php';
			$params['affiliate'] = $object->GetDBField('AffiliateCode');
			$params['__SSL__'] = 0;
			$params['__NO_SID__'] = 1; // don't work

			$link = $this->Application->ProcessParsedTag('m', 'Link', $params);

			// remove env manually (because no_pass parameter don't work)
			return preg_replace('/(.*)\/index.php\?env=(.*)&amp;(.*)/', '\\1/index.php?\\3', $link);
		}

		/**
		 * Returns true if user is affiliate
		 *
		 * @param Array $params
		 * @return bool
		 */
		function User_IsAffiliate($params)
		{
			$object =& $this->Application->recallObject($this->Prefix.'.user', $this->Prefix, Array('skip_autoload'=>true) );
			$object->Load( $this->Application->RecallVar('user_id'), 'PortalUserId' );

			return $object->isLoaded();
		}

		function User_AffiliateIsNotActive($params)
		{
			$object =& $this->Application->recallObject($this->Prefix.'.user', $this->Prefix, Array('skip_autoload'=>true) );
			$object->Load( $this->Application->RecallVar('user_id'), 'PortalUserId' );

			return $object->isLoaded() && ($object->GetDBField('Status') != 1);
		}

		/**
		 * Returns url for editing user from current record
		 *
		 * @param Array $params
		 * @return string
		 */
		function UserLink($params)
		{
			$object =& $this->getObject($params);
			$user_id = $object->GetDBField('PortalUserId');

			if ($user_id) {
				$url_params =  Array (
					'm_opener' => 'd',
					'u_mode' => 't',
					'u_event' => 'OnEdit',
					'u_id' => $user_id,
					'pass' => 'all,u'
				);

				return $this->Application->HREF($params['edit_template'], '', $url_params);
			}
		}

		function CurrentUserAffiliateField($params)
		{
			$object =& $this->Application->recallObject( $this->getPrefixSpecial(), $this->Prefix, array_merge($params, Array('skip_autoload' => true)) );
			$object->Load( Array('PortalUserId'=>$this->Application->RecallVar('user_id')) );
			return $object->GetField($this->SelectParam($params, 'field,name'));
		}

		function IsAffiliateOrRegisterAsAffiliateAllowed($params)
		{
			$object =& $this->Application->recallObject($this->Prefix.'.user', $this->Prefix, Array('skip_autoload'=>true) );
			$object->Load( $this->Application->RecallVar('user_id'), 'PortalUserId' );

			return ($this->Application->ConfigValue('Comm_RegisterAsAffiliate') || $object->isLoaded()) ? 1 : 0;
		}

		/**
		 * [AGGREGATED TAG] Checks if affilite registration is allowed
		 *
		 * @param Array $params
		 * @return int
		 */
		function AllowAffiliateRegistration($params)
		{
			return $this->Application->ConfigValue('Comm_RegisterAsAffiliate') ? 1 : 0;
		}

		function Main_RequireAffiliate($params)
		{
			$t = $params['registration_template'];
			if( !$this->User_IsAffiliate($params) )
			{
				$redirect_params = Array( 'next_template' => $this->Application->GetVar('t') );
				$this->Application->Redirect($t, $redirect_params);
			}
		}
	}