<?php
/**
* @version	$Id: currency_rates.php 12303 2009-08-17 01:54:03Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class kCurrencyRates extends kBase {

	var $RateSource;
	var $ExchangeRates = Array();
	var $PrimaryCurrency;

	function kCurrencyRates()
	{
		$this->Application =& kApplication::Instance();
		$this->GetRatesData();
	}

	function GetRatesData()
	{
		// written :) just check that it's correct
		$conn =& $this->Application->GetADODBConnection();
		$table = $this->Application->getUnitOption('curr', 'TableName');
		$primary = $this->GetPrimaryCurrency();
		$sql = 'SELECT "'.$primary.'" AS TARGET, ISO AS ID, RateToPrimary As RATE, 1 AS UNITS FROM '.$table.' WHERE 1';
		$rates = $conn->Query($sql);
		foreach ($rates as $a_rate) {
			$this->SetRate($primary, $a_rate['ID'], $a_rate['RATE']);
		}
	}

	function GetRate($source_cur, $target_cur, $units = 1)
	{
		$source_cur = ($source_cur == 'PRIMARY') ? $this->GetPrimaryCurrency() : $source_cur;
		$target_cur = ($target_cur == 'PRIMARY') ? $this->GetPrimaryCurrency() : $target_cur;
		if($source_cur == $target_cur)
		{
			return 1;
		}

		if($this->ExchangeRates[$target_cur]['TARGET'] == $source_cur)
		{
			$rate = ($this->ExchangeRates[$target_cur]['RATE'] ==  0) ? false : 1 / $this->ExchangeRates[$target_cur]['RATE'];
		}
		elseif($this->ExchangeRates[$source_cur]['TARGET'] == $target_cur)
		{
			$rate = $this->ExchangeRates[$source_cur]['RATE'];
		}
		else
		{
			$rate = ($this->ExchangeRates[$target_cur]['RATE'] == 0) ? false : $this->ExchangeRates[$source_cur]['RATE'] / $this->ExchangeRates[$target_cur]['RATE'];
		}
		$rate *= $units;
		return $rate;
	}

	function Convert($amount, $source_cur, $target_cur)
	{
		return $amount * $this->GetRate($source_cur, $target_cur);
	}

	function SetRate($source_cur, $target_cur, $rate, $units = 1)
	{
		$this->ExchangeRates[$target_cur]['TARGET']	= $source_cur;
		$this->ExchangeRates[$target_cur]['ID']		= $target_cur;
		$this->ExchangeRates[$target_cur]['RATE']	= $rate;
		$this->ExchangeRates[$target_cur]['UNITS']	= $units;
	}

	function GetPrimaryCurrency()
	{
		if(!$this->PrimaryCurrency)
		{
			$conn =& $this->Application->GetADODBConnection();
			$table = $this->Application->getUnitOption('curr', 'TableName');
			$sql = 'SELECT ISO FROM '.$table.' WHERE IsPrimary = 1';
			$this->PrimaryCurrency = $conn->GetOne($sql);
		}
		return $this->PrimaryCurrency;
	}

	function StoreRates($currencies=null)
	{
		$curr_object =& $this->Application->recallObject('curr', null, Array ('skip_autoload' => true));
		/* @var $curr_object kDBItem */

		if ($currencies) {
			if (!is_array($currencies)) {
				$currencies = explode(',', $currencies);
			}
		}
		else {
			$currencies = array_keys($this->ExchangeRates);
		}

		foreach ($currencies as $id) {
			$rate = $this->GetRate($id, 'PRIMARY');
			if ($rate) {
				$curr_object->Clear();
				$curr_object->Load($id, 'ISO');
				$curr_object->SetDBField('RateToPrimary', $rate);
				$curr_object->SetDBField('Modified_date', adodb_mktime());
				$curr_object->SetDBField('Modified_time', adodb_mktime());
				$curr_object->Update();
			}
		}
	}
}


class kBankLVCurrencyRates extends kCurrencyRates  {

	function kBankLVCurrencyRates()
	{
		$this->RateSource = 'http://www.bank.lv/ValutuKursi/XML/xml.cfm';
		parent::kCurrencyRates();
	}

	function GetRatesData()
	{
		$this->GetPrimaryCurrency();
		$xml_parser = xml_parser_create();

		$curl_helper =& $this->Application->recallObject('CurlHelper');
		/* @var $curl_helper kCurlHelper */

		$xml = $curl_helper->Send($this->RateSource);

		xml_parse_into_struct($xml_parser, $xml, $struct, $index);
		$data_res = Array();
		$currency = '';
		foreach($struct as $element)
		{
			switch($element['tag'])
			{
				case 'ID':
					$currency = $element['value'];
					$data_res[$currency]['ID'] = $currency;
					$data_res[$currency]['TARGET'] = 'LVL';
				break;
				case 'UNITS':
					$data_res[$currency]['UNITS'] = $element['value'];
				break;
				case 'RATE':
					$data_res[$currency]['RATE'] = $element['value'];
				break;
				default:
			}
		}

		if(!$data_res['LVL'])
		{
			$data_res['LVL']['ID'] = 'LVL';
			$data_res['LVL']['UNITS'] = 1;
			$data_res['LVL']['TARGET'] = 'LVL';
			$data_res['LVL']['RATE'] = 1;
		}
		$this->ExchangeRates = $data_res;
	}
}


class kECBCurrencyRates extends kCurrencyRates  {

	function kECBCurrencyRates()
	{
		$this->RateSource = 'http://www.ecb.int/stats/eurofxref/eurofxref-daily.xml';
		parent::kCurrencyRates();
	}

	function GetRatesData()
	{
		$this->GetPrimaryCurrency();
		$xml_parser = xml_parser_create();

		$curl_helper =& $this->Application->recallObject('CurlHelper');
		/* @var $curl_helper kCurlHelper */

		$xml = $curl_helper->Send($this->RateSource);

		xml_parse_into_struct($xml_parser, $xml, $struct, $index);
		$data_res = Array();
		foreach($struct as $element)
		{
			if(isset($element['attributes']) && isset($element['attributes']['CURRENCY']))
			{
				$currency = $element['attributes']['CURRENCY'];
				$data_res[$currency]['ID'] = $currency;
				$data_res[$currency]['TARGET'] = 'EUR';
				$data_res[$currency]['UNITS'] = 1;
				$data_res[$currency]['RATE'] = ($element['attributes']['RATE'] == 0) ? 0 : 1 / $element['attributes']['RATE'];
			}
		}
		if(!$data_res['EUR'])
		{
			$data_res['EUR']['ID'] = 'EUR';
			$data_res['EUR']['UNITS'] = 1;
			$data_res['EUR']['TARGET'] = 'EUR';
			$data_res['EUR']['RATE'] = 1;
		}
		$this->ExchangeRates = $data_res;
	}
}


class kFRNYCurrencyRates extends kCurrencyRates  {

	function kFRNYCurrencyRates()
	{
		$this->RateSource = 'http://www.ny.frb.org/markets/fxrates/FXtoXML.cfm?FEXdate=%s&FEXtime=1200';
		parent::kCurrencyRates();
	}

	function GetRatesData()
	{
		$curl_helper =& $this->Application->recallObject('CurlHelper');
		/* @var $curl_helper kCurlHelper */

		$this->GetPrimaryCurrency();
		for($i = 0; $i < 10; $i++)
		{
			$time = adodb_mktime() - $i * 3600 * 24;
			$source_file = sprintf($this->RateSource, adodb_date('Y-m-d', $time));
			$xml = $curl_helper->Send($source_file);

			$xml_parser = xml_parser_create();
			xml_parse_into_struct($xml_parser, $xml, $struct, $index);
			foreach($struct as $element)
			{
				if($element['tag'] == 'FRBNY:DATASET')
				{
					break;
				}
			}
			if($element['type'] == 'open')
			{
				break;
			}
		}
		if($element['type'] != 'open')
		{
			return false;
		}

		foreach($struct as $element)
		{
			switch($element['tag'])
			{
				case 'FRBNY:SERIES':
					$currency = $element['attributes']['UNIT'];
					if($currency)
					{
						$data_res[$currency]['ID'] = $currency;
						$data_res[$currency]['UNITS'] = 1;
					}
				break;
				case 'FRBNY:CURR':
					$data_res[$currency]['TARGET'] = $element['value'];
				break;
				case 'FRBNY:OBS_VALUE':
					$data_res[$currency]['RATE'] = ($element['value'] == 0) ? 0 : 1 / $element['value'];
				break;
				default:
			}
		}
		if(!$data_res['USD'])
		{
			$data_res['USD']['ID'] = 'USD';
			$data_res['USD']['UNITS'] = 1;
			$data_res['USD']['TARGET'] = 'USD';
			$data_res['USD']['RATE'] = 1;
		}
		$this->ExchangeRates = $data_res;
	}
}

?>