<?php
/**
* @version	$Id: shipping_config.php 12500 2009-09-15 16:27:57Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	's',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'ShippingEventHandler', 'file' => 'shipping_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'ShippingTagProcessor', 'file' => 'shipping_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,
					'AggregateTags' => Array (
															Array (
																'AggregateTo' => 'ord',
																'AggregatedTagName' => 'PrintShippingTypes',
																'LocalTagName' => 'Order_PrintShippingTypes',
															),
													),
					'Hooks'				=>	Array (
												Array (
													'Mode' => hBEFORE,
													'Conditional' => true,
													'HookToPrefix' => 'sc',
													'HookToSpecial' => '',
													'HookToEvent' => Array ( 'OnPropagate', 'OnClearAll' ),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnPreSave',
												),
											),
					'QueryString'		=>	Array (
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
												4	=>	'mode',
											),
					'IDField'			=>	'ShippingID',
					'StatusField'		=>	Array ('Status'),
					'TitleField'		=>  'Name',

					'TitlePresets'		=>	Array (
												'default'	=>	Array (	'new_status_labels'		=> Array ('s' => '!la_title_AddingShippingType!'),
																		'edit_status_labels'	=> Array ('s' => '!la_title_EditingShippingType!'),
																		'new_titlefield'		=> Array ('s' => '!la_title_NewShippingType!'),
																),
												'shipping_list'=>Array (		'prefixes'				=> Array ('s_List'),
																			'format'				=>	"!la_title_ShippingTypes!",
																),
												'shipping_type_edit'=>Array (	'prefixes'				=> Array ('s'),
																				'format'				=> "#s_status# '#s_titlefield#' - !la_title_General!",
																),

												'zones'		=>	Array ('prefixes' => Array ('s'), 'format' => "#s_status# '#s_titlefield#' - !la_title_Zones!"),
												'brackets'	=>	Array ('prefixes' => Array ('s'), 'format' => "#s_status# '#s_titlefield#' - !la_title_Brackets!"),
												'costs'	=>	Array ('prefixes' => Array ('s'), 'format' => "#s_status# '#s_titlefield#' - !la_title_Costs!"),
												'groups'	=>	Array ('prefixes' => Array ('s'), 'format' => "#s_status# '#s_titlefield#' - !la_title_Groups!"),
												'select_modifier'	=>	Array ('prefixes' => Array ('s'), 'format' => "!la_title_ApplyModifier!"),
											),

					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/shipping/shipping_edit', 'priority' => 1),
							'zones' => Array ('title' => 'la_tab_ShippingZones', 't' => 'in-commerce/shipping/shipping_zones', 'priority' => 2),
							'brackets' => Array ('title' => 'la_tab_Brackets', 't' => 'in-commerce/shipping/shipping_brackets', 'priority' => 3),
							'costs' => Array ('title' => 'la_tab_Costs', 't' => 'in-commerce/shipping/shipping_costs', 'priority' => 4),
							'groups' => Array ('title' => 'la_tab_UserGroups', 't' => 'in-commerce/shipping/shipping_type_groups', 'priority' => 5),
						),
					),

					'PermSection'		=>	Array ('main' => 'in-commerce:shipping'),

					'Sections'			=>	Array (
						'in-commerce:shipping_folder'	=>	Array (
							'parent'		=>	'in-commerce:setting_folder',
							'icon'			=>	'conf_shipping',
							'label'			=>	'la_tab_Shipping',
							'permissions'	=>	Array (),
							'priority'		=>	4,
							'type'			=>	stTREE,
						),

						'in-commerce:shipping'	=>	Array (
							'parent'		=>	'in-commerce:shipping_folder',
							'icon'			=>	'conf_shipping',
							'label'			=>	'la_tab_CustomShippingTypes',
							'url'			=>	Array ('t' => 'in-commerce/shipping/shipping_custom_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
							'priority'		=>	4.1,
							'type'			=>	stTAB,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'ShippingType',

					'SubItems'	=> Array ('z', 'br'),

					'FilterMenu'		=>	Array (
												'Groups' => Array (
													Array ('mode' => 'AND', 'filters' => Array ('show_active', 'show_disabled'), 'type' => WHERE_FILTER),
												),
												'Filters' => Array (
													'show_active'	=>	Array ('label' =>'la_Active', 'on_sql' => '', 'off_sql' => '%1$s.Status != 1' ),
													'show_disabled'	=>	Array ('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Status != 0'  ),
												)
											),

					'ListSQLs'			=>	Array (	''=>	'SELECT * FROM %s'),
																		 // key - special, value - list select sql
					'ItemSQLs'			=>	Array (	''=>	'SELECT * FROM %s'),

					'ListSortings'	=> 	Array (
																'' => Array (
																	'Sorting' => Array ('Name' => 'asc'),
																)
															),
					'Fields'			=>	Array (
											    'ShippingID' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
											    'Code' => Array ('type' => 'string', 'not_null' => 1, 'default' => '', 'required'=>true, 'max_len'=>25, 'error_msgs' => Array ('required' => 'Please fill in')),
											    'Name' => Array ('type' => 'string', 'not_null' => 1, 'default' => '', 'required'=>true, 'max_len'=>100, 'error_msgs' => Array ('required' => 'Please fill in')),
											    'SpeedCode' => Array ('type' => 'string', 'not_null' => 1, 'default' => '', 'required' => true, 'max_len' => 25),
											    'LocationFrom' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'Riga', 2 => 'Salaspils', 3 => 'Chicago', 4 => 'Dublin'), 'not_null' => true, 'default' => 1),
											    'Type' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array (1 => 'la_ByWeight', 2 => 'la_ByItem', 3 => 'la_ByAmount', 4 => 'la_Handling'), 'not_null' => true, 'default' => 1),
											    'BaseFee' => Array ('type' => 'float', 'min_value_inc'=>0, 'formatter' => 'kFormatter', 'format' => '%0.2f', 'default' => 0, 'not_null' => true),
											    'CODFlatSurcharge' => Array ('type' => 'float', 'min_value_inc'=>0, 'formatter' => 'kFormatter', 'format' => '%0.2f', 'default' => 0, 'not_null' => true),
											    'CODPercentSurcharge' => Array ('type' => 'float', 'min_value_inc'=>0, 'formatter' => 'kFormatter', 'format' => '%0.2f', 'default' => 0, 'not_null' => true),
												'Status' => Array ('type' => 'int', 'options' => Array ( 1 => 'la_Active', 0 => 'la_Disabled', 2 => 'la_SelectedOnly' ), 'use_phrases' => 1, 'default' => 1, 'not_null' => true ),
												'CostType' => Array ('type' => 'int', 'options' => Array ( 1 => 'la_Flat', 2 => 'la_PerUnit', 3 => 'la_Combined' ), 'use_phrases' => 1, 'default' => 1, 'not_null' => true ),
												'ZeroIfEmpty' => Array ('type' => 'int', 'options' => Array ( 1 => 'la_Zeros', 0 => 'la_NoShipments' ), 'use_phrases' => 1, 'default' => 1, 'not_null' => true ),
												'PrecisionBeforeSep' => Array ('type' => 'int', 'options' => Array ( 1 => '1 digit', 2 => '2 digits', 3 => '3 digits', 4 => '4 digits' ), 'default' => 2, 'not_null' => true ),
												'PrecisionAfterSep' => Array ('type' => 'int', 'options' => Array ( 0 => 'none', 1 => '1 digit', 2 => '2 digits' ), 'default' => 2, 'not_null' => true ),
												'PortalGroups' => Array ('type' => 'string', 'not_null' => 1, 'default' => 0,),
												'FreeShippingMinAmount'	=>	Array ('type' => 'float', 'formatter' => 'kFormatter', 'not_null' => 1, 'format' => '%.2f', 'default' => 0),
												'IsFreePromoShipping' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, 'use_phrases' => 1, 'options' => Array (0 => 'la_No', 1 => 'la_Yes', ), 'formatter' => 'kOptionsFormatter'),
												'InsuranceFee' => Array ('type' => 'float', 'default' => null),
												'InsuranceType' => Array (
													'type' => 'int',
													'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array (2 => 'la_Percent', 1 => 'la_Flat',),
													'not_null' => 1, 'default' => 2
												),
											),

					'Grids'	=> Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'ShippingID' => Array ( 'title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
								'Name' => Array ( 'title' => 'la_col_ShippingName', 'filter_block' => 'grid_range_filter', 'width' => 250, ),
								'Type' => Array ( 'title' => 'la_col_ShippingType', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
								'SpeedCode' => Array ( 'title' => 'la_col_SpeedCode', 'filter_block' => 'grid_like_filter', 'width' => 130, ),
								'BaseFee' => Array ( 'title' => 'la_col_BaseFee', 'filter_block' => 'grid_float_range_filter', 'width' => 100, ),
								'IsFreePromoShipping' => Array ( 'title' => 'la_col_IsFreePromoShipping', 'filter_block' => 'grid_options_filter', 'width' => 70, ),
								'Status' => Array ( 'title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 170, ),
								/*'CODFlatSurcharge' => Array ( 'title' => 'la_col_CODFlatSurcharge', 'filter_block' => 'grid_float_range_filter'),*/
																			),

																),
													),
	);