<?php
/**
* @version	$Id: pricing_config.php 12539 2009-09-16 20:52:41Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'pr',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'PricingEventHandler','file'=>'pricing_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'PricingTagProcessor','file'=>'pricing_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'Hooks'				=>	Array(
												// for tangible products: pricings are always aranged before saveing product
												Array(
													'Mode' => hBEFORE,
													'Conditional' => true,
													'HookToPrefix' => '#PARENT#',
													'HookToSpecial' => '',
													'HookToEvent' => Array('OnPreSave'),
													'DoPrefix' => '',
													'DoSpecial' => 'tang',
													'DoEvent' => 'OnArrange',
												),
											),

					'AggregateTags' => Array(
												Array(
													'AggregateTo' => '#PARENT#',
													'AggregatedTagName' => 'Price',
													'LocalTagName' => 'ProductPrice',
												),
												Array(
													'AggregateTo' => '#PARENT#',
													'AggregatedTagName' => 'ListPriceBrackets',
													'LocalTagName' => 'Product_ListPriceBrackets',
												),
												Array(
													'AggregateTo' => '#PARENT#',
													'AggregatedTagName' => 'HasQuantityPricing',
													'LocalTagName' => 'Product_HasQuantityPricing',
												),
										),

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),
					'StatusField'		=>	Array('IsPrimary'),
					'IDField'			=>	'PriceId',
					'TableName'			=>	TABLE_PREFIX.'ProductsPricing',

					'ForeignKey'		=>	'ProductId',
					'ParentTableKey'	=>	'ProductId',
					'ParentPrefix'		=>	'p',
					'AutoDelete'		=>	true,
					'AutoClone'			=>	true,

					'ListSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('MinQty' => 'asc'),
																)
															),
					'Fields'			=>	Array(
											    'PriceId'		=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
											    'ProductId'		=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
											    'MinQty'		=>	Array('type' => 'int', 'default' => 0),
											    'MaxQty'		=>	Array('type' => 'int', 'default' => 0),
											    'Cost'			=>	Array('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%.2f', 'default' => 0),
											    'Price'			=>	Array('type' => 'float', 'not_null' => 1, 'formatter' => 'kFormatter', 'min_value_inc' => 0, 'format' => '%.2f', 'default' => 0),
											    'Negotiated'	=>	Array('type' => 'int', 'default' => 0),
											    'Points'		=>	Array('type' => 'int', 'default' => 0),
											    'AccessDuration'=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
											    'AccessUnit'	=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array(1 => 'la_opt_sec', 2 => 'la_opt_min', 3 => 'la_opt_hour', 4 => 'la_opt_day', 5 => 'la_opt_week', 6 => 'la_opt_month', 7 => 'la_opt_year'), 'not_null' => 1, 'default' => 0,),
											    'Description'	=>	Array('type' => 'string', 'max_len' => 255, 'default' => NULL),
											    'IsPrimary'		=>	Array('type' => 'int', 'default' => 0, 'not_null' => 1),
											    'GroupId'		=>	Array('type' => 'int', 'default' => 0, 'not_null' => 1),
											//    'AccessRebillDate'				=>	Array('type'=>'integer', 'min_value' => 0, 'max_value' => 31, 'not_null'=>'1', 'default'=>0),
											    // Customization healtheconomics.org
//											    'DurationType' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array(1 => 'la_opt_interval', 2 => 'la_opt_date'), 'not_null' => 1, 'default' => 1),
//											    'AccessExpiration' => Array('type' => 'int', 'formatter' => 'kDateFormatter'),
											    // Customization healtheconomics.org --

											),
					'VirtualFields'	=> 	Array(
													),

					'Grids'	=> Array(
					/*
								'Default'		=>	Array(
																	'Icons' => Array(
																		'default' => 'icon16_item.png',
																		'module' => 'core',
																	),
																	'Fields' => Array(
																			'MinQty' => Array( 'title'=>'la_col_MinQty', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																			'MaxQty' => Array( 'title'=>'la_col_MaxQty', 'filter_block' => 'grid_range_filter'),
																			'Price' => Array( 'title'=>'la_col_Price', 'filter_block' => 'grid_range_filter'),
																			'Points' => Array( 'title'=>'la_col_Points', 'filter_block' => 'grid_range_filter'),
																			'Cost' => Array( 'title'=>'la_col_Cost', 'filter_block' => 'grid_range_filter'),
																			'Negotiated' => Array( 'title'=>'la_col_Negotiated', 'data_block' => 'negotiated_td', 'filter_block' => 'grid_options_filter'),
																			),

																),
					*/
								'Access'		=>	Array(
																	'Icons' => Array('default'=>'icon16_pricing.gif','0'=>'icon16_pricing.gif','1'=>'icon16_pricing_primary.gif'),
																	'Fields' => Array(
																			'AccessDuration' => Array( 'title'=>'la_col_AccessDuration', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																			'AccessUnit' => Array( 'title'=>'la_col_AccessDurationUnit', 'filter_block' => 'grid_options_filter'),
																			'Description' => Array( 'title'=>'la_col_Description', 'filter_block' => 'grid_like_filter'),
																			'Price' => Array( 'title'=>'la_col_Price', 'filter_block' => 'grid_float_range_filter'),
																			),

																),
													),

	);